/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.exceptions.EJBQLException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.SelectNode;
import oracle.toplink.internal.parsing.VariableNode;

public class LocalVariableNode
extends VariableNode {
    public LocalVariableNode() {
    }

    public LocalVariableNode(String string) {
        super(string);
    }

    public Expression addToExpression(Expression expression, GenerationContext generationContext) {
        if (this.isOneToManyAttribute()) {
            if (generationContext.hasMemberOfNode()) {
                return expression.noneOf(this.getVariableName(), new ExpressionBuilder().equal(generationContext.getMemberOfNode().getLeftExpression()));
            }
            return expression.anyOf(this.getVariableName());
        }
        if (generationContext.shouldUseOuterJoins()) {
            return expression.getAllowingNull(this.getVariableName());
        }
        return expression.get(this.getVariableName());
    }

    public Expression generateBaseBuilderExpression(GenerationContext generationContext) {
        if (generationContext.useParallelExpressions()) {
            return new ExpressionBuilder(this.resolveClass(generationContext));
        }
        return new ExpressionBuilder();
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = null;
        expression = generationContext.expressionFor(this.getVariableName());
        if (expression != null) {
            return expression;
        }
        expression = generationContext.getParseTreeContext().hasClassForVariableName(this.getVariableName()) ? (generationContext.getParseTree().getQueryNode().isSelectNode() && ((SelectNode)generationContext.getParseTree().getQueryNode()).hasOneToOneSelected(generationContext) && ((SelectNode)generationContext.getParseTree().getQueryNode()).selectedOneToOneClassIsDeclaredInFROM(this.getVariableName(), generationContext) ? generationContext.getParseTree().getQueryNode().generateExpression(generationContext) : this.generateBaseBuilderExpression(generationContext)) : this.generateExpressionForAlias(generationContext);
        generationContext.addExpression(expression, this.getVariableName());
        return expression;
    }

    public Expression generateExpressionForAlias(GenerationContext generationContext) {
        if (generationContext.getParseTree().getQueryNode().isSelectNode() && generationContext.shouldCheckSelectNodeBeforeResolving() && ((SelectNode)generationContext.getParseTree().getQueryNode()).isSelected(this.getVariableName())) {
            return new ExpressionBuilder();
        }
        Node node = this.getNodeForAlias(generationContext);
        if (node == null) {
            throw EJBQLException.aliasResolutionException(this.getVariableName());
        }
        return node.generateExpression(generationContext);
    }

    public Node getNodeForAlias(GenerationContext generationContext) {
        return generationContext.getParseTreeContext().nodeForIdentifier(this.getVariableName());
    }

    public boolean isLocalVariableNode() {
        return true;
    }

    public void placeNode(Node node) {
        node.placeNode(this);
        this.setComplete(true);
    }
}

