/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.SimpleConditionalExpressionNode;

public class BetweenNode
extends SimpleConditionalExpressionNode {
    protected Node rightForBetween;
    protected Node rightForAnd;

    public boolean containsNode(Node node) {
        boolean bl = false;
        if (this.hasLeft()) {
            boolean bl2 = bl = this.getLeft().containsNode(node) || this.getLeft() == node;
        }
        if (this.hasRightForBetween() && !bl) {
            boolean bl3 = bl = this.getRightForBetween().containsNode(node) || this.getRightForBetween() == node;
        }
        if (this.hasRightForAnd() && !bl) {
            bl = this.getRightForAnd().containsNode(node) || this.getRightForAnd() == node;
        }
        return bl;
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = expression.between(this.getRightForBetween().generateExpression(generationContext), this.getRightForAnd().generateExpression(generationContext));
        return expression;
    }

    public Node getRightForAnd() {
        return this.rightForAnd;
    }

    public Node getRightForBetween() {
        return this.rightForBetween;
    }

    public boolean hasRightForAnd() {
        return this.rightForAnd != null;
    }

    public boolean hasRightForBetween() {
        return this.rightForBetween != null;
    }

    public void placeNode(Node node) {
        if (!this.hasLeft()) {
            this.setLeft(node);
        } else if (!this.hasRightForBetween()) {
            this.setRightForBetween(node);
        } else if (!this.hasRightForAnd()) {
            this.setRightForAnd(node);
        } else {
            node.placeNode(this);
        }
    }

    public void setRightForAnd(Node node) {
        this.rightForAnd = node;
    }

    public void setRightForBetween(Node node) {
        this.rightForBetween = node;
    }
}

