/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.record.DOMUnmarshaller;
import oracle.toplink.internal.ox.record.PlatformUnmarshaller;
import oracle.toplink.internal.ox.record.SAXUnmarshallerHandler;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLUnmarshaller;
import oracle.toplink.ox.record.UnmarshalRecord;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.sessions.DatabaseSession;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXUnmarshaller
implements PlatformUnmarshaller {
    private static final String VALIDATING = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int validationMode;
    private Object[] schemas;
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private XMLTransformer xmlTransformer;
    private XMLContext xmlContext;
    private DOMUnmarshaller domUnmarshaller;
    static /* synthetic */ Class class$oracle$toplink$exceptions$TopLinkException;

    public SAXUnmarshaller(XMLContext xMLContext) throws XMLMarshalException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            this.saxParser = sAXParserFactory.newSAXParser();
            this.xmlReader = this.saxParser.getXMLReader();
            this.xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
            this.xmlContext = xMLContext;
            this.domUnmarshaller = new DOMUnmarshaller(xMLContext);
        }
        catch (Exception exception) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(exception);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.xmlReader.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
        this.domUnmarshaller.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
        this.domUnmarshaller.setErrorHandler(errorHandler);
    }

    public int getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(int n) {
        this.domUnmarshaller.setValidationMode(n);
        try {
            this.validationMode = n;
            switch (n) {
                case 0: {
                    this.xmlReader.setFeature(VALIDATING, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(VALIDATING, true);
                    break;
                }
                case 3: {
                    try {
                        this.xmlReader.setFeature(VALIDATING, true);
                        this.saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
                        this.saxParser.setProperty(SCHEMA_SOURCE, this.schemas);
                        break;
                    }
                    catch (Exception exception) {
                        this.xmlReader.setFeature(VALIDATING, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWhitespacePreserving(boolean bl) {
        this.domUnmarshaller.setWhitespacePreserving(bl);
    }

    public void setSchemas(Object[] objectArray) {
        this.schemas = objectArray;
        this.domUnmarshaller.setSchemas(objectArray);
    }

    public Object unmarshal(File file, XMLUnmarshaller xMLUnmarshaller) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.unmarshal(fileInputStream, xMLUnmarshaller);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw XMLMarshalException.unmarshalException(fileNotFoundException);
        }
    }

    public Object unmarshal(File file, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.unmarshal(fileInputStream, clazz, xMLUnmarshaller);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw XMLMarshalException.unmarshalException(fileNotFoundException);
        }
    }

    public Object unmarshal(InputStream inputStream, XMLUnmarshaller xMLUnmarshaller) {
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, xMLUnmarshaller);
    }

    public Object unmarshal(InputStream inputStream, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, clazz, xMLUnmarshaller);
    }

    public Object unmarshal(InputSource inputSource, XMLUnmarshaller xMLUnmarshaller) {
        try {
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlContext);
            sAXUnmarshallerHandler.setXMLReader(this.xmlReader);
            sAXUnmarshallerHandler.setUnmarshaller(xMLUnmarshaller);
            this.xmlReader.setContentHandler(sAXUnmarshallerHandler);
            this.xmlReader.parse(inputSource);
            return sAXUnmarshallerHandler.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(InputSource inputSource, XMLReader xMLReader, XMLUnmarshaller xMLUnmarshaller) {
        try {
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlContext);
            sAXUnmarshallerHandler.setXMLReader(xMLReader);
            sAXUnmarshallerHandler.setUnmarshaller(xMLUnmarshaller);
            xMLReader.setContentHandler(sAXUnmarshallerHandler);
            xMLReader.parse(inputSource);
            return sAXUnmarshallerHandler.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            DatabaseSession databaseSession = this.xmlContext.getSession(clazz);
            XMLDescriptor xMLDescriptor = (XMLDescriptor)databaseSession.getDescriptor(clazz);
            UnmarshalRecord unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(databaseSession);
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(xMLUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            this.xmlReader.parse(inputSource);
            return unmarshalRecord.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLReader xMLReader, XMLUnmarshaller xMLUnmarshaller) {
        try {
            DatabaseSession databaseSession = this.xmlContext.getSession(clazz);
            XMLDescriptor xMLDescriptor = (XMLDescriptor)databaseSession.getDescriptor(clazz);
            UnmarshalRecord unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(databaseSession);
            unmarshalRecord.setXMLReader(xMLReader);
            unmarshalRecord.setUnmarshaller(xMLUnmarshaller);
            xMLReader.setContentHandler(unmarshalRecord);
            xMLReader.parse(inputSource);
            return unmarshalRecord.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(Node node, XMLUnmarshaller xMLUnmarshaller) {
        return this.domUnmarshaller.unmarshal(node, xMLUnmarshaller);
    }

    public Object unmarshal(Node node, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        return this.domUnmarshaller.unmarshal(node, clazz, xMLUnmarshaller);
    }

    public Object unmarshal(Reader reader, XMLUnmarshaller xMLUnmarshaller) {
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, xMLUnmarshaller);
    }

    public Object unmarshal(Reader reader, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, clazz, xMLUnmarshaller);
    }

    public Object unmarshal(Source source, XMLUnmarshaller xMLUnmarshaller) {
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (null == xMLReader) {
                return this.unmarshal(sAXSource.getInputSource(), xMLUnmarshaller);
            }
            return this.unmarshal(sAXSource.getInputSource(), xMLReader, xMLUnmarshaller);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            return this.unmarshal(dOMSource.getNode(), xMLUnmarshaller);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader(), xMLUnmarshaller);
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream(), xMLUnmarshaller);
            }
            return this.unmarshal(streamSource.getSystemId(), xMLUnmarshaller);
        }
        return null;
    }

    public Object unmarshal(Source source, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        if (source instanceof SAXSource) {
            SAXSource sAXSource = (SAXSource)source;
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (null == xMLReader) {
                return this.unmarshal(sAXSource.getInputSource(), clazz, xMLUnmarshaller);
            }
            return this.unmarshal(sAXSource.getInputSource(), clazz, xMLReader, xMLUnmarshaller);
        }
        if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            return this.unmarshal(dOMSource.getNode(), clazz, xMLUnmarshaller);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader(), clazz, xMLUnmarshaller);
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream(), clazz, xMLUnmarshaller);
            }
            return this.unmarshal(streamSource.getSystemId(), clazz, xMLUnmarshaller);
        }
        return null;
    }

    public Object unmarshal(URL uRL, XMLUnmarshaller xMLUnmarshaller) {
        try {
            InputStream inputStream = uRL.openStream();
            return this.unmarshal(inputStream, xMLUnmarshaller);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
    }

    public Object unmarshal(URL uRL, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            InputStream inputStream = uRL.openStream();
            return this.unmarshal(inputStream, clazz, xMLUnmarshaller);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
    }

    public Object unmarshal(String string, XMLUnmarshaller xMLUnmarshaller) {
        try {
            SAXUnmarshallerHandler sAXUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlContext);
            sAXUnmarshallerHandler.setXMLReader(this.xmlReader);
            sAXUnmarshallerHandler.setUnmarshaller(xMLUnmarshaller);
            this.xmlReader.setContentHandler(sAXUnmarshallerHandler);
            this.xmlReader.parse(string);
            return sAXUnmarshallerHandler.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    public Object unmarshal(String string, Class clazz, XMLUnmarshaller xMLUnmarshaller) {
        try {
            DatabaseSession databaseSession = this.xmlContext.getSession(clazz);
            XMLDescriptor xMLDescriptor = (XMLDescriptor)databaseSession.getDescriptor(clazz);
            UnmarshalRecord unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord();
            unmarshalRecord.setSession(databaseSession);
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(xMLUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            this.xmlReader.parse(string);
            return unmarshalRecord.getObject();
        }
        catch (IOException iOException) {
            throw XMLMarshalException.unmarshalException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.convertSAXException(sAXException);
        }
    }

    private TopLinkException convertSAXException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception != null) {
            if ((class$oracle$toplink$exceptions$TopLinkException == null ? (class$oracle$toplink$exceptions$TopLinkException = SAXUnmarshaller.class$("oracle.toplink.exceptions.TopLinkException")) : class$oracle$toplink$exceptions$TopLinkException).isAssignableFrom(exception.getClass())) {
                return (TopLinkException)exception;
            }
            return XMLMarshalException.unmarshalException(exception);
        }
        return XMLMarshalException.unmarshalException(sAXException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

