/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.ox.NodeValue;
import oracle.toplink.internal.ox.XMLConversionManager;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.XMLUnionField;

public abstract class XMLSimpleMappingNodeValue
extends NodeValue {
    protected String getValueToWrite(QName qName, Object object) {
        return (String)XMLConversionManager.getDefaultXMLManager().convertObject(object, ClassConstants.STRING, qName);
    }

    protected QName getSchemaType(XMLField xMLField, Object object) {
        QName qName = null;
        if (xMLField.isTypedTextField()) {
            qName = xMLField.getXMLType(object.getClass());
        } else {
            if (xMLField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xMLField, object);
            }
            if (xMLField.getSchemaType() != null) {
                qName = xMLField.getSchemaType();
            }
        }
        return qName;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xMLUnionField, Object object) {
        ArrayList arrayList = xMLUnionField.getSchemaTypes();
        QName qName = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            QName qName2 = (QName)xMLUnionField.getSchemaTypes().get(i);
            try {
                if (qName2 == null) continue;
                Class clazz = xMLUnionField.getJavaClass(qName2);
                object = XMLConversionManager.getDefaultXMLManager().convertObject(object, clazz, qName2);
                qName = qName2;
                break;
            }
            catch (ConversionException conversionException) {
                if (i != arrayList.size() - 1) continue;
                qName = qName2;
            }
        }
        return qName;
    }
}

