/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;

public abstract class UnitOfWorkValueHolder
extends DatabaseValueHolder {
    protected transient ValueHolderInterface wrappedValueHolder;
    protected transient DatabaseMapping mapping;
    protected ValueHolder backupValueHolder;
    protected UnitOfWork remoteUnitOfWork;
    protected Object sourceObject;
    protected transient Object relationshipSourceObject;
    protected String sourceAttributeName;
    protected ObjID wrappedValueHolderRemoteID;

    protected UnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, DatabaseMapping databaseMapping, UnitOfWork unitOfWork) {
        this.wrappedValueHolder = valueHolderInterface;
        this.mapping = databaseMapping;
        this.session = unitOfWork;
        this.sourceAttributeName = databaseMapping.getAttributeName();
        this.relationshipSourceObject = object;
        if (unitOfWork.isRemoteUnitOfWork()) {
            if (valueHolderInterface instanceof RemoteValueHolder) {
                this.wrappedValueHolderRemoteID = ((RemoteValueHolder)valueHolderInterface).getID();
            }
            this.remoteUnitOfWork = unitOfWork;
            this.sourceObject = object;
        }
    }

    protected abstract Object buildBackupCloneFor(Object var1);

    public abstract Object buildCloneFor(Object var1);

    protected ValueHolder getBackupValueHolder() {
        return this.backupValueHolder;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected UnitOfWork getRemoteUnitOfWork() {
        return this.remoteUnitOfWork;
    }

    protected String getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    protected Object getSourceObject() {
        return this.sourceObject;
    }

    protected Object getRelationshipSourceObject() {
        return this.relationshipSourceObject;
    }

    protected UnitOfWork getUnitOfWork() {
        return (UnitOfWork)this.getSession();
    }

    protected Object getValueFromServerObject() {
        this.setSession(this.getRemoteUnitOfWork());
        Vector vector = this.getSession().keyFromObject(this.getSourceObject());
        Object object = this.getUnitOfWork().getParent().getIdentityMapAccessor().getFromIdentityMap(vector, this.getSourceObject().getClass());
        if (object == null) {
            object = this.getUnitOfWork().getParent().readObject(this.getSourceObject());
        }
        Descriptor descriptor = this.getSession().getDescriptor(object);
        DatabaseMapping databaseMapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.getSourceAttributeName());
        this.setMapping(databaseMapping);
        return this.getMapping().getRealAttributeValueFromObject(object, this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiateImpl() {
        Object object;
        if (this.getWrappedValueHolder() instanceof DatabaseValueHolder) {
            object = this.getWrappedValueHolder();
            synchronized (object) {
                DatabaseValueHolder databaseValueHolder = (DatabaseValueHolder)this.getWrappedValueHolder();
                UnitOfWork unitOfWork = this.getUnitOfWork();
                if (!databaseValueHolder.isEasilyInstantiated()) {
                    if (databaseValueHolder.isPessimisticLockingValueHolder()) {
                        if (!unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                            unitOfWork.beginEarlyTransaction();
                        }
                        unitOfWork.log(1, "transaction", "instantiate_pl_relationship");
                    }
                    if (unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely()) {
                        return databaseValueHolder.instantiateForUnitOfWorkValueHolder(this);
                    }
                }
            }
        }
        object = this.getWrappedValueHolder().getValue();
        return this.buildCloneFor(object);
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated() || this.getWrappedValueHolder() != null && this.getWrappedValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedValueHolder()).isEasilyInstantiated();
    }

    public boolean isPessimisticLockingValueHolder() {
        return this.getWrappedValueHolder() != null && this.getWrappedValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedValueHolder()).isPessimisticLockingValueHolder();
    }

    public ValueHolderInterface getWrappedValueHolder() {
        return this.wrappedValueHolder;
    }

    public ObjID getWrappedValueHolderRemoteID() {
        return this.wrappedValueHolderRemoteID;
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return this.getRemoteUnitOfWork() != null && this.getRemoteUnitOfWork().getParent() != null && this.getWrappedValueHolder() == null;
    }

    protected Object instantiate() {
        Object object;
        UnitOfWork unitOfWork = this.isSerializedRemoteUnitOfWorkValueHolder() ? this.getRemoteUnitOfWork() : this.getUnitOfWork();
        if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "ValueHolder.instantiate()");
        }
        if (this.isSerializedRemoteUnitOfWorkValueHolder()) {
            Object object2 = this.getValueFromServerObject();
            object = this.buildCloneFor(object2);
        } else {
            object = this.instantiateImpl();
        }
        if (this.getBackupValueHolder() != null) {
            this.getBackupValueHolder().setValue(this.buildBackupCloneFor(object));
        }
        return object;
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate();
    }

    public void releaseWrappedValueHolder() {
    }

    protected void resetFields() {
    }

    public void setBackupValueHolder(ValueHolder valueHolder) {
        this.backupValueHolder = valueHolder;
    }

    protected void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    protected void setRemoteUnitOfWork(UnitOfWork unitOfWork) {
        this.remoteUnitOfWork = unitOfWork;
    }

    protected void setSourceAttributeName(String string) {
        this.sourceAttributeName = string;
    }

    protected void setSourceObject(Object object) {
        this.sourceObject = object;
    }

    protected void setRelationshipSourceObject(Object object) {
        this.relationshipSourceObject = object;
    }

    protected void setWrappedValueHolder(DatabaseValueHolder databaseValueHolder) {
        this.wrappedValueHolder = databaseValueHolder;
    }
}

