/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.lang.reflect.InvocationTargetException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.mappings.transformers.AttributeTransformer;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;

public class TransformerBasedValueHolder
extends DatabaseValueHolder {
    protected transient AttributeTransformer transformer;
    protected transient Object object;

    public TransformerBasedValueHolder(AttributeTransformer attributeTransformer, Object object, DatabaseRow databaseRow, Session session) {
        this.row = databaseRow;
        this.session = session;
        if (!this.session.isUnitOfWork()) {
            this.session = this.session.getRootSession(null);
        }
        this.transformer = attributeTransformer;
        this.object = object;
    }

    protected AttributeTransformer getTransformer() {
        return this.transformer;
    }

    protected Object getObject() {
        return this.object;
    }

    protected Object instantiate() throws DescriptorException {
        return this.instantiate(this.getObject(), this.getSession());
    }

    protected Object instantiate(Object object, Session session) throws DescriptorException {
        try {
            return this.transformer.buildAttributeValue(this.getRow(), object, session);
        }
        catch (DescriptorException descriptorException) {
            Throwable throwable = descriptorException.getInternalException();
            if (throwable instanceof IllegalAccessException) {
                throw DescriptorException.illegalAccessWhileInstantiatingMethodBasedProxy(throwable);
            }
            if (throwable instanceof IllegalArgumentException) {
                throw DescriptorException.illegalArgumentWhileInstantiatingMethodBasedProxy(throwable);
            }
            if (throwable instanceof InvocationTargetException) {
                throw DescriptorException.targetInvocationWhileInstantiatingMethodBasedProxy(throwable);
            }
            throw descriptorException;
        }
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(this.getObject(), unitOfWorkValueHolder.getUnitOfWork());
    }

    public boolean isPessimisticLockingValueHolder() {
        return false;
    }

    protected void setTransformer(AttributeTransformer attributeTransformer) {
        this.transformer = attributeTransformer;
    }

    protected void setObject(Object object) {
        this.object = object;
    }
}

