/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.lang.reflect.Proxy;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.indirection.BackupValueHolder;
import oracle.toplink.internal.indirection.BasicIndirectionPolicy;
import oracle.toplink.internal.indirection.BatchValueHolder;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.ProxyIndirectionHandler;
import oracle.toplink.internal.indirection.QueryBasedValueHolder;
import oracle.toplink.internal.indirection.TransformerBasedValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.remote.RemoteSession;

public class ProxyIndirectionPolicy
extends BasicIndirectionPolicy {
    private Class[] targetInterfaces;

    public ProxyIndirectionPolicy(Class[] classArray) {
        this.targetInterfaces = classArray;
    }

    public ProxyIndirectionPolicy() {
        this.targetInterfaces = new Class[0];
    }

    public void initialize() {
    }

    public boolean hasTargetInterfaces() {
        return this.targetInterfaces != null && this.targetInterfaces.length != 0;
    }

    public Object valueFromRow(Object object) {
        ValueHolder valueHolder = new ValueHolder(object);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolder);
    }

    public Object valueFromQuery(ReadQuery readQuery, DatabaseRow databaseRow, Session session) {
        Descriptor descriptor = null;
        try {
            descriptor = session.getDescriptor(readQuery.getReferenceClass());
            if (descriptor.isDescriptorForInterface()) {
                descriptor = (Descriptor)descriptor.getInterfacePolicy().getChildDescriptors().firstElement();
            }
        }
        catch (Exception exception) {
            return null;
        }
        QueryBasedValueHolder queryBasedValueHolder = new QueryBasedValueHolder(readQuery, databaseRow, session);
        return ProxyIndirectionHandler.newProxyInstance(descriptor.getJavaClass(), this.targetInterfaces, queryBasedValueHolder);
    }

    public Object valueFromMethod(Object object, DatabaseRow databaseRow, Session session) {
        TransformerBasedValueHolder transformerBasedValueHolder = new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, databaseRow, session);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, transformerBasedValueHolder);
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) {
        Object object;
        Cloneable cloneable;
        try {
            cloneable = objectLevelReadQuery.getDescriptor();
            if (cloneable.isDescriptorForInterface()) {
                cloneable = (Descriptor)objectLevelReadQuery.getDescriptor().getInterfacePolicy().getChildDescriptors().firstElement();
            }
            object = PrivilegedAccessController.newInstanceFromClass(cloneable.getJavaClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        cloneable = new BatchValueHolder(readQuery, databaseRow, this.getForeignReferenceMapping(), objectLevelReadQuery);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, (ValueHolderInterface)((Object)cloneable));
    }

    public boolean objectIsInstantiated(Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
            return valueHolderInterface.isInstantiated();
        }
        return true;
    }

    public Object nullValueFromRow() {
        return null;
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        this.getMapping().setAttributeValueInObject(object, object2);
    }

    public Object getRealAttributeValueFromObject(Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
            return valueHolderInterface.getValue();
        }
        return object;
    }

    public static Object getValueFromProxy(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            return ((ProxyIndirectionHandler)Proxy.getInvocationHandler(object)).getValueHolder().getValue();
        }
        return object;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        this.getMapping().setAttributeValueInObject(object, object2);
    }

    public Object getOriginalIndirectionObject(Object object, Session session) {
        if (object instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)object).getWrappedValueHolder();
            if (valueHolderInterface == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)object).getWrappedValueHolderRemoteID());
            }
            return valueHolderInterface;
        }
        if (object == null) {
            System.out.println("Debug line");
        }
        return object;
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    public DatabaseRow extractReferenceRow(Object object) {
        if (object == null || !Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
        ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
        if (valueHolderInterface.isInstantiated()) {
            return null;
        }
        return ((DatabaseValueHolder)valueHolderInterface).getRow();
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        Cloneable cloneable;
        if (!(object instanceof Proxy)) {
            boolean bl2 = unitOfWork.isObjectRegistered(object3) && !unitOfWork.isOriginalNewObject(object2);
            return this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWork, bl2);
        }
        ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
        ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
        if (!bl && unitOfWork.isOriginalNewObject(object2)) {
            if (valueHolderInterface instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolderInterface).isInstantiated() && ((DatabaseValueHolder)valueHolderInterface).getSession() == null && !((DatabaseValueHolder)valueHolderInterface).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(object2, this.getMapping());
            }
            cloneable = new ValueHolder();
            cloneable.setValue(this.getMapping().buildCloneForPartObject(valueHolderInterface.getValue(), object2, object3, unitOfWork, false));
        } else {
            DatabaseRow databaseRow = null;
            if (valueHolderInterface instanceof DatabaseValueHolder) {
                databaseRow = ((DatabaseValueHolder)valueHolderInterface).getRow();
            }
            cloneable = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, databaseRow, unitOfWork, bl);
        }
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, cloneable);
    }

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        if (!(object instanceof Proxy)) {
            return this.getMapping().buildBackupCloneForPartObject(object, object2, object3, unitOfWork);
        }
        ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
        ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
        ValueHolderInterface valueHolderInterface2 = null;
        if (!(valueHolderInterface instanceof UnitOfWorkValueHolder) || valueHolderInterface.isInstantiated()) {
            valueHolderInterface2 = (ValueHolderInterface)super.backupCloneAttribute(valueHolderInterface, object2, object3, unitOfWork);
        } else {
            valueHolderInterface2 = new BackupValueHolder(valueHolderInterface);
            ((UnitOfWorkValueHolder)valueHolderInterface).setBackupValueHolder((ValueHolder)valueHolderInterface2);
        }
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolderInterface2);
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler proxyIndirectionHandler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface valueHolderInterface = proxyIndirectionHandler.getValueHolder();
            descriptorIterator.iterateValueHolderForMapping(valueHolderInterface, this.getMapping());
        } else if (object != null) {
            this.getMapping().iterateOnRealAttributeValue(descriptorIterator, object);
        }
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (object != null && object.getClass().getInterfaces().length == 0 && object instanceof Proxy) {
            System.err.println("** ProxyIndirection attribute validation failed.");
        }
        return object;
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        if (!this.isValidType(clazz)) {
            integrityChecker.handleError(DescriptorException.invalidAttributeTypeForProxyIndirection(clazz, this.targetInterfaces, this.getMapping()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        if (!this.isValidType(clazz)) {
            integrityChecker.handleError(DescriptorException.invalidGetMethodReturnTypeForProxyIndirection(clazz, this.targetInterfaces, this.getMapping()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        if (!this.isValidType(clazz)) {
            integrityChecker.handleError(DescriptorException.invalidSetMethodParameterTypeForProxyIndirection(clazz, this.targetInterfaces, this.getMapping()));
        }
    }

    public boolean isValidType(Class clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        for (int i = 0; i < this.targetInterfaces.length; ++i) {
            if (clazz != this.targetInterfaces[i]) continue;
            return true;
        }
        return false;
    }
}

