/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.indirection.IndirectionPolicy;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.remote.RemoteSession;

public class NoIndirectionPolicy
extends IndirectionPolicy {
    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        if (bl) {
            return object;
        }
        boolean bl2 = unitOfWork.isObjectRegistered(object3) && !unitOfWork.isOriginalNewObject(object2);
        return this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWork, bl2);
    }

    protected boolean collectionTypeIsValid(Class clazz) {
        return this.getCollectionMapping().getContainerPolicy().isValidContainerType(clazz);
    }

    public DatabaseRow extractReferenceRow(Object object) {
        return null;
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        this.getMapping().fixRealObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
    }

    public Object getOriginalIndirectionObject(Object object, Session session) {
        return object;
    }

    public Object getRealAttributeValueFromObject(Object object) {
        return object;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        throw DescriptorException.invalidIndirectionPolicyOperation(this, "getValueFromRemoteValueHolder");
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        throw DescriptorException.invalidIndirectionPolicyOperation(this, "mergeRemoteValueHolder");
    }

    public Object nullValueFromRow() {
        return null;
    }

    public boolean objectIsInstantiated(Object object) {
        return true;
    }

    protected boolean typeIsValid(Class clazz) {
        return clazz != ClassConstants.ValueHolderInterface_Class;
    }

    public boolean usesIndirection() {
        return false;
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeAndMappingWithoutIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateDeclaredAttributeTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeTypeForCollection(clazz, integrityChecker);
        if (!this.collectionTypeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeTypeNotValid(this.getCollectionMapping()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.returnAndMappingWithoutIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateGetMethodReturnTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnTypeForCollection(clazz, integrityChecker);
        if (!this.collectionTypeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.getMethodReturnTypeNotValid(this.getCollectionMapping()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.parameterAndMappingWithoutIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateSetMethodParameterTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterTypeForCollection(clazz, integrityChecker);
        if (!this.collectionTypeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.setMethodParameterTypeNotValid(this.getCollectionMapping()));
        }
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) {
        return this.getForeignReferenceMapping().extractResultFromBatchQuery(readQuery, databaseRow, objectLevelReadQuery.getSession(), objectLevelReadQuery.getTranslationRow());
    }

    public Object valueFromMethod(Object object, DatabaseRow databaseRow, Session session) {
        return this.getTransformationMapping().invokeAttributeTransformer(databaseRow, object, session);
    }

    public Object valueFromQuery(ReadQuery readQuery, DatabaseRow databaseRow, Session session) {
        return session.executeQuery((DatabaseQuery)readQuery, databaseRow);
    }

    public Object valueFromRow(Object object) {
        return object;
    }
}

