/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.identitymaps;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.identitymaps.CacheKey;

public abstract class IdentityMap
implements Serializable,
Cloneable {
    protected int maxSize;
    protected CacheKey searchKey;

    public IdentityMap(int n) {
        this.maxSize = n;
        this.searchKey = new CacheKey(new Vector(1), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireDeferredLock(Vector vector) {
        CacheKey cacheKey = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            cacheKey = this.getCacheKey(vector);
            if (cacheKey == null) {
                CacheKey cacheKey2 = this.createCacheKey(vector, null, null);
                cacheKey2.acquireDeferredLock();
                this.put(cacheKey2);
                return cacheKey2;
            }
        }
        cacheKey.acquireDeferredLock();
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLock(Vector vector, boolean bl) {
        CacheKey cacheKey = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            cacheKey = this.getCacheKey(vector);
            if (cacheKey == null) {
                CacheKey cacheKey2 = this.createCacheKey(vector, null, null);
                cacheKey2.acquire(bl);
                this.put(cacheKey2);
                return cacheKey2;
            }
        }
        cacheKey.acquire();
        return cacheKey;
    }

    public abstract void collectLocks(HashMap var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockNoWait(Vector vector, boolean bl) {
        CacheKey cacheKey = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            cacheKey = this.getCacheKey(vector);
            if (cacheKey == null) {
                CacheKey cacheKey2 = this.createCacheKey(vector, null, null);
                cacheKey2.acquire(bl);
                this.put(cacheKey2);
                return cacheKey2;
            }
        }
        if (cacheKey != null && !cacheKey.acquireNoWait(bl)) {
            cacheKey = null;
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKey(Vector vector) {
        CacheKey cacheKey = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            cacheKey = this.getCacheKey(vector);
            if (cacheKey == null) {
                CacheKey cacheKey2 = this.createCacheKey(vector, null, null);
                cacheKey2.acquireReadLock();
                return cacheKey2;
            }
        }
        cacheKey.acquireReadLock();
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector) {
        CacheKey cacheKey = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            cacheKey = this.getCacheKey(vector);
            if (cacheKey == null) {
                CacheKey cacheKey2 = this.createCacheKey(vector, null, null);
                cacheKey2.acquireReadLock();
                return cacheKey2;
            }
        }
        if (cacheKey != null && !cacheKey.acquireReadLockNoWait()) {
            cacheKey = null;
        }
        return cacheKey;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public boolean containsKey(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        return cacheKey != null;
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2) {
        return this.createCacheKey(vector, object, object2, 0L);
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new CacheKey(vector, object, object2, l);
    }

    public abstract Enumeration elements();

    public Object get(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheKey getCacheKey(Vector vector) {
        CacheKey cacheKey = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            this.getSearchKey().setKey(vector);
            cacheKey = this.getCacheKey(this.getSearchKey());
        }
        return cacheKey;
    }

    protected abstract CacheKey getCacheKey(CacheKey var1);

    protected CacheKey getCacheKeyWithReadLock(Vector vector) {
        CacheKey cacheKey = this.getCacheKey(vector);
        if (cacheKey != null) {
            cacheKey.acquireReadLock();
            cacheKey.releaseReadLock();
        }
        return cacheKey;
    }

    public static Class getDefaultIdentityMapClass() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public int getMaxSize() {
        if (this.maxSize == -1) {
            this.maxSize = 100;
        }
        return this.maxSize;
    }

    protected CacheKey getSearchKey() {
        return this.searchKey;
    }

    public abstract int getSize();

    public abstract int getSize(Class var1, boolean var2);

    public Object getWrapper(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWrapper();
    }

    public Object getWriteLockValue(Vector vector) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(vector);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWriteLockValue();
    }

    public void initialize(int n) {
        this.setMaxSize(n);
    }

    public abstract Enumeration keys();

    public abstract CacheKey put(Vector var1, Object var2, Object var3, long var4);

    protected abstract void put(CacheKey var1);

    public Object remove(Vector vector) {
        CacheKey cacheKey = this.getCacheKey(vector);
        return this.remove(cacheKey);
    }

    public abstract Object remove(CacheKey var1);

    protected void setMaxSize(int n) {
        this.maxSize = n;
    }

    public synchronized void updateMaxSize(int n) {
        this.setMaxSize(n);
    }

    protected void setSearchKey(CacheKey cacheKey) {
        this.searchKey = cacheKey;
    }

    public void setWrapper(Vector vector, Object object) {
        CacheKey cacheKey = this.getCacheKey(vector);
        if (cacheKey != null) {
            cacheKey.setWrapper(object);
        }
    }

    public void setWriteLockValue(Vector vector, Object object) {
        CacheKey cacheKey = this.getCacheKey(vector);
        if (cacheKey != null) {
            cacheKey.acquire();
            cacheKey.setWriteLockValue(object);
            cacheKey.release();
        }
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "[" + this.getSize() + "]";
    }

    public void updateCacheKey(CacheKey cacheKey) {
    }
}

