/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.identitymaps;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.sessions.Record;

public class CacheKey
implements Serializable,
Cloneable {
    protected Vector key;
    protected int hash;
    protected Object object;
    protected IdentityMap mapOwner;
    protected Object writeLockValue;
    protected Object wrapper;
    protected ConcurrencyManager mutex;
    protected Record record;
    protected long lastUpdatedQueryId;
    protected int invalidationState = 0;
    public static final int CHECK_INVALIDATION_POLICY = 0;
    public static final int CACHE_KEY_INVALID = -1;
    protected long readTime = 0L;

    public CacheKey(Vector vector) {
        this.key = vector;
        this.hash = this.computeHash(vector);
    }

    public CacheKey(Vector vector, Object object, Object object2) {
        this(vector);
        this.setObject(object);
        this.writeLockValue = object2;
    }

    public CacheKey(Vector vector, Object object, Object object2, long l) {
        this(vector, object, object2);
        this.readTime = l;
    }

    public void acquire() {
        this.getMutex().acquire(false);
    }

    public void acquire(boolean bl) {
        this.getMutex().acquire(bl);
    }

    public boolean acquireNoWait() {
        return this.getMutex().acquireNoWait(false);
    }

    public boolean acquireNoWait(boolean bl) {
        return this.getMutex().acquireNoWait(bl);
    }

    public void acquireDeferredLock() {
        this.getMutex().acquireDeferredLock();
    }

    public void checkReadLock() {
        this.getMutex().checkReadLock();
    }

    public void acquireReadLock() {
        this.getMutex().acquireReadLock();
    }

    public boolean acquireReadLockNoWait() {
        return this.getMutex().acquireReadLockNoWait();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        return object;
    }

    protected int computeHash(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e == null) continue;
            n ^= e.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CacheKey) {
            return this.equals((CacheKey)object);
        }
        return false;
    }

    public boolean equals(CacheKey cacheKey) {
        if (this == cacheKey) {
            return true;
        }
        if (this.getKey().size() == cacheKey.getKey().size()) {
            for (int i = 0; i < this.getKey().size(); ++i) {
                Object e = this.getKey().elementAt(i);
                Object e2 = cacheKey.getKey().elementAt(i);
                if (e == null) {
                    if (e2 == null) continue;
                    return false;
                }
                if (e.getClass().isArray()) {
                    if (e.getClass() == ClassConstants.APBYTE && e2.getClass() == ClassConstants.APBYTE && Helper.compareByteArrays((byte[])e, (byte[])e2)) {
                        return false;
                    }
                    if (e.getClass() == ClassConstants.APCHAR && e2.getClass() == ClassConstants.APCHAR && Helper.compareCharArrays((char[])e, (char[])e2)) {
                        return false;
                    }
                    if (!Helper.compareArrays((Object[])e, (Object[])e2)) continue;
                    return false;
                }
                if (e.equals(e2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public long getLastUpdatedQueryId() {
        return this.lastUpdatedQueryId;
    }

    public Vector getKey() {
        return this.key;
    }

    public synchronized ConcurrencyManager getMutex() {
        if (this.mutex == null) {
            this.mutex = new ConcurrencyManager(this);
        }
        return this.mutex;
    }

    public Object getObject() {
        return this.object;
    }

    public IdentityMap getOwningMap() {
        return this.mapOwner;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAcquired() {
        return this.getMutex().isAcquired();
    }

    public int getInvalidationState() {
        return this.invalidationState;
    }

    public void release() {
        this.getMutex().release();
    }

    public void releaseDeferredLock() {
        this.getMutex().releaseDeferredLock();
    }

    public void releaseReadLock() {
        this.getMutex().releaseReadLock();
    }

    public void setInvalidationState(int n) {
        this.invalidationState = n;
    }

    public void setLastUpdatedQueryId(long l) {
        this.lastUpdatedQueryId = l;
    }

    public void setKey(Vector vector) {
        this.key = vector;
        this.hash = this.computeHash(vector);
    }

    public void setMutex(ConcurrencyManager concurrencyManager) {
        this.mutex = concurrencyManager;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setOwningMap(IdentityMap identityMap) {
        this.mapOwner = identityMap;
    }

    public void setReadTime(long l) {
        this.readTime = l;
        this.invalidationState = 0;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void setWrapper(Object object) {
        this.wrapper = object;
    }

    public void setWriteLockValue(Object object) {
        this.writeLockValue = object;
    }

    public String toString() {
        int n = 0;
        if (this.getObject() != null) {
            n = this.getObject().hashCode();
        }
        return "[" + this.getKey() + ": " + n + ": " + this.getWriteLockValue() + ": " + this.getReadTime() + ": " + this.getObject() + "]";
    }

    public void updateAccess() {
    }
}

