/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper.linkedlist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.linkedlist.LinkedNode;

public class ExposedNodeLinkedList
implements List {
    private transient LinkedNode header;
    private transient int size = 0;

    public ExposedNodeLinkedList() {
        this.header.next = this.header = new LinkedNode(null, null, null);
        this.header.previous = this.header;
    }

    public Object[] toArray(Object[] objectArray) {
        throw ValidationException.operationNotSupported("toArray");
    }

    public Object[] toArray() {
        throw ValidationException.operationNotSupported("toArray");
    }

    public Object set(int n, Object object) {
        throw ValidationException.operationNotSupported("set");
    }

    public ListIterator listIterator(int n) {
        throw ValidationException.operationNotSupported("listIterator");
    }

    public ListIterator listIterator() {
        throw ValidationException.operationNotSupported("listIterator");
    }

    public Iterator iterator() {
        throw ValidationException.operationNotSupported("iterator");
    }

    public List subList(int n, int n2) {
        throw ValidationException.operationNotSupported("subList");
    }

    public boolean retainAll(Collection collection) {
        throw ValidationException.operationNotSupported("retainAll");
    }

    public boolean removeAll(Collection collection) {
        throw ValidationException.operationNotSupported("removeAll");
    }

    public boolean containsAll(Collection collection) {
        throw ValidationException.operationNotSupported("containsAll");
    }

    public boolean addAll(Collection collection) {
        throw ValidationException.operationNotSupported("addAll");
    }

    public boolean addAll(int n, Collection collection) {
        throw ValidationException.operationNotSupported("addAll");
    }

    public boolean remove(Object object) {
        throw ValidationException.operationNotSupported("remove");
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public int lastIndexOf(Object object) {
        throw ValidationException.operationNotSupported("lastIndexOf");
    }

    public void add(int n, Object object) {
        throw ValidationException.operationNotSupported("add");
    }

    public Object remove(int n) {
        throw ValidationException.operationNotSupported("remove");
    }

    public Object get(int n) {
        throw ValidationException.operationNotSupported("get");
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.header.next.contents;
    }

    public Object getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.header.previous.contents;
    }

    public Object removeFirst() {
        if (this.size != 0) {
            Object object = this.header.next.contents;
            this.remove(this.header.next);
            return object;
        }
        return null;
    }

    public Object removeLast() {
        if (this.size != 0) {
            Object object = this.header.previous.contents;
            this.remove(this.header.previous);
            return object;
        }
        return null;
    }

    public LinkedNode addFirst(Object object) {
        return this.addAfter(object, this.header);
    }

    public LinkedNode addLast(Object object) {
        return this.addAfter(object, this.header.previous);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
    }

    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            LinkedNode linkedNode = this.header.next;
            while (linkedNode != this.header) {
                if (linkedNode.contents == null) {
                    return n;
                }
                ++n;
                linkedNode = linkedNode.next;
            }
        } else {
            LinkedNode linkedNode = this.header.next;
            while (linkedNode != this.header) {
                if (object.equals(linkedNode.contents)) {
                    return n;
                }
                ++n;
                linkedNode = linkedNode.next;
            }
        }
        return -1;
    }

    private LinkedNode addAfter(Object object, LinkedNode linkedNode) {
        LinkedNode linkedNode2;
        linkedNode2.previous.next = linkedNode2 = new LinkedNode(object, linkedNode.next, linkedNode);
        linkedNode2.next.previous = linkedNode2;
        ++this.size;
        return linkedNode2;
    }

    public void remove(LinkedNode linkedNode) {
        if (linkedNode == this.header) {
            throw new NoSuchElementException();
        }
        if (linkedNode.previous == null || linkedNode.next == null) {
            return;
        }
        linkedNode.previous.next = linkedNode.next;
        linkedNode.next.previous = linkedNode.previous;
        linkedNode.previous = null;
        linkedNode.next = null;
        linkedNode.contents = null;
        --this.size;
    }

    public void moveFirst(LinkedNode linkedNode) {
        if (linkedNode == this.header) {
            throw new NoSuchElementException();
        }
        if (linkedNode.previous == null || linkedNode.next == null) {
            ++this.size;
        } else {
            linkedNode.previous.next = linkedNode.next;
            linkedNode.next.previous = linkedNode.previous;
        }
        linkedNode.next = this.header.next;
        linkedNode.previous = this.header;
        this.header.next = linkedNode;
        linkedNode.next.previous = linkedNode;
    }
}

