/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.helper.TopLinkIdentityHashMap;
import oracle.toplink.internal.helper.linkedlist.ExposedNodeLinkedList;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public class WriteLockManager {
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();
    public static int MAXTRIES = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object object, Descriptor descriptor, Vector vector, Session session) {
        TopLinkIdentityHashMap topLinkIdentityHashMap;
        block13: {
            Iterator iterator;
            boolean bl = false;
            topLinkIdentityHashMap = new TopLinkIdentityHashMap();
            try {
                CacheKey cacheKey = this.acquireLockAndRelatedLocks(object, topLinkIdentityHashMap, vector, descriptor, session);
                int n = 0;
                while (cacheKey != null) {
                    Object object2 = topLinkIdentityHashMap.values().iterator();
                    while (object2.hasNext()) {
                        ((CacheKey)object2.next()).releaseReadLock();
                        object2.remove();
                    }
                    object2 = cacheKey.getMutex();
                    synchronized (object2) {
                        try {
                            if (cacheKey.isAcquired()) {
                                cacheKey.getMutex().wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    cacheKey = this.acquireLockAndRelatedLocks(object, topLinkIdentityHashMap, vector, descriptor, session);
                    if (cacheKey == null || ++n <= MAXTRIES) continue;
                    throw ConcurrencyException.maxTriesLockOnCloneExceded(object);
                }
                bl = true;
                Object var13_12 = null;
                if (bl) break block13;
                iterator = topLinkIdentityHashMap.values().iterator();
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (!bl) {
                    Iterator iterator2 = topLinkIdentityHashMap.values().iterator();
                    while (iterator2.hasNext()) {
                        ((CacheKey)iterator2.next()).releaseReadLock();
                        iterator2.remove();
                    }
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                ((CacheKey)iterator.next()).releaseReadLock();
                iterator.remove();
            }
        }
        return topLinkIdentityHashMap;
    }

    public CacheKey acquireLockAndRelatedLocks(Object object, Map map, Vector vector, Descriptor descriptor, Session session) {
        CacheKey cacheKey = session.getIdentityMapAccessorInstance().acquireReadLockOnCacheKeyNoWait(vector, descriptor.getJavaClass(), descriptor);
        if (cacheKey != null) {
            if (cacheKey.getObject() == null) {
                map.put(object, cacheKey);
            } else {
                object = cacheKey.getObject();
                if (map.containsKey(object)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                map.put(object, cacheKey);
            }
            return this.traverseRelatedLocks(object, map, descriptor, session);
        }
        return session.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, descriptor.getJavaClass(), descriptor);
    }

    public CacheKey traverseRelatedLocks(Object object, Map map, Descriptor descriptor, Session session) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            Iterator iterator = descriptor.getLockableMappings().iterator();
            while (iterator.hasNext()) {
                Cloneable cloneable;
                DatabaseMapping databaseMapping = (DatabaseMapping)iterator.next();
                Object object2 = databaseMapping.getAttributeValueFromObject(object);
                if (databaseMapping.isCollectionMapping()) {
                    cloneable = databaseMapping.getContainerPolicy();
                    Object object3 = ((ContainerPolicy)cloneable).iteratorFor(object2);
                    while (((ContainerPolicy)cloneable).hasNext(object3)) {
                        CacheKey cacheKey;
                        Object object4 = ((ContainerPolicy)cloneable).next(object3, session);
                        if (databaseMapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object4 = databaseMapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object4, session);
                        }
                        if ((cacheKey = this.checkAndLockObject(object4, map, databaseMapping, session)) == null) continue;
                        return cacheKey;
                    }
                    continue;
                }
                if (databaseMapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    object2 = databaseMapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object2, session);
                }
                if ((cloneable = this.checkAndLockObject(object2, map, databaseMapping, session)) == null) continue;
                return cloneable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        try {
            try {
                Session session = mergeManager.getSession();
                if (session.isUnitOfWork()) {
                    session = ((UnitOfWork)session).getParent();
                } else {
                    bl2 = true;
                }
                block9: while (bl) {
                    bl = false;
                    Iterator iterator = unitOfWorkChangeSet.getObjectChanges().keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Hashtable hashtable = (Hashtable)unitOfWorkChangeSet.getObjectChanges().get(string);
                        Iterator iterator2 = hashtable.keySet().iterator();
                        Class clazz = null;
                        while (iterator2.hasNext()) {
                            Descriptor descriptor;
                            ObjectChangeSet objectChangeSet = (ObjectChangeSet)iterator2.next();
                            if (objectChangeSet.getCacheKey() == null) continue;
                            if (clazz == null) {
                                clazz = objectChangeSet.getClassType(session);
                            }
                            if ((descriptor = session.getDescriptor(clazz)).shouldIsolateObjectsInUnitOfWork()) break;
                            CacheKey cacheKey = this.attemptToAcquireLock(clazz, objectChangeSet.getCacheKey(), session);
                            if (cacheKey == null) {
                                if (this.prevailingQueue.getFirst() == mergeManager) {
                                    cacheKey = this.waitOnObjectLock(clazz, objectChangeSet.getCacheKey(), session);
                                    mergeManager.getAcquiredLocks().add(cacheKey);
                                    continue;
                                }
                                this.releaseAllAcquiredLocks(mergeManager);
                                cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(objectChangeSet.getCacheKey().getKey(), clazz, session.getDescriptor(clazz));
                                Object[] objectArray = new Object[]{cacheKey.getObject(), Thread.currentThread().getName()};
                                session.log(2, "cache", "dead_lock_encountered_on_write", objectArray, null, true);
                                if (mergeManager.getWriteLockQueued() == null) {
                                    mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                                }
                                mergeManager.setWriteLockQueued(objectChangeSet.getCacheKey());
                                try {
                                    ConcurrencyManager concurrencyManager = cacheKey.getMutex();
                                    synchronized (concurrencyManager) {
                                        if (cacheKey.getMutex().isAcquired() && cacheKey.getMutex().getActiveThread() != Thread.currentThread()) {
                                            cacheKey.getMutex().wait();
                                        }
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
                                }
                                bl = true;
                                break;
                            }
                            mergeManager.getAcquiredLocks().add(cacheKey);
                        }
                        if (!bl) continue;
                        continue block9;
                    }
                }
                Object var18_19 = null;
            }
            catch (RuntimeException runtimeException) {
                this.releaseAllAcquiredLocks(mergeManager);
                throw runtimeException;
            }
            if (mergeManager.getWriteLockQueued() != null) {
                this.prevailingQueue.remove(mergeManager.getQueueNode());
                mergeManager.setWriteLockQueued(null);
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            if (mergeManager.getWriteLockQueued() != null) {
                this.prevailingQueue.remove(mergeManager.getQueueNode());
                mergeManager.setWriteLockQueued(null);
            }
            throw throwable;
        }
    }

    public Object appendLock(Vector vector, Object object, Descriptor descriptor, MergeManager mergeManager, Session session) {
        for (int i = 0; i < 1000; ++i) {
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(vector, descriptor.getJavaClass(), true, descriptor);
            if (cacheKey == null) {
                cacheKey = session.getIdentityMapAccessorInstance().acquireReadLockOnCacheKey(vector, descriptor.getJavaClass(), descriptor);
                Object object2 = cacheKey.getObject();
                cacheKey.releaseReadLock();
                if (object2 != null) {
                    return object2;
                }
            } else {
                if (cacheKey.getObject() == null) {
                    cacheKey.setObject(object);
                }
                mergeManager.getAcquiredLocks().add(cacheKey);
                return object;
            }
            session.getSessionLog().log(1, "cache", "Found null object in identity map on appendLock, retrying");
        }
        throw ConcurrencyException.maxTriesLockOnMergeExceded(object);
    }

    protected CacheKey attemptToAcquireLock(Class clazz, CacheKey cacheKey, Session session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(cacheKey.getKey(), clazz, true, session.getDescriptor(clazz));
    }

    protected CacheKey checkAndLockObject(Object object, Map map, DatabaseMapping databaseMapping, Session session) {
        if (object != null && !map.containsKey(object)) {
            Vector vector = null;
            Descriptor descriptor = null;
            descriptor = databaseMapping.getReferenceDescriptor().hasInheritance() ? session.getDescriptor(object) : databaseMapping.getReferenceDescriptor();
            if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                this.traverseRelatedLocks(object, map, descriptor, session);
            } else {
                vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session);
                CacheKey cacheKey = this.acquireLockAndRelatedLocks(object, map, vector, descriptor, session);
                if (cacheKey != null) {
                    return cacheKey;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        Iterator iterator = mergeManager.getAcquiredLocks().iterator();
        while (iterator.hasNext()) {
            CacheKey cacheKey = (CacheKey)iterator.next();
            if (cacheKey.getObject() == null && cacheKey.getOwningMap() != null) {
                cacheKey.getOwningMap().remove(cacheKey);
            }
            cacheKey.release();
            iterator.remove();
        }
    }

    protected CacheKey waitOnObjectLock(Class clazz, CacheKey cacheKey, Session session) {
        return session.getIdentityMapAccessorInstance().acquireLock(cacheKey.getKey(), clazz, true, session.getDescriptor(clazz));
    }
}

