/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.expressions.ForUpdateClause;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class LOBValueWriter {
    private Collection calls = null;
    private Accessor accessor;

    public LOBValueWriter(Accessor accessor) {
        this.accessor = accessor;
    }

    protected void buildAndExecuteCall(DatabaseCall databaseCall, Session session) {
        DatabaseQuery databaseQuery = databaseCall.getQuery();
        if (!databaseQuery.isWriteObjectQuery()) {
            return;
        }
        WriteObjectQuery writeObjectQuery = (WriteObjectQuery)databaseQuery;
        writeObjectQuery.setAccessor(this.accessor);
        SQLSelectStatement sQLSelectStatement = this.buildSelectStatementForLocator(writeObjectQuery, databaseCall, session);
        DatabaseCall databaseCall2 = this.buildCallFromSelectStatementForLocator(sQLSelectStatement, writeObjectQuery, databaseCall, session);
        this.accessor.executeCall(databaseCall2, databaseCall2.getQuery().getTranslationRow(), session);
    }

    public void fetchLocatorAndWriteValue(DatabaseCall databaseCall, Object object) throws SQLException {
        Enumeration enumeration = databaseCall.getContexts().getFields().elements();
        Enumeration enumeration2 = databaseCall.getContexts().getValues().elements();
        Session session = databaseCall.getQuery().getExecutionSession();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object e = enumeration2.nextElement();
            session.getPlatform().writeLOB(databaseField, e, (ResultSet)object, session);
        }
    }

    private SQLSelectStatement buildSelectStatementForLocator(WriteObjectQuery writeObjectQuery, DatabaseCall databaseCall, Session session) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        Vector vector = writeObjectQuery.getDescriptor().getTables();
        sQLSelectStatement.setTables(vector);
        sQLSelectStatement.setFields(databaseCall.getContexts().getFields());
        sQLSelectStatement.setWhereClause(writeObjectQuery.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(writeObjectQuery.getObject(), session));
        sQLSelectStatement.setLockingClause(ForUpdateClause.newInstance((short)1));
        if (vector.size() > 1) {
            Expression expression = sQLSelectStatement.getWhereClause();
            Expression expression2 = writeObjectQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (expression2 != null) {
                expression = expression.and(expression2);
            }
            sQLSelectStatement.setWhereClause(expression);
        }
        sQLSelectStatement.normalize(session, writeObjectQuery.getDescriptor());
        return sQLSelectStatement;
    }

    private DatabaseCall buildCallFromSelectStatementForLocator(SQLSelectStatement sQLSelectStatement, WriteObjectQuery writeObjectQuery, DatabaseCall databaseCall, Session session) {
        DatabaseCall databaseCall2 = sQLSelectStatement.buildCall(session);
        databaseCall2.setContexts(databaseCall.getContexts());
        databaseCall2.returnOneRow();
        databaseCall2.setQuery(writeObjectQuery);
        databaseCall2.prepare(session);
        databaseCall2.translate(writeObjectQuery.getTranslationRow(), writeObjectQuery.getModifyRow(), session);
        return databaseCall2;
    }

    public void addCall(Call call) {
        if (this.calls == null) {
            this.calls = new ArrayList(2);
        }
        this.calls.add(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndExecuteSelectCalls(Session session) {
        if (this.calls == null || this.calls.isEmpty()) {
            return;
        }
        try {
            Iterator iterator = this.calls.iterator();
            while (iterator.hasNext()) {
                DatabaseCall databaseCall = (DatabaseCall)iterator.next();
                this.buildAndExecuteCall(databaseCall, session);
            }
        }
        finally {
            this.calls.clear();
        }
    }
}

