/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionIterator;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class FunctionExpression
extends Expression {
    protected Expression baseExpression;
    protected Vector children = NonSynchronizedVector.newInstance(2);
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;

    public void addChild(Expression expression) {
        this.getChildren().addElement(expression);
    }

    public DatabaseTable aliasForTable(DatabaseTable databaseTable) {
        return this.getBaseExpression().aliasForTable(databaseTable);
    }

    public Expression asOf(AsOfClause asOfClause) {
        final AsOfClause asOfClause2 = asOfClause;
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                if (expression.isDataExpression()) {
                    expression.asOf(asOfClause2);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        expressionIterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression expression, Object object, ExpressionOperator expressionOperator) {
        this.baseExpression = expression;
        this.addChild(expression);
        Expression expression2 = Expression.from(object, expression);
        this.addChild(expression2);
        this.setOperator(expressionOperator);
        return this;
    }

    public Expression create(Expression expression, Vector vector, ExpressionOperator expressionOperator) {
        this.baseExpression = expression;
        this.addChild(expression);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Expression expression2 = Expression.from(enumeration.nextElement(), expression);
            this.addChild(expression2);
        }
        this.setOperator(expressionOperator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Function";
    }

    public boolean doesConform(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        if (this.getOperator().getSelector() == 3) {
            return !this.getBaseExpression().doesConform(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
        }
        if (this.getOperator().getSelector() == 15 || this.getOperator().getSelector() == 16) {
            Object object2 = this.getBaseExpression().valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
            Vector<Object> vector = new Vector<Object>(this.getChildren().size());
            for (int i = 1; i < this.getChildren().size(); ++i) {
                if (this.getChildren().elementAt(i) instanceof Expression) {
                    vector.addElement(((Expression)this.getChildren().elementAt(i)).valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl));
                    continue;
                }
                vector.addElement(this.getChildren().elementAt(i));
            }
            if (object2 instanceof Vector) {
                Enumeration enumeration = ((Vector)object2).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!this.getOperator().doesRelationConform(e, vector)) continue;
                    return true;
                }
                return false;
            }
            return this.getOperator().doesRelationConform(object2, vector);
        }
        if (this.getOperator().getSelector() == 17 || this.getOperator().getSelector() == 18) {
            Object object3 = this.getBaseExpression().valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
            if (object3 instanceof Vector) {
                Enumeration enumeration = ((Vector)object3).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!this.getOperator().doesRelationConform(e, null)) continue;
                    return true;
                }
                return false;
            }
            return this.getOperator().doesRelationConform(object3, null);
        }
        throw QueryException.cannotConformExpression();
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        if (this.getBaseExpression() == null) {
            return null;
        }
        return this.getBaseExpression().getBuilder();
    }

    public Vector getChildren() {
        return this.children;
    }

    public Vector getFields() {
        return this.getBaseExpression().getFields();
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform databasePlatform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(databasePlatform);
        }
        return this.platformOperator;
    }

    public void initializePlatformOperator(DatabasePlatform databasePlatform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = databasePlatform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isFunctionExpression() {
        return true;
    }

    protected boolean isObjectComparison() {
        if (this.getChildren().size() != 1) {
            return false;
        }
        int n = this.getOperator().getSelector();
        if (n != 17 && n != 18) {
            return false;
        }
        Expression expression = this.getBaseExpression();
        return expression.isObjectExpression() && !((ObjectExpression)expression).isAttribute();
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            expression.iterateOn(expressionIterator);
        }
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        this.validateNode();
        if (this.getChildren().isEmpty()) {
            return this;
        }
        if (!this.isObjectComparison()) {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                this.getChildren().setElementAt(((Expression)this.getChildren().elementAt(i)).normalize(expressionNormalizer), i);
            }
            return this;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            ((Expression)this.getChildren().elementAt(i)).validateNode();
        }
        ObjectExpression objectExpression = (ObjectExpression)this.getBaseExpression();
        objectExpression.getBaseExpression().normalize(expressionNormalizer);
        Expression expression = objectExpression.getMapping().buildObjectJoinExpression((Expression)objectExpression, (Object)null, this.getSession());
        if (this.getOperator().getSelector() == 18) {
            expression = expression.not();
        }
        return expression;
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        this.baseExpression = this.baseExpression.copiedVersionFrom(dictionary);
        Vector vector = this.children;
        this.children = NonSynchronizedVector.newInstance();
        for (int i = 0; i < vector.size(); ++i) {
            this.addChild(((Expression)vector.elementAt(i)).copiedVersionFrom(dictionary));
        }
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionSQLPrinter.getPlatform());
        expressionOperator.printCollection(this.getChildren(), expressionSQLPrinter);
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ExpressionOperator expressionOperator = this.getPlatformOperator(expressionJavaPrinter.getPlatform());
        expressionOperator.printJavaCollection(this.getChildren(), expressionJavaPrinter);
    }

    public Expression rebuildOn(Expression expression) {
        Expression expression2 = this.getBaseExpression().rebuildOn(expression);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Vector)nonSynchronizedVector).addElement(((Expression)this.children.elementAt(i)).rebuildOn(expression));
        }
        expression2.setSelectIfOrderedBy(this.getBaseExpression().selectIfOrderedBy());
        return expression2.performOperator(this.getOperator(), nonSynchronizedVector);
    }

    public void setBaseExpression(Expression expression) {
        this.baseExpression = expression;
    }

    public void setLocalBase(Expression expression) {
        this.getBaseExpression().setLocalBase(expression);
    }

    public void setOperator(ExpressionOperator expressionOperator) {
        this.operator = expressionOperator;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        if (this.getChildren().isEmpty()) {
            return (Expression)this.clone();
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Vector)nonSynchronizedVector).addElement(((Expression)this.children.elementAt(i)).twistedForBaseAndContext(expression, expression2));
        }
        Expression expression3 = (Expression)this.getChildren().elementAt(0);
        return expression3.twistedForBaseAndContext(expression, expression2).performOperator(this.getOperator(), nonSynchronizedVector);
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        Object object2 = this.getBaseExpression().valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getChildren().size());
        for (int i = 1; i < this.getChildren().size(); ++i) {
            if (this.getChildren().elementAt(i) instanceof Expression) {
                ((Vector)nonSynchronizedVector).addElement(((Expression)this.getChildren().elementAt(i)).valueFromObject(object, session, databaseRow, inMemoryQueryIndirectionPolicy, bl));
                continue;
            }
            ((Vector)nonSynchronizedVector).addElement(this.getChildren().elementAt(i));
        }
        if (object2 instanceof Vector) {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    vector.addElement(e);
                    continue;
                }
                vector.addElement(this.getOperator().applyFunction(e, nonSynchronizedVector));
            }
            return vector;
        }
        if (object2 == null) {
            return null;
        }
        return this.getOperator().applyFunction(object2, nonSynchronizedVector);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.operator.toString());
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        if (this.getBaseExpression().isDataExpression()) {
            DatabaseField databaseField = ((DataExpression)this.getBaseExpression()).getField();
            if (databaseField == null) {
                databaseField = new DatabaseField("*");
            }
            vector.addElement(databaseField);
        } else {
            vector.addElement(new DatabaseField("*"));
        }
        this.printSQL(expressionSQLPrinter);
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(bufferedWriter, n);
        }
    }
}

