/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class ConstantExpression
extends Expression {
    protected Object value;
    protected Expression localBase;

    public ConstantExpression() {
    }

    public ConstantExpression(Object object, Expression expression) {
        this.value = object;
        this.localBase = expression;
    }

    public String descriptionOfNodeType() {
        return "Constant";
    }

    public ExpressionBuilder getBuilder() {
        return this.getLocalBase().getBuilder();
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean isValueExpression() {
        return true;
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        this.localBase = this.localBase.copiedVersionFrom(dictionary);
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        Object object = this.getLocalBase().getFieldValue(this.getValue());
        expressionSQLPrinter.printPrimitive(object);
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printPrimitive(this.getValue());
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        expressionJavaPrinter.printJava(this.getValue());
    }

    public Expression rebuildOn(Expression expression) {
        ConstantExpression constantExpression = (ConstantExpression)this.clone();
        ((Expression)constantExpression).setLocalBase(this.getLocalBase().rebuildOn(expression));
        return constantExpression;
    }

    public void setLocalBase(Expression expression) {
        this.localBase = expression;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return (Expression)this.clone();
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        return this.getLocalBase().getFieldValue(this.getValue());
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(String.valueOf(this.getValue()));
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        if (expressionSQLPrinter.isFirstElementPrinted()) {
            expressionSQLPrinter.printString(", ");
        } else {
            expressionSQLPrinter.setIsFirstElementPrinted(true);
        }
        vector.addElement(new DatabaseField("*"));
        this.printSQL(expressionSQLPrinter);
    }
}

