/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3.base;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.internal.ejb.cmp3.base.EntityManagerImpl;
import oracle.toplink.threetier.ServerSession;

public abstract class EntityManagerFactoryImpl {
    protected ServerSession serverSession;
    protected Vector entityManagers;

    protected abstract EntityManagerImpl createEntityManagerImplInternal();

    public EntityManagerFactoryImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
        this.entityManagers = new Vector();
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public void close() {
        Iterator iterator = this.entityManagers.iterator();
        while (iterator.hasNext()) {
            EntityManagerImpl entityManagerImpl = (EntityManagerImpl)((WeakReference)iterator.next()).get();
            if (entityManagerImpl == null) continue;
            entityManagerImpl.close();
        }
        this.serverSession.logout();
    }

    public boolean isOpen() {
        return this.serverSession.isConnected();
    }

    protected EntityManagerImpl createEntityManagerImpl() {
        if (!this.serverSession.isConnected()) {
            this.serverSession.login();
        }
        EntityManagerImpl entityManagerImpl = this.createEntityManagerImplInternal();
        this.entityManagers.add(new WeakReference<EntityManagerImpl>(entityManagerImpl));
        return entityManagerImpl;
    }
}

