/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.instrument.ClassFileTransformer;
import java.util.Collection;
import java.util.Map;
import oracle.toplink.ejb.cmp3.base.EntityManagerFactoryProvider;
import oracle.toplink.ejb.cmp3.persistence.PersistenceInfo;
import oracle.toplink.internal.annotations.EJBAnnotationsProcessor;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.weaving.TransformerFactory;
import oracle.toplink.platform.database.oracle.Oracle9Platform;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DefaultConnector;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.workbench.XMLProjectReader;
import oracle.toplink.tools.workbench.XMLProjectWriter;

public class EntityManagerSetupImpl
extends oracle.toplink.internal.ejb.cmp3.base.EntityManagerSetupImpl {
    protected EJBAnnotationsProcessor processor = null;
    protected byte[] projectXMLBytes = null;
    protected String deploymentFileName = null;
    protected Map m;
    protected boolean isSessionDefinedInSessionsXML;
    protected PersistenceInfo persistenceInfo = null;
    public static final String NO_WEAVING = "no.weaving";

    protected ServerSession buildDefaultSession(Project project) {
        ServerSession serverSession = null;
        if (project == null) {
            serverSession = new ServerSession();
            serverSession.setProject(new Project(new DatabaseLogin()));
        } else {
            serverSession = (ServerSession)project.createServerSession();
        }
        if (this.sessionName == null) {
            serverSession.setName("default");
        } else {
            serverSession.setName(this.sessionName);
        }
        serverSession.getLogin().usePlatform(new Oracle9Platform());
        serverSession.getSessionLog().setLevel(3);
        return serverSession;
    }

    protected Project readProjectFromXML(ClassLoader classLoader) {
        XMLProjectReader xMLProjectReader = new XMLProjectReader();
        Project project = null;
        if (this.projectXMLBytes == null) {
            project = XMLProjectReader.read(this.deploymentFileName, classLoader);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.projectXMLBytes);
            InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
            project = XMLProjectReader.read(inputStreamReader, classLoader);
            this.projectXMLBytes = null;
        }
        return project;
    }

    public ServerSession baseDeploy(Collection collection, ClassLoader classLoader) {
        ServerSession serverSession;
        Project project = this.readProjectFromXML(classLoader);
        if (this.isSessionDefinedInSessionsXML) {
            serverSession = this.loadSessionFromXML(classLoader);
            this.addProjectToSession(serverSession, project);
        } else {
            serverSession = this.buildDefaultSession(project);
        }
        EntityManagerSetupImpl.addSessionToGlobalSessionManager(serverSession);
        this.addNamedQueriesToSession(serverSession);
        this.deployedSessionName = serverSession.getName();
        this.processor.addEntityListeners(serverSession, collection, classLoader);
        this.processor.addNamedQueriesToSession(serverSession);
        ServerSession serverSession2 = EntityManagerSetupImpl.updateServerSession(serverSession, this.m);
        this.cleanUp();
        return serverSession2;
    }

    public ServerSession baseDeploy(Collection collection, ClassLoader classLoader, String string) {
        if (string != null) {
            this.m.put("datasource.jndi.name", string);
        }
        return this.baseDeploy(collection, classLoader);
    }

    public ServerSession baseDeploy(Collection collection, ClassLoader classLoader, Map map) {
        if (map != null && !map.isEmpty()) {
            this.m.putAll(map);
        }
        return this.baseDeploy(collection, classLoader);
    }

    protected void addProjectToSession(ServerSession serverSession, Project project) {
        DatasourcePlatform datasourcePlatform = (DatasourcePlatform)serverSession.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform datasourcePlatform2 = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!datasourcePlatform.hasDefaultSequence() && datasourcePlatform2.hasDefaultSequence()) {
            datasourcePlatform.setDefaultSequence(datasourcePlatform2.getDefaultSequence());
        }
        if (datasourcePlatform.getSequences() == null || datasourcePlatform.getSequences().isEmpty()) {
            if (datasourcePlatform2.getSequences() != null && !datasourcePlatform2.getSequences().isEmpty()) {
                datasourcePlatform.setSequences(datasourcePlatform2.getSequences());
            }
        } else if (datasourcePlatform2.getSequences() != null && !datasourcePlatform2.getSequences().isEmpty()) {
            for (Sequence sequence : datasourcePlatform2.getSequences().values()) {
                if (datasourcePlatform.getSequences().containsKey(sequence.getName())) continue;
                datasourcePlatform.addSequence(sequence);
            }
        }
        serverSession.addDescriptors(project);
    }

    public ClassFileTransformer basePredeploy(Collection collection, ClassLoader classLoader, Map map, PersistenceInfo persistenceInfo) {
        this.persistenceInfo = persistenceInfo;
        return this.basePredeploy(collection, classLoader, map);
    }

    public ClassFileTransformer basePredeploy(Collection collection, ClassLoader classLoader, Map map) {
        Object object;
        Object object2;
        this.m = map;
        this.sessionName = EntityManagerFactoryProvider.getConfigProperty("toplink.session.name", map);
        this.sessionsXMLName = EntityManagerFactoryProvider.getConfigProperty("ejb30.sessions.xml.name", map);
        Session session = this.loadSessionFromXML(classLoader);
        boolean bl = this.isSessionDefinedInSessionsXML = session != null;
        if (!this.isSessionDefinedInSessionsXML) {
            session = this.buildDefaultSession(null);
        }
        if (this.persistenceInfo != null && !this.persistenceInfo.getMappingFileNames().isEmpty()) {
            object2 = new XMLProjectReader();
            object = this.persistenceInfo.getMappingFileNames().iterator();
            while (object.hasNext()) {
                Project project = XMLProjectReader.read((String)object.next(), classLoader);
                session.getProject().addDescriptors(project, (DatabaseSession)((ServerSession)session));
            }
        }
        this.processor = new EJBAnnotationsProcessor(session, classLoader, collection);
        session = this.processor.processORAnnotations();
        object2 = EntityManagerFactoryProvider.getConfigProperty(NO_WEAVING, map);
        object = null;
        if (object2 == null || ((String)object2).equalsIgnoreCase("false")) {
            object = TransformerFactory.createTransformer(session, collection);
        }
        session.getProject().getLogin().setConnector(new DefaultConnector());
        this.writeProjectToXML(session.getProject());
        return object;
    }

    protected void cleanUp() {
        this.processor = null;
        this.projectXMLBytes = null;
        this.m = null;
    }

    protected void writeProjectToXML(Project project) {
        XMLProjectWriter xMLProjectWriter = new XMLProjectWriter();
        this.deploymentFileName = EntityManagerFactoryProvider.getConfigProperty("toplink.persistence.deployment.file", this.m);
        if (this.deploymentFileName != null) {
            XMLProjectWriter.write(project, this.deploymentFileName);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            XMLProjectWriter.write(project, outputStreamWriter);
            this.projectXMLBytes = byteArrayOutputStream.toByteArray();
        }
    }

    protected boolean sessionMustBeDefinedInSessionsXML() {
        return false;
    }
}

