/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.finders;

import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import oracle.toplink.descriptors.WrapperPolicy;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.EJBFactory;
import oracle.toplink.internal.ejb.cmp.PersistenceManagerBase;
import oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity;
import oracle.toplink.internal.ejb.cmp.api.CmpField;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.finders.CollectionFactory;
import oracle.toplink.internal.ejb.cmp.finders.DynamicFinder;
import oracle.toplink.internal.ejb.cmp.finders.EjbSelect;
import oracle.toplink.internal.ejb.cmp.finders.FindByPrimaryKey;
import oracle.toplink.internal.ejb.cmp.finders.Finder;
import oracle.toplink.internal.ejb.cmp.finders.SystemLookupFinder;
import oracle.toplink.internal.parsing.EJBQLParseTree;
import oracle.toplink.internal.parsing.ParseTree;
import oracle.toplink.internal.parsing.ejbql.EJBQLParserBase;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.CursoredStream;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReportQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class FinderManager {
    private static final String FIND_ALL = "findAll";
    private static final String SYSTEM_LOOKUP_QUERY = "systemLookupQuery";
    private static final String PESSIMISTIC_LOCK_KEY = "CMP_PL";
    private static final String FINDER_KEY = "TOPLINK_FINDER";
    public static final String PERSISTENCE_MANAGER = "PERSISTENCE_MANAGER";
    private Finder findByPrimaryKey;
    private Finder systemLookupFinder;
    protected PersistenceManagerBase persistenceManager = null;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Enumeration;

    public FinderManager(PersistenceManagerBase persistenceManagerBase) {
        this.persistenceManager = persistenceManagerBase;
        this.getDescriptor().setProperty(PERSISTENCE_MANAGER, persistenceManagerBase);
        this.initializeAllQueries();
    }

    public TopLinkCmpEntity lookupBeanForInvocation(boolean bl, Object object, Session session) throws NoSuchObjectException {
        return (TopLinkCmpEntity)((Finder)this.systemLookupFinder.clone()).executeLookup(bl, object, session);
    }

    public Object findByPrimaryKey(boolean bl, Object object, boolean bl2) throws ObjectNotFoundException, FinderException {
        return ((Finder)this.findByPrimaryKey.clone()).executeFindByPk(bl, object, bl2);
    }

    public Object findOne(boolean bl, String string, Method method, Vector vector, boolean bl2) throws ObjectNotFoundException, FinderException {
        return this.getFinder(string, method, vector).execute(bl, vector, bl2);
    }

    public Enumeration findEnumeration(String string, Method method, Vector vector, boolean bl) throws FinderException {
        return CollectionFactory.createEnumeratorFor(this.getFinder(string, method, vector).execute(false, vector, bl));
    }

    public Collection findCollection(boolean bl, String string, Method method, Vector vector, boolean bl2) throws FinderException {
        return CollectionFactory.createCollectionFor(bl, this.getFinder(string, method, vector).execute(bl, vector, bl2));
    }

    public Object ejbSelect(boolean bl, Class clazz, String string, Vector vector) throws ObjectNotFoundException, FinderException {
        EjbSelect ejbSelect = (EjbSelect)this.getFinder(string, null, vector);
        ejbSelect.setReturnType(clazz);
        return ejbSelect.execute(bl, vector, false);
    }

    protected Finder getFinder(String string, Method method, Vector vector) {
        Finder finder;
        if (DynamicFinder.isDynamicQueryFinder(string)) {
            return new DynamicFinder(string, this);
        }
        DatabaseQuery databaseQuery = this.getQueryManager().getQuery(string, vector);
        if (databaseQuery == null) {
            if (method != null && FinderManager.isFindByCmpField(method, this.getPersistenceManager().getEntityDescriptor())) {
                databaseQuery = this.buildQueryForFindByCmp(method);
            }
            if (databaseQuery == null) {
                throw QueryException.queryNotDefined(string);
            }
        }
        if ((finder = (Finder)databaseQuery.getProperty(FINDER_KEY)) == null) {
            finder = DynamicFinder.isDynamicFinder(string) ? new DynamicFinder(databaseQuery, this) : (EjbSelect.isEjbSelect(string) ? new EjbSelect(databaseQuery, this) : new Finder(databaseQuery, this));
            databaseQuery.getProperties().put(FINDER_KEY, finder);
        }
        return (Finder)finder.clone();
    }

    private ObjectLevelReadQuery buildQueryForFindByCmp(Method method) {
        ObjectLevelReadQuery objectLevelReadQuery = null;
        objectLevelReadQuery = PrivilegedAccessController.getMethodReturnType(method).isAssignableFrom(class$java$util$Collection == null ? (class$java$util$Collection = FinderManager.class$("java.util.Collection")) : class$java$util$Collection) || PrivilegedAccessController.getMethodReturnType(method).isAssignableFrom(class$java$util$Enumeration == null ? (class$java$util$Enumeration = FinderManager.class$("java.util.Enumeration")) : class$java$util$Enumeration) ? new ReadAllQuery() : new ReadObjectQuery();
        objectLevelReadQuery.setReferenceClass(this.getDescriptor().getJavaClass());
        String string = FinderManager.extractCmpField(method.getName());
        objectLevelReadQuery.addArgument(string);
        objectLevelReadQuery.setSelectionCriteria(objectLevelReadQuery.getExpressionBuilder().get(string).equal(objectLevelReadQuery.getExpressionBuilder().getParameter(string)));
        this.getQueryManager().addQuery(method.getName(), objectLevelReadQuery);
        return objectLevelReadQuery;
    }

    private static boolean isFindByCmpField(Method method, EntityDescriptor entityDescriptor) {
        String string = method.getName();
        if (string != null && string.startsWith("findBy") && PrivilegedAccessController.getMethodParameterTypes(method).length == 1) {
            CmpField cmpField;
            String string2 = FinderManager.extractCmpField(string);
            if (entityDescriptor.getCmpFields().containsKey(string2) && (cmpField = (CmpField)entityDescriptor.getCmpFields().get(string2)).getType() == PrivilegedAccessController.getMethodParameterTypes(method)[0]) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMagicFinder(Method method, EntityDescriptor entityDescriptor) {
        if (DynamicFinder.isDynamicFinder(method.getName())) {
            return true;
        }
        if (FinderManager.isFindByCmpField(method, entityDescriptor)) {
            return true;
        }
        return method.getName().equals(FIND_ALL);
    }

    private static String extractCmpField(String string) {
        String string2 = string.substring(6);
        return string2.substring(0, 1).toLowerCase() + string2.substring(1);
    }

    public Object wrapFinderResults(boolean bl, Object object, Session session) {
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            Vector<Object> vector = new Vector<Object>();
            while (iterator.hasNext()) {
                vector.add(this.wrapObject(bl, iterator.next(), session));
            }
            return vector;
        }
        return this.wrapObject(bl, object, session);
    }

    protected Object wrapObject(boolean bl, Object object, Session session) {
        if (!this.shouldObjectBeWrapped(bl, object)) {
            return object;
        }
        FinderManager finderManager = ((TopLinkCmpEntity)object).getPersistenceManagerTopLink().getFinderManager();
        WrapperPolicy wrapperPolicy = finderManager.getWrapperPolicy(bl);
        if (wrapperPolicy == null) {
            if (bl) {
                throw EJBExceptionFactory.localWrapperMissing();
            }
            throw EJBExceptionFactory.remoteWrapperMissing();
        }
        return wrapperPolicy.wrapObject(object, session);
    }

    protected boolean shouldObjectBeWrapped(boolean bl, Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EntityBean) {
            return true;
        }
        if (object instanceof CursoredStream) {
            return false;
        }
        if (!this.isBeanWrappedCorrectly(object, bl)) {
            throw EJBExceptionFactory.finderResultsAlreadyWrapped();
        }
        return false;
    }

    protected boolean isBeanWrappedCorrectly(Object object, boolean bl) {
        boolean bl2 = object instanceof EJBObject;
        boolean bl3 = object instanceof EJBLocalObject;
        return (!bl || !bl2) && (bl || !bl3);
    }

    protected WrapperPolicy getWrapperPolicy(boolean bl) {
        if (bl) {
            return this.getPersistenceManager().getLocalWrapperPolicy();
        }
        return this.getPersistenceManager().getRemoteWrapperPolicy();
    }

    protected void initializeAllQueries() {
        DatabaseQuery databaseQuery;
        int n;
        Vector vector = this.getQueryManager().getAllQueries();
        Vector<ObjectLevelReadQuery> vector2 = new Vector<ObjectLevelReadQuery>();
        for (n = 0; n < vector.size(); ++n) {
            databaseQuery = (DatabaseQuery)vector.elementAt(n);
            databaseQuery.setShouldUseWrapperPolicy(!this.getPersistenceManager().isEJB20());
            if (databaseQuery.isObjectLevelReadQuery() && databaseQuery.getReferenceClass() == this.getPersistenceManager().getEntityDescriptor().getBeanClass()) {
                ((ObjectLevelReadQuery)databaseQuery).setReferenceClass(this.getDescriptor().getJavaClass());
            }
            if (!EjbSelect.isEjbSelect(databaseQuery.getName())) continue;
            try {
                vector2.add(this.convertEjbSelectQuery((ObjectLevelReadQuery)databaseQuery));
                continue;
            }
            catch (DeploymentException deploymentException) {
                AbstractSessionLog.getLog().log(6, "ejbSelect2", deploymentException);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            databaseQuery = (ObjectLevelReadQuery)vector2.elementAt(n);
            this.getQueryManager().removeQuery(databaseQuery.getName(), databaseQuery.getArgumentTypes());
            this.getQueryManager().addQuery(databaseQuery.getName(), databaseQuery);
            if (databaseQuery.getDescriptor() == null || ((ObjectLevelReadQuery)databaseQuery).getReferenceClass() == databaseQuery.getDescriptor().getJavaClass()) continue;
            databaseQuery.setDescriptor(null);
        }
        this.initializeDefaultFinders();
    }

    protected ObjectLevelReadQuery convertEjbSelectQuery(ObjectLevelReadQuery objectLevelReadQuery) {
        Object object;
        String string = objectLevelReadQuery.getEJBQLString();
        if (string == null) {
            return objectLevelReadQuery;
        }
        try {
            object = (EJBQLParseTree)EJBQLParserBase.buildParseTree(string);
            boolean bl = ((ParseTree)object).hasAttributeSelected(objectLevelReadQuery, this.persistenceManager.getSession());
            boolean bl2 = bl = bl || ((ParseTree)object).hasCountSelected(objectLevelReadQuery, this.persistenceManager.getSession());
            if (!bl) {
                return objectLevelReadQuery;
            }
        }
        catch (Exception exception) {
            throw new DeploymentException(objectLevelReadQuery.getName() + ": " + exception.toString(), exception);
        }
        object = new ReportQuery();
        ((ObjectLevelReadQuery)object).setReferenceClass(objectLevelReadQuery.getReferenceClass());
        ((ObjectLevelReadQuery)object).setEJBQLString(string);
        ((DatabaseQuery)object).setShouldUseWrapperPolicy(false);
        ((DatabaseQuery)object).setName(objectLevelReadQuery.getName());
        ((DatabaseQuery)object).setArguments(objectLevelReadQuery.getArguments());
        ((DatabaseQuery)object).setArgumentTypes(objectLevelReadQuery.getArgumentTypes());
        ((ObjectLevelReadQuery)object).setCacheUsage(objectLevelReadQuery.getCacheUsage());
        ((DatabaseQuery)object).setShouldBindAllParameters(objectLevelReadQuery.shouldBindAllParameters());
        ((DatabaseQuery)object).setShouldCacheStatement(objectLevelReadQuery.shouldCacheStatement());
        ((DatabaseQuery)object).setShouldMaintainCache(objectLevelReadQuery.shouldMaintainCache());
        ((ObjectLevelReadQuery)object).setShouldRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
        ((ObjectLevelReadQuery)object).setLockMode(objectLevelReadQuery.getLockMode());
        return object;
    }

    protected void initializeDefaultFinders() {
        DescriptorQueryManager descriptorQueryManager = this.getQueryManager();
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery("findByPrimaryKey", null);
        if (objectLevelReadQuery == null) {
            objectLevelReadQuery = this.initializeDefaultFinder(new ReadObjectQuery(), "findByPrimaryKey");
        } else if (objectLevelReadQuery.getReferenceClass() != this.getDescriptor().getJavaClass()) {
            objectLevelReadQuery = (ObjectLevelReadQuery)objectLevelReadQuery.clone();
            objectLevelReadQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            objectLevelReadQuery.setDescriptor(this.getDescriptor());
        }
        objectLevelReadQuery.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
        try {
            objectLevelReadQuery.checkPrepare(this.getPersistenceManager().getSession(), new DatabaseRecord());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.findByPrimaryKey = new FindByPrimaryKey(objectLevelReadQuery, this);
        objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery(FIND_ALL, null);
        if (objectLevelReadQuery == null) {
            this.initializeDefaultFinder(new ReadAllQuery(), FIND_ALL);
        }
        if ((objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery("findOneByEJBQL", null)) == null) {
            this.initializeDefaultFinder(new ReadObjectQuery(), "findOneByEJBQL");
        }
        if ((objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery("findManyByEJBQL", null)) == null) {
            this.initializeDefaultFinder(new ReadAllQuery(), "findManyByEJBQL");
        }
        if ((objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery("findOneBySQL", null)) == null) {
            this.initializeDefaultFinder(new ReadObjectQuery(), "findOneBySQL");
        }
        if ((objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery("findManyBySQL", null)) == null) {
            this.initializeDefaultFinder(new ReadAllQuery(), "findManyBySQL");
        }
        if ((objectLevelReadQuery = (ObjectLevelReadQuery)descriptorQueryManager.getLocalQuery(SYSTEM_LOOKUP_QUERY, null)) == null) {
            objectLevelReadQuery = this.initializeDefaultFinder((ObjectLevelReadQuery)this.findByPrimaryKey.getQuery().clone(), SYSTEM_LOOKUP_QUERY);
        } else if (objectLevelReadQuery.getReferenceClass() != this.getDescriptor().getJavaClass()) {
            objectLevelReadQuery = (ObjectLevelReadQuery)objectLevelReadQuery.clone();
            objectLevelReadQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            objectLevelReadQuery.setDescriptor(this.getDescriptor());
        }
        objectLevelReadQuery.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
        try {
            objectLevelReadQuery.checkPrepare(this.getPersistenceManager().getSession(), new DatabaseRecord());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.systemLookupFinder = new SystemLookupFinder(objectLevelReadQuery, this);
    }

    protected ObjectLevelReadQuery initializeDefaultFinder(ObjectLevelReadQuery objectLevelReadQuery, String string) {
        objectLevelReadQuery.conformResultsInUnitOfWork();
        objectLevelReadQuery.setReferenceClass(this.getDescriptor().getJavaClass());
        objectLevelReadQuery.setShouldUseWrapperPolicy(!this.getPersistenceManager().isEJB20());
        this.getQueryManager().addQuery(string, objectLevelReadQuery);
        return objectLevelReadQuery;
    }

    protected PersistenceManagerBase getPersistenceManager() {
        return this.persistenceManager;
    }

    protected EJBFactory getEJBFactory() {
        return this.getPersistenceManager().getEJBFactory();
    }

    protected Descriptor getDescriptor() {
        return this.getPersistenceManager().getDescriptor();
    }

    protected DescriptorQueryManager getQueryManager() {
        return this.getDescriptor().getQueryManager();
    }

    protected String getBeanName() {
        return this.getPersistenceManager().getEntityDescriptor().getBeanName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

