/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.codegen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.toplink.Version;
import oracle.toplink.exceptions.IntegrityException;
import oracle.toplink.internal.ejb.cmp.CmpEnvironment;
import oracle.toplink.internal.ejb.cmp.ProjectDeployment;
import oracle.toplink.internal.ejb.cmp.api.CmpDom;
import oracle.toplink.internal.ejb.cmp.api.CmpField;
import oracle.toplink.internal.ejb.cmp.api.CmrField;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.api.FinderDescriptor;
import oracle.toplink.internal.ejb.cmp.codegen.CmpFieldCodeGenerator;
import oracle.toplink.internal.ejb.cmp.codegen.FetchGroupCodeGenerator;
import oracle.toplink.internal.ejb.cmp.codegen.TopLinkInterfaceCodeGenerator;
import oracle.toplink.internal.ejb.cmp.codegen.UOWChangePolicyCodeGenerator;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.sessions.Project;
import oracle.toplink.tools.codegen.AccessLevel;
import oracle.toplink.tools.codegen.ClassDefinition;
import oracle.toplink.tools.codegen.MethodDefinition;
import oracle.toplink.tools.codegen.NonreflectiveMethodDefinition;
import oracle.toplink.tools.codegen.ReflectiveAttributeDefinition;
import oracle.toplink.tools.codegen.ReflectiveMethodDefinition;

public abstract class CmpCodeGenPlatform {
    protected static final String TOPLINK_VERSION = "This class was generated by using Oracle AS TopLink " + Version.getVersion() + " with build number: " + Version.getBuildNumber() + ".";
    protected Project project;
    protected CmpDom cmpDom;
    protected ClassDefinition definition;
    protected EntityDescriptor entityDescriptor;
    protected Map inheritanceHierarchy;
    protected NonreflectiveMethodDefinition clearFieldsForPoolingMethod;
    protected NonreflectiveMethodDefinition initFieldsForCreateMethod;
    protected NonreflectiveMethodDefinition returnCollectionByNameMethod;
    protected NonreflectiveMethodDefinition relationshipMaintenanceAmendmentMethod;
    static /* synthetic */ Class class$java$lang$Number;

    public CmpCodeGenPlatform(ProjectDeployment projectDeployment, EntityDescriptor entityDescriptor) {
        this.project = projectDeployment.getProject();
        this.cmpDom = projectDeployment.getCmpDom();
        this.entityDescriptor = entityDescriptor;
        this.inheritanceHierarchy = projectDeployment.getInheritanceHierarchy();
    }

    public void generateConcreteClass(ClassDefinition classDefinition) {
        this.definition = classDefinition;
        this.definition.setComment(TOPLINK_VERSION);
        this.setPackageName();
        this.addImportStatements();
        this.definition.setName(this.getConcreteClassName());
        this.definition.setSuperClass(this.getEntityDescriptor().getBeanClass().getName());
        this.addInterfaces();
        this.addAttributes();
        this.addMethods();
        if (this.getEntityDescriptor().isEJB20()) {
            new FetchGroupCodeGenerator().generateCodeForFetchGroup(this.getEntityDescriptor(), this.definition);
        }
        new UOWChangePolicyCodeGenerator().generateCodeForUOWChangePolicy(this.project, this.getEntityDescriptor(), this.definition);
        new TopLinkInterfaceCodeGenerator().generateCode(this.definition);
    }

    protected void setPackageName() {
        this.getDefinition().setPackageName(Helper.getPackageName(this.getEntityDescriptor().getBeanClass()));
    }

    protected void addImportStatements() {
        ClassDefinition classDefinition = this.getDefinition();
        classDefinition.addImport("java.util.*");
        classDefinition.addImport("javax.ejb.*");
        classDefinition.addImport("oracle.toplink.mappings.*");
        classDefinition.addImport("oracle.toplink.publicinterface.UnitOfWork");
        classDefinition.addImport("oracle.toplink.internal.ejb.cmp.*");
        if (this.getEntityDescriptor().isEJB20()) {
            classDefinition.addImport("oracle.toplink.internal.ejb.cmp.cmr.*");
        }
    }

    protected String getConcreteClassName() {
        return Helper.getShortClassName(this.getEntityDescriptor().getConcreteBeanClassName());
    }

    protected void addInterfaces() {
        this.getDefinition().addInterface("Cloneable");
    }

    protected void addAttributes() {
        if (this.getEntityDescriptor().hasUnknownPrimaryKey()) {
            ReflectiveAttributeDefinition reflectiveAttributeDefinition = new ReflectiveAttributeDefinition();
            reflectiveAttributeDefinition.setName("tl_unknown_pk");
            reflectiveAttributeDefinition.setType(CmpEnvironment.UNKNOWN_PK_CLASS_FIELD_TYPE);
            this.getDefinition().addAttribute(reflectiveAttributeDefinition);
        }
    }

    protected void addMethods() {
        this.addBasicCloneMethod();
        this.addClearFieldsForPoolingMethod();
        this.addInitFieldsForCreateMethod();
        this.addReturnCollectionByNameMethod();
        if (this.getEntityDescriptor().isEJB20()) {
            ClassDefinition classDefinition = this.getDefinition();
            classDefinition.addMethod(this.buildEntityBeanMethod("ejbLoad"));
            classDefinition.addMethod(this.buildEntityBeanMethod("ejbStore"));
            classDefinition.addMethod(this.buildEntityBeanMethod("ejbActivate"));
            classDefinition.addMethod(this.buildEntityBeanMethod("ejbPassivate"));
            classDefinition.addMethod(this.buildEntityBeanMethod("ejbRemove"));
            this.addCreateMethods();
            this.addRelationshipMaintenanceAmendmentMethod();
        }
        this.addContainerManagedAttributesAndMethods();
        this.addFindersAndEjbSelects();
        this.addCloneMethod();
        this.addReleaseMethod();
    }

    protected void addBasicCloneMethod() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName("clone");
        reflectiveMethodDefinition.setReturnType("Object");
        reflectiveMethodDefinition.addLine("oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity clone = null;");
        reflectiveMethodDefinition.addLine("try {");
        reflectiveMethodDefinition.addLine("    clone = (oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity)super.clone();");
        reflectiveMethodDefinition.addLine("} catch (Exception cloneNotSupported) {}");
        reflectiveMethodDefinition.addLine("clone.setIsOriginalTopLink(true);");
        reflectiveMethodDefinition.addLine("clone.setIsWorkingCopyCloneTopLink(false);");
        reflectiveMethodDefinition.addLine("clone.setEntityContextTopLink(null);");
        reflectiveMethodDefinition.addLine("clone.setAssociatedTransactionTopLink(null);");
        reflectiveMethodDefinition.addLine("return clone;");
        this.getDefinition().addMethod(reflectiveMethodDefinition);
    }

    protected abstract void addCloneMethod();

    protected void addReleaseMethod() {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName("releaseTopLink");
        reflectiveMethodDefinition.setReturnType("void");
        reflectiveMethodDefinition.addLine("this.getPersistenceManagerTopLink().getEJBFactory().releaseBean(this);");
        this.getDefinition().addMethod(reflectiveMethodDefinition);
    }

    protected MethodDefinition buildEntityBeanMethod(String string) {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName(string);
        reflectiveMethodDefinition.setReturnType("void");
        try {
            Method method = PrivilegedAccessController.getMethod(this.getEntityDescriptor().getBeanClass(), string, new Class[0], false);
            reflectiveMethodDefinition.addLine("super." + string + "();");
            this.addMethodExceptions(method, reflectiveMethodDefinition);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return reflectiveMethodDefinition;
    }

    protected void addCreateMethods() {
        Method[] methodArray = this.getEntityDescriptor().getBeanClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getName().startsWith("ejbCreate")) {
                this.definition.addMethod(this.buildCreateMethod(method));
                continue;
            }
            if (!method.getName().startsWith("ejbPostCreate")) continue;
            this.definition.addMethod(this.buildPostCreateMethod(method));
        }
    }

    protected MethodDefinition buildCreateMethod(Method method) {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        String string = method.getName();
        reflectiveMethodDefinition.setName(string);
        reflectiveMethodDefinition.setReturnType(this.getEntityDescriptor().getPrimaryKeyClass().getName());
        this.addMethodExceptions(method, reflectiveMethodDefinition);
        this.addMethodParams(PrivilegedAccessController.getMethodParameterTypes(method), reflectiveMethodDefinition);
        reflectiveMethodDefinition.addLine("return super." + string + "(" + this.collectParamsAsString(reflectiveMethodDefinition) + ");");
        return reflectiveMethodDefinition;
    }

    protected MethodDefinition buildPostCreateMethod(Method method) {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        String string = method.getName();
        reflectiveMethodDefinition.setName(string);
        reflectiveMethodDefinition.setReturnType("void");
        this.addMethodExceptions(method, reflectiveMethodDefinition);
        this.addMethodParams(PrivilegedAccessController.getMethodParameterTypes(method), reflectiveMethodDefinition);
        reflectiveMethodDefinition.addLine("super." + string + "(" + this.collectParamsAsString(reflectiveMethodDefinition) + ");");
        return reflectiveMethodDefinition;
    }

    protected void addFindersAndEjbSelects() {
        ClassDefinition classDefinition = this.getDefinition();
        Iterator iterator = this.getEntityDescriptor().getFinderDescriptors().iterator();
        while (iterator.hasNext()) {
            FinderDescriptor finderDescriptor = (FinderDescriptor)iterator.next();
            if (finderDescriptor.isEjbSelect()) {
                classDefinition.addMethod(this.buildEjbSelect(finderDescriptor));
                continue;
            }
            classDefinition.addMethod(this.buildFinder(finderDescriptor));
        }
    }

    protected MethodDefinition buildFinder(FinderDescriptor finderDescriptor) {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName("ejbF" + finderDescriptor.getMethodName().substring(1));
        reflectiveMethodDefinition.addException("FinderException");
        Class[] classArray = new Class[finderDescriptor.getMethodParams().size()];
        this.addMethodParams(finderDescriptor.getMethodParams().toArray(classArray), reflectiveMethodDefinition);
        if (finderDescriptor.getReturnType() == ClassConstants.Collection_Class) {
            reflectiveMethodDefinition.setReturnType("java.util.Collection");
        } else {
            reflectiveMethodDefinition.setReturnType(this.getEntityDescriptor().getPrimaryKeyClass().getName());
        }
        reflectiveMethodDefinition.addLine("return null;");
        return reflectiveMethodDefinition;
    }

    protected MethodDefinition buildEjbSelect(FinderDescriptor finderDescriptor) {
        ReflectiveMethodDefinition reflectiveMethodDefinition = new ReflectiveMethodDefinition();
        reflectiveMethodDefinition.setName(finderDescriptor.getMethodName());
        reflectiveMethodDefinition.addException("FinderException");
        Class[] classArray = new Class[finderDescriptor.getMethodParams().size()];
        this.addMethodParams(finderDescriptor.getMethodParams().toArray(classArray), reflectiveMethodDefinition);
        Class clazz = finderDescriptor.getReturnType();
        String string = null;
        string = clazz.isArray() ? clazz.getComponentType().getName() + "[]" : clazz.getName();
        reflectiveMethodDefinition.setReturnType(string);
        int n = finderDescriptor.getMethodParams().size();
        reflectiveMethodDefinition.addLine("Vector parameters = new Vector(" + n + ");");
        Iterator iterator = finderDescriptor.getMethodParams().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            if (clazz2.isPrimitive()) {
                String string2 = Helper.getObjectClass(clazz2).getName();
                reflectiveMethodDefinition.addLine("parameters.addElement(new " + string2 + "(arg" + n2 + "));");
            } else {
                reflectiveMethodDefinition.addLine("parameters.addElement(arg" + n2 + ");");
            }
            ++n2;
        }
        reflectiveMethodDefinition.addLine("boolean local = " + !finderDescriptor.isRemoteQuery() + ";");
        if (clazz.isArray()) {
            reflectiveMethodDefinition.addLine("Class returnType = " + clazz.getComponentType().getName() + ".class;");
        } else {
            reflectiveMethodDefinition.addLine("Class returnType = " + string + ".class;");
        }
        reflectiveMethodDefinition.addLine("Object results = this.getPersistenceManagerTopLink().ejbSelect(local, returnType, \"" + finderDescriptor.getMethodName() + "\", parameters);");
        if (clazz.isPrimitive()) {
            if ((class$java$lang$Number == null ? (class$java$lang$Number = CmpCodeGenPlatform.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(Helper.getObjectClass(clazz))) {
                reflectiveMethodDefinition.addLine("return ((java.lang.Number)results)." + clazz + "Value();");
            } else {
                reflectiveMethodDefinition.addLine("return ((" + Helper.getObjectClass(clazz).getName() + ")results)." + clazz + "Value();");
            }
        } else {
            reflectiveMethodDefinition.addLine("return (" + string + ") results;");
        }
        return reflectiveMethodDefinition;
    }

    protected void addClearFieldsForPoolingMethod() {
        this.clearFieldsForPoolingMethod = new NonreflectiveMethodDefinition();
        this.clearFieldsForPoolingMethod.setName("clearFieldsForPoolingTopLink");
        this.clearFieldsForPoolingMethod.setReturnType("void");
        this.getDefinition().addMethod(this.clearFieldsForPoolingMethod);
    }

    protected void addInitFieldsForCreateMethod() {
        this.initFieldsForCreateMethod = new NonreflectiveMethodDefinition();
        this.initFieldsForCreateMethod.setName("initFieldsForCreateTopLink");
        this.initFieldsForCreateMethod.setReturnType("void");
        this.getDefinition().addMethod(this.initFieldsForCreateMethod);
    }

    protected void addReturnCollectionByNameMethod() {
        this.returnCollectionByNameMethod = new NonreflectiveMethodDefinition();
        this.returnCollectionByNameMethod.setName("returnGeneratedCollectionByName");
        this.returnCollectionByNameMethod.setReturnType("java.util.Collection");
        this.returnCollectionByNameMethod.addArgument("String", "collectionName");
        this.returnCollectionByNameMethod.addArgument("int", "initialSize");
        this.getDefinition().addMethod(this.returnCollectionByNameMethod);
    }

    protected void addRelationshipMaintenanceAmendmentMethod() {
        this.relationshipMaintenanceAmendmentMethod = new NonreflectiveMethodDefinition();
        this.relationshipMaintenanceAmendmentMethod.setName("relationshipMaintenanceAmendmentMethodTopLink");
        this.relationshipMaintenanceAmendmentMethod.setReturnType("void");
        AccessLevel accessLevel = new AccessLevel(AccessLevel.PUBLIC);
        accessLevel.setIsStatic(true);
        this.relationshipMaintenanceAmendmentMethod.setAccessLevel(accessLevel);
        this.relationshipMaintenanceAmendmentMethod.addArgument("oracle.toplink.publicinterface.Descriptor", "descriptor");
        this.getDefinition().addMethod(this.relationshipMaintenanceAmendmentMethod);
    }

    protected void addContainerManagedAttributesAndMethods() throws IntegrityException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(this.getEntityDescriptor().getCmpFields().values());
        Iterator iterator = this.getEntityDescriptor().getCmrFields().values().iterator();
        while (iterator.hasNext()) {
            object = (CmrField)iterator.next();
            if (object.isSynthetic() && !object.getRoleDescriptor().isMany() && object.getRoleDescriptor().getPartnerRole().isMany()) continue;
            arrayList.add(object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            CmpField cmpField = (CmpField)object.next();
            this.generateCodeForCmpField(CmpFieldCodeGenerator.buildCmpCodeGeneratorFor(this, cmpField));
        }
        this.returnCollectionByNameMethod.addLine("throw EJBExceptionFactory.unknownCollectionClass(collectionName);");
    }

    protected void generateCodeForCmpField(CmpFieldCodeGenerator cmpFieldCodeGenerator) {
        if (this.getEntityDescriptor().isEJB20()) {
            cmpFieldCodeGenerator.generateCode(this.getDefinition());
            cmpFieldCodeGenerator.amendReturnCollectionByNameMethod(this.returnCollectionByNameMethod);
            cmpFieldCodeGenerator.amendRelationshipMaintenanceAmendmentMethod(this.relationshipMaintenanceAmendmentMethod);
        }
    }

    protected void addMethodParams(Class[] classArray, ReflectiveMethodDefinition reflectiveMethodDefinition) {
        for (int i = 0; i < classArray.length; ++i) {
            reflectiveMethodDefinition.addArgument(classArray[i], "arg" + i);
        }
    }

    protected void addMethodExceptions(Method method, MethodDefinition methodDefinition) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            methodDefinition.addException(classArray[i].getName());
        }
    }

    protected String collectParamsAsString(ReflectiveMethodDefinition reflectiveMethodDefinition) {
        int n = reflectiveMethodDefinition.getArgumentTypes().size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("arg");
            stringBuffer.append(String.valueOf(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    protected ClassDefinition getDefinition() {
        return this.definition;
    }

    protected Project getProject() {
        return this.project;
    }

    protected EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected Descriptor getDescriptor() {
        return this.getEntityDescriptor().getDescriptor();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

