/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.descriptors.CMPPolicy;
import oracle.toplink.descriptors.FetchGroupManager;
import oracle.toplink.descriptors.changetracking.AttributeChangeTrackingPolicy;
import oracle.toplink.descriptors.changetracking.DeferredChangeDetectionPolicy;
import oracle.toplink.descriptors.copying.CloneCopyPolicy;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.ejb.cmp.DeploymentCustomization;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.ejb.cmp.CmpEnvironment;
import oracle.toplink.internal.ejb.cmp.CmpHelper;
import oracle.toplink.internal.ejb.cmp.CmpProjectReader;
import oracle.toplink.internal.ejb.cmp.PersistenceManagerBase;
import oracle.toplink.internal.ejb.cmp.UOWManager;
import oracle.toplink.internal.ejb.cmp.api.CmpDom;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.mappings.AttributeAccessor;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.InheritancePolicy;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatasourceLogin;
import oracle.toplink.sessions.Project;
import oracle.toplink.sessions.SessionEvent;
import oracle.toplink.sessions.SessionEventAdapter;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.codegen.InheritanceHierarchyBuilder;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public abstract class ProjectDeployment {
    protected static Hashtable deployedProjects;
    protected static Class deploymentClass;
    protected int deployedBeanCount;
    protected CmpDom toplinkCmpDom;
    protected Project project;
    protected ServerSession session;
    protected ConversionManager conversionManager = null;
    protected Map entityDescriptors = null;
    protected Map persistenceManagers = new HashMap();
    private Map beanMap = null;
    public Map inheritanceHierarchy;
    static /* synthetic */ Class class$oracle$toplink$publicinterface$Descriptor;

    protected abstract void setServerPlatform(Session var1);

    protected void initializeCacheSynchronization() {
    }

    public static Hashtable getDeployedProjects() {
        if (deployedProjects == null) {
            deployedProjects = new Hashtable();
        }
        return deployedProjects;
    }

    public static Class getProjectDeploymentClass() {
        return deploymentClass;
    }

    public static void setProjectDeploymentClass(Class clazz) {
        deploymentClass = clazz;
    }

    public static synchronized ProjectDeployment getDeploymentFor(String string) {
        ProjectDeployment projectDeployment = (ProjectDeployment)ProjectDeployment.getDeployedProjects().get(string);
        if (projectDeployment == null) {
            try {
                projectDeployment = (ProjectDeployment)PrivilegedAccessController.newInstanceFromClass(ProjectDeployment.getProjectDeploymentClass());
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().logThrowable(6, exception);
                return null;
            }
            ProjectDeployment.getDeployedProjects().put(string, projectDeployment);
        }
        return projectDeployment;
    }

    public void undeploy() {
        AbstractSessionLog.getLog().finest("ProjectDeployment_undeploy_enter");
        String string = this.getSessionName();
        ProjectDeployment projectDeployment = (ProjectDeployment)ProjectDeployment.getDeployedProjects().get(string);
        if (projectDeployment != null) {
            ServerSession serverSession = projectDeployment.getSession();
            if (serverSession != null) {
                serverSession.logout();
                UOWManager.resetManagerFor(string);
                SessionManager.getManager().getSessions().remove(string);
            }
            ProjectDeployment.getDeployedProjects().remove(string);
        }
        AbstractSessionLog.getLog().finest("ProjectDeployment_undeploy_return");
    }

    protected int getDeployedBeanCount() {
        return this.deployedBeanCount;
    }

    protected void incrementDeployedBeanCount() {
        ++this.deployedBeanCount;
    }

    public String getSessionName() {
        return this.getCmpDom().getSessionName();
    }

    public Project getProject() {
        if (this.project == null) {
            this.setProject(this.readProject());
        }
        return this.project;
    }

    protected Project readProject() {
        return new CmpProjectReader(this.getCmpDom(), this.getJarLoader()).readProject();
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public CmpDom getCmpDom() {
        return this.toplinkCmpDom;
    }

    public void setCmpDom(CmpDom cmpDom) {
        this.toplinkCmpDom = cmpDom;
    }

    public Map getInheritanceHierarchy() {
        if (this.inheritanceHierarchy == null) {
            this.inheritanceHierarchy = InheritanceHierarchyBuilder.buildInheritanceHierarchyTree(this.getProject());
        }
        return this.inheritanceHierarchy;
    }

    public void setBeanMap(Map map) {
        this.beanMap = map;
    }

    public Map getBeanMap() {
        return this.beanMap;
    }

    public abstract void convertOldEntityDescriptors(Object var1);

    public Map getEntityDescriptors() {
        return this.entityDescriptors;
    }

    public PersistenceManagerBase getPersistenceManager(String string) {
        return (PersistenceManagerBase)this.getPersistenceManagers().get(string);
    }

    public void addPersistenceManager(String string, PersistenceManagerBase persistenceManagerBase) {
        this.getPersistenceManagers().put(string, persistenceManagerBase);
    }

    private Map getPersistenceManagers() {
        return this.persistenceManagers;
    }

    protected void configureSession() {
        Project project = this.getProject();
        ServerSession serverSession = null;
        if (project.getDatasourceLogin() instanceof DatabaseLogin) {
            DatabaseLogin databaseLogin = (DatabaseLogin)project.getDatasourceLogin();
            this.configureLogin(databaseLogin);
            DatabaseLogin databaseLogin2 = (DatabaseLogin)databaseLogin.clone();
            this.configureReadLogin(databaseLogin2);
            DatabaseLogin databaseLogin3 = (DatabaseLogin)databaseLogin2.clone();
            this.configureSequencingLogin(databaseLogin3);
            serverSession = this.createServerSession(project, databaseLogin2, databaseLogin3);
        } else {
            serverSession = new ServerSession(project);
        }
        serverSession.setName(this.getCmpDom().getSessionName());
        this.setServerPlatform(serverSession);
        serverSession.setSessionLog(CmpEnvironment.getEnv().getNewLog());
        serverSession.setLogLevel(CmpEnvironment.getEnv().getLogLevel());
        this.configureSingleObjectFinder(serverSession);
        serverSession.setIsFinalizersEnabled(false);
        this.setSession(serverSession);
        SessionManager.getManager().getSessions().put(this.getSessionName(), serverSession);
    }

    protected void configureLoginFromDescriptor(DatabaseLogin databaseLogin) {
    }

    protected void configureLogin(DatabaseLogin databaseLogin) {
        databaseLogin.getProperties().remove("user");
        databaseLogin.getProperties().remove("password");
        this.configureLoginFromDescriptor(databaseLogin);
        databaseLogin.useExternalConnectionPooling();
        databaseLogin.useExternalTransactionController();
    }

    protected void configureDataSource(DatabaseLogin databaseLogin, String string) {
        if (string != null) {
            try {
                databaseLogin.setConnector(new JNDIConnector(new InitialContext(), string));
            }
            catch (NamingException namingException) {
                throw DeploymentException.errorConnectingToDataSource(string, namingException);
            }
        } else {
            throw DeploymentException.errorConnectingToDataSource(string, new NullPointerException());
        }
    }

    protected void configureReadLogin(DatabaseLogin databaseLogin) {
    }

    protected void configureSequencingLogin(DatabaseLogin databaseLogin) {
        databaseLogin.dontUseExternalTransactionController();
    }

    protected ServerSession createServerSession(Project project, DatasourceLogin datasourceLogin, DatasourceLogin datasourceLogin2) {
        return new ServerSession(project, 5, 10, datasourceLogin, datasourceLogin2);
    }

    protected void configureSingleObjectFinder(Session session) {
        if (CmpEnvironment.getEnv().shouldCheckMultipleRows()) {
            SessionEventAdapter sessionEventAdapter = new SessionEventAdapter(){

                public void moreRowsDetected(SessionEvent sessionEvent) {
                    throw QueryException.multipleRowsDetectedFromReadObjectQuery();
                }
            };
            session.getEventManager().addListener(sessionEventAdapter);
        }
    }

    protected ClassLoader getJarLoader() {
        return this.conversionManager.getLoader();
    }

    protected void setJarLoader(ClassLoader classLoader) {
        if (this.conversionManager == null) {
            this.conversionManager = new ConversionManager();
            this.conversionManager.setLoader(classLoader);
        }
    }

    public void configureDescriptors() {
        this.getSession().finest("ProjectDeployment_configureDescriptors_enter", "ejb");
        HashMap<Class, Descriptor> hashMap = new HashMap<Class, Descriptor>();
        Iterator iterator = this.getSession().getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            Class clazz = descriptor.getJavaClass();
            this.getSession().log(1, "ejb", "configuring_descriptor", descriptor, clazz);
            Collection collection = this.getDeployedBeans(clazz);
            if (collection != null) {
                hashMap.putAll(this.configureBeanDescriptor(descriptor, collection));
                continue;
            }
            hashMap.put(clazz, this.configureNonBeanDescriptor(descriptor));
        }
        this.getSession().getProject().setDescriptors(hashMap);
        this.getSession().finest("ProjectDeployment_configureDescriptors_return", "ejb");
    }

    protected Map configureBeanDescriptor(Descriptor descriptor, Collection collection) {
        if (descriptor.getCMPPolicy() == null) {
            descriptor.setCMPPolicy(new CMPPolicy());
        }
        descriptor.getCMPPolicy().setMappedClass(descriptor.getJavaClass());
        HashMap<Class, Descriptor> hashMap = new HashMap<Class, Descriptor>(collection.size());
        Iterator iterator = collection.iterator();
        EntityDescriptor entityDescriptor = (EntityDescriptor)iterator.next();
        if (!descriptor.hasFetchGroupManager() && entityDescriptor.isEJB20()) {
            descriptor.setFetchGroupManager(new FetchGroupManager());
        }
        this.getSession().log(1, "ejb", "ProjectDeployment_configureDescriptor_enter", entityDescriptor.getBeanName());
        if (collection.size() == 1) {
            hashMap.put(entityDescriptor.getBeanClass(), descriptor);
        }
        this.configureDescriptorForInheritance(descriptor);
        this.configureDescriptorForUOWChangePolicy(entityDescriptor);
        this.configureDescriptorMappings(descriptor);
        while (true) {
            Class clazz = entityDescriptor.getConcreteBeanClass();
            this.getSession().log(1, "ejb", "concrete_class", clazz);
            descriptor.setJavaClass(clazz);
            PersistenceManagerBase persistenceManagerBase = this.getPersistenceManager(entityDescriptor.getBeanName());
            this.configureInstantiationPolicy(descriptor, persistenceManagerBase);
            this.configureWrapperPolicies(descriptor, persistenceManagerBase);
            this.configureCopyPolicy(descriptor, persistenceManagerBase);
            if (entityDescriptor.getRemoteImplClass() != null) {
                hashMap.put(entityDescriptor.getRemoteImplClass(), descriptor);
            }
            if (entityDescriptor.getLocalImplClass() != null) {
                hashMap.put(entityDescriptor.getLocalImplClass(), descriptor);
            }
            hashMap.put(clazz, descriptor);
            this.applyRelationshipMaintenanceUpdates(descriptor);
            if (!iterator.hasNext()) break;
            descriptor = (Descriptor)descriptor.clone();
            entityDescriptor = (EntityDescriptor)iterator.next();
        }
        this.getSession().finest("ProjectDeployment_configureDescriptor_return", "ejb");
        return hashMap;
    }

    protected void configureCopyPolicy(Descriptor descriptor, PersistenceManagerBase persistenceManagerBase) {
        CloneCopyPolicy cloneCopyPolicy = new CloneCopyPolicy();
        cloneCopyPolicy.setMethodName("clone");
        cloneCopyPolicy.setWorkingCopyMethodName("__buildWorkingCloneTopLink");
        descriptor.setCopyPolicy(cloneCopyPolicy);
    }

    protected void configureInstantiationPolicy(Descriptor descriptor, PersistenceManagerBase persistenceManagerBase) {
        descriptor.getInstantiationPolicy().useFactoryInstantiationPolicy(persistenceManagerBase.getEJBFactory(), "createBean");
    }

    protected void configureWrapperPolicies(Descriptor descriptor, PersistenceManagerBase persistenceManagerBase) {
        EntityDescriptor entityDescriptor = persistenceManagerBase.getEntityDescriptor();
        if (persistenceManagerBase.getEntityDescriptor().usesLocalRelationships()) {
            descriptor.setWrapperPolicy(persistenceManagerBase.getLocalWrapperPolicy());
        } else {
            descriptor.setWrapperPolicy(persistenceManagerBase.getRemoteWrapperPolicy());
        }
    }

    protected Descriptor configureNonBeanDescriptor(Descriptor descriptor) {
        this.configureDescriptorForInheritance(descriptor);
        this.configureDescriptorMappings(descriptor);
        return descriptor;
    }

    protected void configureDescriptorMappings(Descriptor descriptor) {
        Iterator iterator = descriptor.getMappings().iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Collection collection;
            DatabaseMapping databaseMapping = (DatabaseMapping)iterator.next();
            if (databaseMapping.isForeignReferenceMapping()) {
                collection = this.getDeployedBeans(((ForeignReferenceMapping)databaseMapping).getReferenceClass());
                if (collection == null) continue;
                clazz = ((EntityDescriptor)collection.iterator().next()).getConcreteBeanClass();
                this.getSession().log(1, "ejb", "setting_ref_class_of_foreign_ref_mapping", databaseMapping, clazz);
                ((ForeignReferenceMapping)databaseMapping).setReferenceClass(clazz);
                continue;
            }
            if (!databaseMapping.isAggregateMapping() || (collection = this.getDeployedBeans(((AggregateMapping)databaseMapping).getReferenceClass())) == null) continue;
            clazz = ((EntityDescriptor)collection.iterator().next()).getConcreteBeanClass();
            this.getSession().log(1, "ejb", "setting_ref_class_of_aggregate_mapping", databaseMapping, clazz);
            ((AggregateMapping)databaseMapping).setReferenceClass(clazz);
        }
    }

    protected Collection getDeployedBeans(Class clazz) {
        if (this.getBeanMap() == null) {
            this.setupBeanMap();
        }
        return (Collection)this.getBeanMap().get(clazz);
    }

    private void setupBeanMap() {
        HashMap<Class, ArrayList<EntityDescriptor>> hashMap = new HashMap<Class, ArrayList<EntityDescriptor>>(this.getEntityDescriptors().size());
        Iterator iterator = this.getEntityDescriptors().values().iterator();
        while (iterator.hasNext()) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)iterator.next();
            ArrayList<EntityDescriptor> arrayList = (ArrayList<EntityDescriptor>)hashMap.get(entityDescriptor.getBeanClass());
            if (arrayList == null) {
                arrayList = new ArrayList<EntityDescriptor>(1);
                hashMap.put(entityDescriptor.getBeanClass(), arrayList);
            }
            arrayList.add(entityDescriptor);
        }
        this.setBeanMap(hashMap);
    }

    protected void configureDescriptorForInheritance(Descriptor descriptor) {
        if (!descriptor.hasInheritance()) {
            return;
        }
        InheritancePolicy inheritancePolicy = descriptor.getInheritancePolicy();
        if (inheritancePolicy.isChildDescriptor()) {
            return;
        }
        inheritancePolicy.setUseDescriptorsToValidateInheritedObjects(true);
        this.getSession().log(1, "ejb", "desc_has_inheritance_policy", inheritancePolicy);
        if (inheritancePolicy.getClassExtractionMethodName() == null && !inheritancePolicy.shouldUseClassNameAsIndicator()) {
            Map map = inheritancePolicy.getClassIndicatorMapping();
            HashMap hashMap = new HashMap(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object v;
                Object k = iterator.next();
                if (!(k instanceof Class)) continue;
                Class clazz = (Class)k;
                Collection collection = this.getDeployedBeans(clazz);
                if (collection != null) {
                    clazz = ((EntityDescriptor)collection.iterator().next()).getConcreteBeanClass();
                }
                if ((v = map.get(k)) == null) {
                    throw DescriptorException.missingClassIndicatorField(null, descriptor);
                }
                hashMap.put(clazz, v);
                hashMap.put(v, clazz);
            }
            inheritancePolicy.setClassIndicatorMapping(hashMap);
        }
    }

    protected void applyRelationshipMaintenanceUpdates(Descriptor descriptor) {
        Class[] classArray = new Class[]{class$oracle$toplink$publicinterface$Descriptor == null ? (class$oracle$toplink$publicinterface$Descriptor = ProjectDeployment.class$("oracle.toplink.publicinterface.Descriptor")) : class$oracle$toplink$publicinterface$Descriptor};
        Object[] objectArray = new Object[]{descriptor};
        try {
            Method method = PrivilegedAccessController.getMethod(descriptor.getJavaClass(), "relationshipMaintenanceAmendmentMethodTopLink", classArray, false);
            if (method != null) {
                PrivilegedAccessController.invokeMethod(method, descriptor.getJavaClass(), objectArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getSession().logThrowable(6, "ejb", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.getSession().logThrowable(6, "ejb", illegalAccessException);
        }
    }

    protected void cloneInheritedMappings() {
        ServerSession serverSession = this.getSession();
        Iterator iterator = new HashSet(serverSession.getDescriptors().values()).iterator();
        while (iterator.hasNext()) {
            InheritancePolicy inheritancePolicy;
            Descriptor descriptor = (Descriptor)iterator.next();
            if (!descriptor.hasInheritance() || !(inheritancePolicy = descriptor.getInheritancePolicy()).isChildDescriptor()) continue;
            Iterator iterator2 = descriptor.getMappings().iterator();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(descriptor.getMappings().size());
            ArrayList<DatabaseMapping> arrayList = new ArrayList<DatabaseMapping>(descriptor.getLockableMappings().size());
            while (iterator2.hasNext()) {
                DatabaseMapping databaseMapping = (DatabaseMapping)iterator2.next();
                DatabaseMapping databaseMapping2 = (DatabaseMapping)databaseMapping.clone();
                databaseMapping2.setAttributeAccessor((AttributeAccessor)databaseMapping.getAttributeAccessor().clone());
                databaseMapping2.getAttributeAccessor().initializeAttributes(descriptor.getJavaClass());
                ((Vector)nonSynchronizedVector).add(databaseMapping2);
                if (!descriptor.getLockableMappings().contains(databaseMapping)) continue;
                arrayList.add(databaseMapping2);
            }
            descriptor.setMappings(nonSynchronizedVector);
            descriptor.setLockableMappings(arrayList);
            descriptor.getObjectBuilder().initialize(serverSession);
        }
    }

    public void sessionLogin() {
        DeploymentCustomization deploymentCustomization = this.getDeploymentCustomization();
        this.customizeBeforeLogin(deploymentCustomization);
        this.getSession().login();
        this.cloneInheritedMappings();
        Iterator iterator = this.getPersistenceManagers().values().iterator();
        while (iterator.hasNext()) {
            ((PersistenceManagerBase)iterator.next()).postDeploy();
        }
        this.customizeAfterLogin(deploymentCustomization);
        this.getSession().getDatasourcePlatform().getConversionManager().setLoader(this.getJarLoader());
    }

    public void customizeAfterLogin(DeploymentCustomization deploymentCustomization) {
        if (deploymentCustomization == null) {
            return;
        }
        try {
            deploymentCustomization.afterLoginCustomization(this.getSession());
        }
        catch (Exception exception) {
            throw DeploymentException.errorRunningCustomization(deploymentCustomization.toString(), exception);
        }
    }

    public void customizeBeforeLogin(DeploymentCustomization deploymentCustomization) {
        if (deploymentCustomization == null) {
            return;
        }
        try {
            deploymentCustomization.beforeLoginCustomization(this.getSession());
        }
        catch (Exception exception) {
            throw DeploymentException.errorRunningCustomization(deploymentCustomization.toString(), exception);
        }
    }

    public DeploymentCustomization getDeploymentCustomization() {
        String string = this.getCmpDom().getCustomizationClass();
        if (string == null) {
            return null;
        }
        Class clazz = this.conversionManager.convertClassNameToClass(string);
        try {
            return (DeploymentCustomization)PrivilegedAccessController.newInstanceFromClass(clazz);
        }
        catch (Exception exception) {
            throw DeploymentException.errorCreatingCustomization(string, exception);
        }
    }

    protected void registerMBeans() {
    }

    public ServerSession getSession() {
        return this.session;
    }

    public void setSession(ServerSession serverSession) {
        this.session = serverSession;
    }

    public void configureDescriptorForUOWChangePolicy(EntityDescriptor entityDescriptor) {
        if (!CmpEnvironment.getEnv().shouldUOWTrackChanges()) {
            return;
        }
        Class clazz = entityDescriptor.getBeanClass();
        Descriptor descriptor = this.getProject().getDescriptor(clazz);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(clazz.toString());
        }
        if (descriptor.getObjectChangePolicy() instanceof DeferredChangeDetectionPolicy && CmpHelper.canUOWTrackChanges(entityDescriptor)) {
            descriptor.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
            AbstractSessionLog.getLog().log(1, "OBJECTCHANGEPOLICY_TURNED_ON", clazz);
        } else {
            AbstractSessionLog.getLog().log(6, "objectchangepolicy_turned_off", clazz);
        }
    }

    public synchronized void deployEJB(PersistenceManagerBase persistenceManagerBase) {
        try {
            this.incrementDeployedBeanCount();
            if (this.areAllBeansDeployed()) {
                AbstractSessionLog.getLog().finest("one_time_initialization_of_ProjectDeployment");
                this.configureSession();
                this.configureDescriptors();
                this.initializeCacheSynchronization();
                this.sessionLogin();
                this.registerMBeans();
                this.inheritanceHierarchy = null;
                this.conversionManager = null;
                this.beanMap = null;
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                this.undeploy();
            }
            catch (RuntimeException runtimeException2) {
                this.getSession().log(6, "ejb", "an_error_occured_trying_to_undeploy_bean", persistenceManagerBase.getBeanName());
                this.getSession().logThrowable(6, "ejb", runtimeException2);
            }
            throw runtimeException;
        }
    }

    protected boolean areAllBeansDeployed() {
        return this.getDeployedBeanCount() == this.getTotalBeanCount();
    }

    protected int getTotalBeanCount() {
        return this.getEntityDescriptors().size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

