/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.util.Iterator;
import javax.ejb.EntityBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.internal.ejb.cmp.CmpEnvironment;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.mappings.DatabaseMapping;

public class CmpHelper {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String FIND_BY_PK = "findByPrimaryKey";
    public static final String FINDER_PREFIX = "find";
    public static final String EJB_SELECT_PREFIX = "ejbSelect";
    public static final String UOW_TRACK_CHANGES_POSSIBLE_FLAG = "uowTrackChangesPossibleFlag";
    public static final Class EJB_OBJECT = class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = CmpHelper.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject;
    public static final Class EJB_LOCAL_OBJECT = class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = CmpHelper.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;

    private CmpHelper() {
    }

    public static String buildGetterMethodName(String string) {
        return CmpHelper.buildGetSetMethodName(GET_PREFIX, string);
    }

    public static String getCmpNameFromGetter(String string) {
        return String.valueOf(string.charAt(3)).toLowerCase() + string.substring(4);
    }

    public static String buildSetterMethodName(String string) {
        return CmpHelper.buildGetSetMethodName(SET_PREFIX, string);
    }

    private static String buildGetSetMethodName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(String.valueOf(string2.charAt(0)).toUpperCase());
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }

    public static Class getCmpFieldType(String string, EntityDescriptor entityDescriptor) {
        Class clazz = null;
        if (entityDescriptor.isEJB20()) {
            if (string.equals("tl_unknown_pk")) {
                return CmpEnvironment.UNKNOWN_PK_CLASS_FIELD_TYPE;
            }
            Class[] classArray = new Class[]{};
            String string2 = CmpHelper.buildGetterMethodName(string);
            try {
                clazz = PrivilegedAccessController.getMethodReturnType(PrivilegedAccessController.getMethod(entityDescriptor.getBeanClass(), string2, classArray, false));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw DeploymentException.missing20CmpField(string, entityDescriptor.getBeanName());
            }
        }
        try {
            clazz = PrivilegedAccessController.getFieldType(PrivilegedAccessController.getDeclaredField(entityDescriptor.getBeanClass(), string, false));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw DeploymentException.missing11CmpField(string, entityDescriptor.getBeanName());
        }
        return clazz;
    }

    public static boolean isEntity(Object object) {
        return object instanceof EntityBean;
    }

    public static boolean isEntityWrapper(Class clazz) {
        return EJB_OBJECT.isAssignableFrom(clazz) || EJB_LOCAL_OBJECT.isAssignableFrom(clazz);
    }

    public static boolean canUOWTrackChanges(EntityDescriptor entityDescriptor) {
        Boolean bl = (Boolean)entityDescriptor.getProperties().get(UOW_TRACK_CHANGES_POSSIBLE_FLAG);
        if (bl != null) {
            return bl;
        }
        if (!entityDescriptor.isEJB20()) {
            bl = Boolean.FALSE;
        } else {
            bl = Boolean.TRUE;
            Iterator iterator = entityDescriptor.getDescriptor().getMappings().iterator();
            while (iterator.hasNext()) {
                DatabaseMapping databaseMapping = (DatabaseMapping)iterator.next();
                String string = databaseMapping.getAttributeName();
                if (!databaseMapping.isChangeTrackingSupported()) {
                    bl = Boolean.FALSE;
                    break;
                }
                if (entityDescriptor.getCmrFields().containsKey(string)) continue;
                if (entityDescriptor.getCmpFields().containsKey(string) || string.equals("tl_unknown_pk")) {
                    if (!databaseMapping.isCollectionMapping()) continue;
                    AbstractSessionLog.getLog().log(2, "changetracker_interface_not_implemented", entityDescriptor.getDescriptor().getJavaClass(), string);
                    bl = Boolean.FALSE;
                    break;
                }
                AbstractSessionLog.getLog().log(2, "changetracker_interface_not_implemented_non_cmp", entityDescriptor.getDescriptor().getJavaClass(), string);
                bl = Boolean.FALSE;
                break;
            }
        }
        entityDescriptor.getProperties().put(UOW_TRACK_CHANGES_POSSIBLE_FLAG, bl);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getFromJndi(String string) {
        InitialContext initialContext = null;
        Object object = null;
        try {
            try {
                initialContext = new InitialContext();
                object = initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                throw EJBExceptionFactory.errorGettingObjectFromJndi(string, namingException);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (initialContext == null) throw throwable;
                initialContext.close();
                throw throwable;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (NamingException namingException) {}
        if (initialContext == null) return object;
        initialContext.close();
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

