/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.eis.cobol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.internal.eis.cobol.CobolRedefinedFieldValue;
import oracle.toplink.internal.eis.cobol.CobolRow;
import oracle.toplink.internal.eis.cobol.FieldMetaData;
import oracle.toplink.internal.eis.cobol.RecordMetaData;
import oracle.toplink.internal.eis.cobol.helper.ByteConverter;
import oracle.toplink.internal.eis.cobol.helper.Helper;
import oracle.toplink.internal.helper.DatabaseField;

public class ElementaryFieldMetaData
implements FieldMetaData {
    protected RecordMetaData myRecord;
    protected String myName;
    protected int mySize;
    protected int myOffset;
    protected int myType;
    protected boolean isRedefine;
    protected int decimalPosition;
    protected FieldMetaData myFieldRedefined;
    protected int myArraySize;
    protected String myDependentFieldName;
    protected boolean isSigned;

    public ElementaryFieldMetaData() {
        this.initialize();
    }

    public ElementaryFieldMetaData(String string, String string2) {
        this.initialize(string, string2);
    }

    public ElementaryFieldMetaData(String string, RecordMetaData recordMetaData) {
        this.initialize(string, recordMetaData);
    }

    protected void initialize() {
        this.myRecord = new RecordMetaData();
        this.isRedefine = false;
        this.decimalPosition = -1;
        this.myArraySize = -1;
        this.isSigned = false;
        this.myDependentFieldName = "";
    }

    protected void initialize(String string, String string2) {
        this.myName = string;
        this.myRecord = new RecordMetaData(string2);
        this.isRedefine = false;
        this.decimalPosition = -1;
        this.myArraySize = -1;
        this.isSigned = false;
        this.myDependentFieldName = "";
    }

    protected void initialize(String string, RecordMetaData recordMetaData) {
        this.myName = string;
        this.myRecord = recordMetaData;
        this.isRedefine = false;
        this.decimalPosition = -1;
        this.myArraySize = -1;
        this.isSigned = false;
        this.myDependentFieldName = "";
    }

    public FieldMetaData deepCopy() {
        ElementaryFieldMetaData elementaryFieldMetaData = new ElementaryFieldMetaData(new String(this.myName), this.myRecord.getName());
        elementaryFieldMetaData.setIsFieldRedefine(this.isRedefine);
        elementaryFieldMetaData.setDecimalPosition(this.decimalPosition);
        elementaryFieldMetaData.setArraySize(this.myArraySize);
        elementaryFieldMetaData.setSize(this.mySize);
        elementaryFieldMetaData.setOffset(this.myOffset);
        elementaryFieldMetaData.setType(this.myType);
        if (this.isFieldRedefine()) {
            elementaryFieldMetaData.setFieldRedefined(this.myFieldRedefined.deepCopy());
        }
        elementaryFieldMetaData.setDependentFieldName(new String(this.myDependentFieldName));
        elementaryFieldMetaData.setIsSigned(this.isSigned);
        return elementaryFieldMetaData;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public void setIsSigned(boolean bl) {
        this.isSigned = bl;
    }

    public boolean hasDecimal() {
        return this.decimalPosition != -1;
    }

    public int getDecimalPosition() {
        return this.decimalPosition;
    }

    public void setDecimalPosition(int n) {
        this.decimalPosition = n;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        this.myName = string;
    }

    public RecordMetaData getRecord() {
        return this.myRecord;
    }

    public void setRecord(RecordMetaData recordMetaData) {
        this.myRecord = recordMetaData;
    }

    public int getSize() {
        return this.mySize;
    }

    public void setSize(int n) {
        this.mySize = n;
    }

    public boolean isComposite() {
        return false;
    }

    public Vector getCompositeFields() {
        return new Vector();
    }

    public int getOffset() {
        return this.myOffset;
    }

    public void setOffset(int n) {
        this.myOffset = n;
    }

    public int getType() {
        return this.myType;
    }

    public void setType(int n) {
        this.myType = n;
    }

    public boolean isFieldRedefine() {
        return this.isRedefine;
    }

    public void setIsFieldRedefine(boolean bl) {
        this.isRedefine = bl;
    }

    public void setFieldRedefined(FieldMetaData fieldMetaData) {
        this.myFieldRedefined = fieldMetaData;
        this.isRedefine = fieldMetaData != null;
    }

    public FieldMetaData getFieldRedefined() {
        return this.myFieldRedefined;
    }

    public boolean isArray() {
        return this.myArraySize > 0;
    }

    public int getArraySize() {
        return this.myArraySize;
    }

    public void setArraySize(int n) {
        this.myArraySize = n;
    }

    public boolean dependsOn() {
        return this.myDependentFieldName != "";
    }

    public String getDependentFieldName() {
        return this.myDependentFieldName;
    }

    public void setDependentFieldName(String string) {
        this.myDependentFieldName = string;
    }

    public Object extractValueFromArray(byte[] byArray) {
        Object object;
        if (this.isArray()) {
            int n = this.getOffset();
            ArrayList<String> arrayList = new ArrayList<String>(this.getArraySize());
            for (int i = this.getArraySize(); i > 0; --i) {
                FieldMetaData fieldMetaData = this.deepCopy();
                fieldMetaData.setOffset(n);
                ByteConverter byteConverter = new ByteConverter(fieldMetaData, byArray);
                arrayList.add(byteConverter.getStringValue());
                n += this.mySize;
            }
            object = arrayList;
        } else {
            ByteConverter byteConverter = new ByteConverter(this, byArray);
            object = byteConverter.getStringValue();
        }
        return object;
    }

    protected void adjustArraySize(CobolRow cobolRow) {
        Integer n = Helper.integerFromString(cobolRow.get(this.getDependentFieldName()).toString());
        if (n != null) {
            this.setArraySize(n);
        }
    }

    public void writeOnRow(CobolRow cobolRow, byte[] byArray) {
        DatabaseField databaseField = new DatabaseField(this.getName(), this.getRecord().getName());
        if (this.isArray() && this.dependsOn()) {
            this.adjustArraySize(cobolRow);
        }
        Object object = !this.isFieldRedefine() ? this.extractValueFromArray(byArray) : new CobolRedefinedFieldValue(this, byArray);
        cobolRow.add(databaseField, object);
    }

    public void writeOnArray(CobolRow cobolRow, byte[] byArray) {
        Object object = cobolRow.get(this.getName());
        ByteConverter byteConverter = new ByteConverter();
        if (this.isArray()) {
            if (this.dependsOn()) {
                this.adjustArraySize(cobolRow);
            }
            int n = this.getOffset();
            Iterator iterator = ((List)object).iterator();
            for (int i = this.getArraySize(); i > 0; --i) {
                FieldMetaData fieldMetaData = this.deepCopy();
                fieldMetaData.setOffset(n);
                byteConverter = new ByteConverter(fieldMetaData, byArray);
                String string = (String)iterator.next();
                byteConverter.setBytesToValue(string);
                n += this.mySize;
            }
        } else {
            byteConverter = new ByteConverter(this, byArray);
            byteConverter.setBytesToValue((String)object);
        }
    }
}

