/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.eis.adapters.aq;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import oracle.AQ.AQDequeueOption;
import oracle.AQ.AQEnqueueOption;
import oracle.AQ.AQMessage;
import oracle.AQ.AQQueue;
import oracle.AQ.AQRawPayload;
import oracle.toplink.eis.EISException;
import oracle.toplink.internal.eis.adapters.aq.AQConnection;
import oracle.toplink.internal.eis.adapters.aq.AQDequeueInteractionSpec;
import oracle.toplink.internal.eis.adapters.aq.AQEnqueueInteractionSpec;
import oracle.toplink.internal.eis.adapters.aq.AQInteractionSpec;
import oracle.toplink.internal.eis.adapters.aq.AQRecord;

public class AQInteraction
implements Interaction {
    protected AQConnection connection;

    public AQInteraction(AQConnection aQConnection) {
        this.connection = aQConnection;
    }

    public void clearWarnings() {
    }

    public void close() {
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        AQRecord aQRecord = new AQRecord();
        this.execute(interactionSpec, record, (Record)aQRecord);
        return aQRecord;
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (!(interactionSpec instanceof AQInteractionSpec)) {
            throw EISException.invalidAQInteractionSpecType();
        }
        if (!(record instanceof AQRecord) || !(record2 instanceof AQRecord)) {
            throw EISException.invalidAQRecordType();
        }
        boolean bl = false;
        if (!this.connection.getAQTransaction().isInTransaction()) {
            bl = true;
            this.connection.getAQTransaction().begin();
        }
        try {
            if (interactionSpec instanceof AQEnqueueInteractionSpec) {
                this.executeEnqueueInteraction((AQEnqueueInteractionSpec)interactionSpec, (AQRecord)record, (AQRecord)record2);
            } else if (interactionSpec instanceof AQDequeueInteractionSpec) {
                this.executeDequeueInteraction((AQDequeueInteractionSpec)interactionSpec, (AQRecord)record, (AQRecord)record2);
            }
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
        finally {
            if (bl) {
                this.connection.getAQTransaction().commit();
            }
        }
        return true;
    }

    protected void executeEnqueueInteraction(AQEnqueueInteractionSpec aQEnqueueInteractionSpec, AQRecord aQRecord, AQRecord aQRecord2) throws ResourceException {
        try {
            AQQueue aQQueue = this.connection.getSession().getQueue(aQEnqueueInteractionSpec.getSchema(), aQEnqueueInteractionSpec.getQueue());
            AQMessage aQMessage = aQQueue.createMessage();
            AQRawPayload aQRawPayload = aQMessage.getRawPayload();
            if (aQRecord.size() != 1) {
                throw EISException.invalidAQInput();
            }
            byte[] byArray = null;
            if (aQRecord.get(0) instanceof String) {
                byArray = ((String)aQRecord.get(0)).getBytes();
            } else if (aQRecord.get(0) instanceof byte[]) {
                byArray = (byte[])aQRecord.get(0);
            } else {
                throw EISException.invalidAQInput();
            }
            aQRawPayload.setStream(byArray, byArray.length);
            AQEnqueueOption aQEnqueueOption = aQEnqueueInteractionSpec.getOptions();
            if (aQEnqueueOption == null) {
                aQEnqueueOption = new AQEnqueueOption();
            }
            aQQueue.enqueue(aQEnqueueOption, aQMessage);
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
    }

    protected void executeDequeueInteraction(AQDequeueInteractionSpec aQDequeueInteractionSpec, AQRecord aQRecord, AQRecord aQRecord2) throws ResourceException {
        try {
            AQQueue aQQueue = this.connection.getSession().getQueue(aQDequeueInteractionSpec.getSchema(), aQDequeueInteractionSpec.getQueue());
            AQDequeueOption aQDequeueOption = aQDequeueInteractionSpec.getOptions();
            if (aQDequeueOption == null) {
                aQDequeueOption = new AQDequeueOption();
            }
            AQMessage aQMessage = aQQueue.dequeue(aQDequeueOption);
            aQRecord2.add(aQMessage.getRawPayload().getBytes());
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }
}

