/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.descriptors.changetracking;

import java.beans.PropertyChangeEvent;
import oracle.toplink.descriptors.changetracking.CollectionChangeEvent;
import oracle.toplink.descriptors.changetracking.MapChangeEvent;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.descriptors.changetracking.ObjectChangeListener;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;

public class AttributeChangeListener
extends ObjectChangeListener {
    protected transient Descriptor descriptor;
    protected transient UnitOfWork uow;
    protected ObjectChangeSet objectChangeSet;
    protected Object owner;

    public AttributeChangeListener(Descriptor descriptor, UnitOfWork unitOfWork, Object object) {
        this.descriptor = descriptor;
        this.uow = unitOfWork;
        this.owner = object;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public void setObjectChangeSet(ObjectChangeSet objectChangeSet) {
        this.objectChangeSet = objectChangeSet;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public UnitOfWork getUnitOfWork() {
        return this.uow;
    }

    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.uow = unitOfWork;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.ignoreEvents) {
            return;
        }
        this.internalPropertyChange(propertyChangeEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void internalPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() == propertyChangeEvent.getOldValue()) {
            return;
        }
        DatabaseMapping databaseMapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(propertyChangeEvent.getPropertyName());
        if (databaseMapping == null) {
            throw ValidationException.wrongPropertyNameInChangeEvent(this.owner.getClass(), propertyChangeEvent.getPropertyName());
        }
        if ((databaseMapping instanceof AbstractDirectMapping || databaseMapping instanceof AbstractTransformationMapping) && (propertyChangeEvent.getNewValue() == null && propertyChangeEvent.getOldValue() == null || propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue()))) {
            return;
        }
        super.internalPropertyChange(propertyChangeEvent);
        if (this.uow.getUnitOfWorkChangeSet() == null) {
            this.uow.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
        }
        if (this.objectChangeSet == null) {
            this.objectChangeSet = this.getDescriptor().getObjectBuilder().createObjectChangeSet(this.owner, (UnitOfWorkChangeSet)this.uow.getUnitOfWorkChangeSet(), false, this.uow);
        }
        if (propertyChangeEvent.getClass().equals(ClassConstants.PropertyChangeEvent_Class)) {
            databaseMapping.updateChangeRecord(propertyChangeEvent.getSource(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue(), this.objectChangeSet, this.getUnitOfWork());
            return;
        } else if (propertyChangeEvent.getClass().equals(ClassConstants.CollectionChangeEvent_Class)) {
            CollectionChangeEvent collectionChangeEvent = (CollectionChangeEvent)propertyChangeEvent;
            if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.ADD) {
                databaseMapping.addToCollectionChangeRecord(null, propertyChangeEvent.getNewValue(), this.objectChangeSet, this.getUnitOfWork());
                return;
            } else {
                if (collectionChangeEvent.getChangeType() != CollectionChangeEvent.REMOVE) throw ValidationException.wrongCollectionChangeEventType(collectionChangeEvent.getChangeType());
                databaseMapping.removeFromCollectionChangeRecord(null, propertyChangeEvent.getNewValue(), this.objectChangeSet, this.getUnitOfWork());
            }
            return;
        } else {
            if (!propertyChangeEvent.getClass().equals(ClassConstants.MapChangeEvent_Class)) throw ValidationException.wrongChangeEvent(propertyChangeEvent.getClass());
            MapChangeEvent mapChangeEvent = (MapChangeEvent)propertyChangeEvent;
            if (mapChangeEvent.getChangeType() == MapChangeEvent.ADD) {
                databaseMapping.addToCollectionChangeRecord(mapChangeEvent.getKey(), mapChangeEvent.getNewValue(), this.objectChangeSet, this.getUnitOfWork());
                return;
            } else {
                if (mapChangeEvent.getChangeType() != MapChangeEvent.REMOVE) throw ValidationException.wrongCollectionChangeEventType(mapChangeEvent.getChangeType());
                databaseMapping.removeFromCollectionChangeRecord(mapChangeEvent.getKey(), mapChangeEvent.getNewValue(), this.objectChangeSet, this.getUnitOfWork());
            }
        }
    }

    public void revertChanges() {
        this.clearChanges();
        if (this.objectChangeSet != null) {
            this.objectChangeSet.clear();
        }
    }

    public void clearChanges() {
        super.clearChanges();
        this.objectChangeSet = null;
    }
}

