/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.ValueReadQuery;

public class OraclePlatform
extends DatabasePlatform {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$FunctionExpression;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$RelationExpression;

    public boolean allowsSizeInProcedureArguments() {
        return false;
    }

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write(39);
            Helper.writeHexString(byArray, writer);
            writer.write(39);
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printDate(date));
            writer.write("','yyyy-mm-dd')");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTime(time));
            writer.write("','hh24:mi:ss')");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public ExpressionOperator atan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2");
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = OraclePlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("NUMBER(1) default 0", false));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = OraclePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("NUMBER", 10));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = OraclePlatform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = OraclePlatform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("NUMBER", 19, 4));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = OraclePlatform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("NUMBER", 19, 4));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = OraclePlatform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("NUMBER", 5));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = OraclePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("NUMBER", 3));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OraclePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("NUMBER", 38));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OraclePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = OraclePlatform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR2", 255));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = OraclePlatform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = OraclePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("LONG RAW", false));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = OraclePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("LONG", false));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = OraclePlatform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATE", false));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = OraclePlatform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("DATE", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = OraclePlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("DATE", false));
        return hashtable;
    }

    public DatabaseCall buildCallWithReturning(SQLCall sQLCall, Vector vector) {
        SQLCall sQLCall2 = new SQLCall();
        sQLCall2.setParameters(sQLCall.getParameters());
        sQLCall2.setParameterTypes(sQLCall.getParameterTypes());
        CharArrayWriter charArrayWriter = new CharArrayWriter(200);
        try {
            DatabaseField databaseField;
            int n;
            charArrayWriter.write("BEGIN ");
            charArrayWriter.write(sQLCall.getSQLString());
            charArrayWriter.write(" RETURNING ");
            for (n = 0; n < vector.size(); ++n) {
                databaseField = (DatabaseField)vector.elementAt(n);
                charArrayWriter.write(databaseField.getName());
                if (n + 1 >= vector.size()) continue;
                charArrayWriter.write(", ");
            }
            charArrayWriter.write(" INTO ");
            for (n = 0; n < vector.size(); ++n) {
                databaseField = (DatabaseField)vector.elementAt(n);
                sQLCall2.appendOut(charArrayWriter, databaseField);
                if (n + 1 >= vector.size()) continue;
                charArrayWriter.write(", ");
            }
            charArrayWriter.write("; END;");
            sQLCall2.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return sQLCall2;
    }

    public boolean canBuildCallWithReturning() {
        return true;
    }

    public String getAssignmentString() {
        return ":= ";
    }

    public String getBatchBeginString() {
        return "BEGIN ";
    }

    public String getBatchEndString() {
        return "END;";
    }

    public int getMaxFieldNameSize() {
        return 30;
    }

    public Vector getNativeTableInfo(String string, String string2, Session session) {
        String string3 = "SELECT * FROM ALL_TABLES WHERE OWNER NOT IN ('SYS', 'SYSTEM')";
        if (string != null) {
            string3 = string.indexOf(37) != -1 ? string3 + " AND TABLE_NAME LIKE " + string : string3 + " AND TABLE_NAME = " + string;
        }
        if (string2 != null) {
            string3 = string2.indexOf(37) != -1 ? string3 + " AND OWNER LIKE " + string2 : string3 + " AND OWNER = " + string2;
        }
        return session.executeSelectingCall(new SQLCall(string3));
    }

    public String getProcedureArgumentSetter() {
        return "=>";
    }

    public String getProcedureCallHeader() {
        return "BEGIN ";
    }

    public String getProcedureCallTail() {
        return "; END;";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getStoredProcedureParameterPrefix() {
        return "P_";
    }

    public String getStoredProcedureTerminationToken() {
        return "";
    }

    public ValueReadQuery getSystemChangeNumberQuery() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.setSQLString("SELECT DBMS_FLASHBACK.GET_SYSTEM_CHANGE_NUMBER FROM DUAL");
        return valueReadQuery;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
        }
        return this.timestampQuery;
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int n, int n2) throws SQLException {
        if (n2 == 93 || n2 == 91) {
            return resultSet.getTimestamp(n);
        }
        return resultSet.getObject(n);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(this.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.todayOperator());
        this.addOperator(ExpressionOperator.truncateDate());
        this.addOperator(ExpressionOperator.newTime());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(this.atan2Operator());
        this.addOperator(ExpressionOperator.oracleDateName());
    }

    public boolean isOracle() {
        return true;
    }

    protected ExpressionOperator logOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(66);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("LOG(");
        ((Vector)nonSynchronizedVector).addElement(", 10)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = OraclePlatform.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = OraclePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MAX_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = OraclePlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MAX_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = OraclePlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(9.9999E125));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = OraclePlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = OraclePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = OraclePlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MAX_VALUE));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OraclePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("0"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OraclePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal(new BigInteger("0"), 38));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = OraclePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MIN_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = OraclePlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MIN_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = OraclePlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(-1.0E-129));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = OraclePlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = OraclePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = OraclePlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MIN_VALUE));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OraclePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("0"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OraclePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal(new BigInteger("0"), 38));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence(String string, Integer n) {
        return new ValueReadQuery("SELECT " + this.getQualifiedSequenceName(string) + ".NEXTVAL FROM DUAL");
    }

    protected String getQualifiedSequenceName(String string) {
        if (this.getTableQualifier().equals("")) {
            return string;
        }
        return this.getTableQualifier() + "." + string;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(6);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(" (+) = ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$RelationExpression == null ? (class$oracle$toplink$internal$expressions$RelationExpression = OraclePlatform.class$("oracle.toplink.internal.expressions.RelationExpression")) : class$oracle$toplink$internal$expressions$RelationExpression);
        return expressionOperator;
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public String serverTimestampString() {
        return "SYSDATE";
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return true;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    public boolean supportsStoredFunctions() {
        return true;
    }

    public boolean supportsSelectForUpdateNoWait() {
        return true;
    }

    protected ExpressionOperator todayOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(54);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement("SYSDATE");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = OraclePlatform.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    public boolean canUnwrapOracleConnection() {
        return false;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        return connection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

