/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.queryframework.ValueReadQuery;

public class InformixPlatform
extends DatabasePlatform {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendInformixTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(46);
        String string = Integer.toString(timestamp.getNanos());
        int n = 0;
        for (int i = Math.min(9 - string.length(), 3); i > 0; --i) {
            writer.write(48);
            ++n;
        }
        if (string.length() + n > 3) {
            string = string.substring(0, 3 - n);
        }
        writer.write(string);
        writer.write("'");
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendInformixCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected void appendInformixCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendInformixTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = InformixPlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("SMALLINT default 0", false));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = InformixPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = InformixPlatform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = InformixPlatform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("FLOAT(16)", false));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = InformixPlatform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("FLOAT(32)", false));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = InformixPlatform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = InformixPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = InformixPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("DECIMAL", 32));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = InformixPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("DECIMAL", 32).setLimits(32, -19, 19));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = InformixPlatform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = InformixPlatform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = InformixPlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("BYTE", false));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = InformixPlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("TEXT", false));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = InformixPlatform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATE", false));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = InformixPlatform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("DATETIME HOUR TO SECOND", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = InformixPlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("DATETIME YEAR TO FRACTION(5)", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT DISTINCT(DBINFO('sqlca.sqlerrd1')) FROM systables");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public int getMaxFieldNameSize() {
        return 18;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public boolean isInformix() {
        return true;
    }

    public boolean isInformixOuterJoin() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = InformixPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MAX_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = InformixPlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MAX_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = InformixPlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(3.4028234663852886E38));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = InformixPlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = InformixPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = InformixPlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MAX_VALUE));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = InformixPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("99999999999999999999999999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = InformixPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = InformixPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MIN_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = InformixPlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MIN_VALUE));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = InformixPlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(1.401298464324715E-44));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = InformixPlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = InformixPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = InformixPlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MIN_VALUE));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = InformixPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-99999999999999999999999999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = InformixPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" SERIAL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    public boolean shouldNativeSequenceAcquireValueAfterInsert() {
        return true;
    }

    public boolean shouldPrintConstraintNameAfter() {
        return true;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return false;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

