/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.BatchWritingMechanism;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.databaseaccess.DatasourceAccessor;
import oracle.toplink.internal.databaseaccess.DynamicSQLBatchWritingMechanism;
import oracle.toplink.internal.databaseaccess.ParameterizedSQLBatchWritingMechanism;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.LOBValueWriter;
import oracle.toplink.internal.helper.ThreadCursoredList;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.Login;

public class DatabaseAccessor
extends DatasourceAccessor {
    public static boolean shouldUseDynamicStatements = true;
    protected Hashtable statementCache = new Hashtable(50);
    protected DatabaseMetaData metaData;
    protected BatchWritingMechanism activeBatchWritingMechanism;
    protected DynamicSQLBatchWritingMechanism dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(this);
    protected ParameterizedSQLBatchWritingMechanism parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(this);
    protected LOBValueWriter lobWriter = null;
    protected boolean shouldUseThreadCursors = false;
    protected Statement dynamicStatement;
    protected boolean isDynamicStatementInUse = false;

    public DatabaseAccessor() {
        this.activeBatchWritingMechanism = this.parameterizedMechanism;
    }

    public void flushSelectCalls(Session session) {
        if (this.lobWriter != null) {
            this.lobWriter.buildAndExecuteSelectCalls(session);
        }
    }

    public LOBValueWriter getLOBWriter() {
        if (this.lobWriter == null) {
            this.lobWriter = new LOBValueWriter(this);
        }
        return this.lobWriter;
    }

    public synchronized Statement allocateDynamicStatement() throws SQLException {
        if (this.dynamicStatement == null) {
            this.dynamicStatement = this.getConnection().createStatement();
        }
        if (this.isDynamicStatementInUse()) {
            return this.getConnection().createStatement();
        }
        this.setIsDynamicStatementInUse(true);
        return this.dynamicStatement;
    }

    public boolean isDynamicStatementInUse() {
        return this.isDynamicStatementInUse;
    }

    public synchronized void setIsDynamicStatementInUse(boolean bl) {
        this.isDynamicStatementInUse = bl;
    }

    public void basicBeginTransaction(Session session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().setAutoCommit(false);
            } else {
                this.getPlatform().beginTransaction(this);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    protected void buildConnectLog(Session session) {
        try {
            if (session.shouldLog(4, "connection")) {
                DatabaseMetaData databaseMetaData = this.getConnectionMetaData();
                Object[] objectArray = new Object[]{databaseMetaData.getURL(), databaseMetaData.getUserName(), databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), Helper.cr() + "\t"};
                session.log(4, "connection", "connected_user_database_driver", objectArray, this);
            }
        }
        catch (SQLException sQLException) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public DatabaseRow buildOutputRow(CallableStatement callableStatement, DatabaseCall databaseCall, Session session) throws DatabaseException {
        try {
            return databaseCall.buildOutputRow(callableStatement);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, databaseCall, this, session);
        }
    }

    public Vector buildSortedFields(Vector vector, ResultSet resultSet, Session session) throws DatabaseException {
        Vector<DatabaseField> vector2;
        try {
            Vector vector3 = this.getColumnNames(resultSet, session);
            if (vector == null) {
                vector2 = new Vector<DatabaseField>(vector3.size());
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(new DatabaseField((String)enumeration.nextElement()));
                }
            } else {
                vector2 = this.sortFields(vector, vector3);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
        return vector2;
    }

    protected void connect(Login login) throws DatabaseException {
        super.connect(login);
        this.checkTransactionIsolation();
    }

    protected void checkTransactionIsolation() throws DatabaseException {
        if (!this.isInTransaction() && this.getLogin() != null && ((DatabaseLogin)this.getLogin()).getTransactionIsolation() != -1) {
            try {
                this.getConnection().setTransactionIsolation(((DatabaseLogin)this.getLogin()).getTransactionIsolation());
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException, this, null);
            }
        }
    }

    public void clearStatementCache(Session session) {
        if (this.hasStatementCache()) {
            Enumeration enumeration = this.getStatementCache().elements();
            while (enumeration.hasMoreElements()) {
                Statement statement = (Statement)enumeration.nextElement();
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.setStatementCache(null);
        }
        if (this.dynamicStatement != null) {
            try {
                this.dynamicStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dynamicStatement = null;
            this.setIsDynamicStatementInUse(false);
        }
    }

    public Object clone() {
        DatabaseAccessor databaseAccessor = (DatabaseAccessor)super.clone();
        databaseAccessor.dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(databaseAccessor);
        databaseAccessor.activeBatchWritingMechanism = databaseAccessor.dynamicSQLMechanism;
        databaseAccessor.parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(databaseAccessor);
        return databaseAccessor;
    }

    public void closeCursor(ResultSet resultSet) throws DatabaseException {
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(Statement statement, Session session) throws SQLException {
        if (statement == null) {
            this.decrementCallCount();
            return;
        }
        try {
            session.startOperationProfile("sql execute");
            statement.close();
            Object var4_3 = null;
            session.endOperationProfile("sql execute");
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            session.endOperationProfile("sql execute");
            this.decrementCallCount();
            if (statement == this.dynamicStatement) {
                this.dynamicStatement = null;
                this.setIsDynamicStatementInUse(false);
            }
            throw throwable;
        }
        this.decrementCallCount();
        if (statement == this.dynamicStatement) {
            this.dynamicStatement = null;
            this.setIsDynamicStatementInUse(false);
        }
    }

    public void commitTransaction(Session session) throws DatabaseException {
        this.writesCompleted(session);
        super.commitTransaction(session);
    }

    public void basicCommitTransaction(Session session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().commit();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().commitTransaction(this);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    public DatabaseRow cursorRetrieveNextRow(Vector vector, ResultSet resultSet, Session session) throws DatabaseException {
        try {
            if (resultSet.next()) {
                return this.fetchRow(vector, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    public DatabaseRow cursorRetrievePreviousRow(Vector vector, ResultSet resultSet, Session session) throws DatabaseException {
        try {
            if (resultSet.previous()) {
                return this.fetchRow(vector, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    public void closeDatasourceConnection() throws DatabaseException {
        try {
            this.getConnection().close();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, null);
        }
    }

    public void disconnect(Session session) throws DatabaseException {
        this.clearStatementCache(session);
        super.disconnect(session);
    }

    public void closeConnection() {
        this.clearStatementCache(null);
        super.closeConnection();
    }

    protected void executeBatchedStatement(PreparedStatement preparedStatement, Session session) throws DatabaseException {
        try {
            this.executeDirectNoSelect(preparedStatement, null, session);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.closeStatement(preparedStatement, session);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        try {
            this.closeStatement(preparedStatement, session);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    public Object executeCall(Call call, DatabaseRow databaseRow, Session session) throws DatabaseException {
        return this.basicExecuteCall(call, databaseRow, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object basicExecuteCall(Call call, DatabaseRow databaseRow, Session session) throws DatabaseException {
        DatabaseCall databaseCall;
        Vector<DatabaseRow> vector;
        Statement statement;
        block37: {
            statement = null;
            vector = null;
            databaseCall = null;
            ResultSet resultSet = null;
            try {
                databaseCall = (DatabaseCall)call;
            }
            catch (ClassCastException classCastException) {
                throw QueryException.invalidDatabaseCall(call);
            }
            if (this.getLogin() == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.isInBatchWritingMode(session)) {
                if (!(!databaseCall.isNothingReturned() || databaseCall.hasOptimisticLock() && !this.getPlatform().usesNativeBatchWriting() || databaseCall.shouldBuildOutputRow() || !this.getPlatform().usesJDBCBatchWriting() && databaseCall.hasParameters() || databaseCall.isLOBLocatorNeeded())) {
                    this.getActiveBatchWritingMechanism().appendCall(session, databaseCall);
                    return new Integer(1);
                }
                this.getActiveBatchWritingMechanism().executeBatchedStatements(session);
            }
            try {
                this.incrementCallCount(session);
                if (session.shouldLog(3, "sql")) {
                    session.log(3, "sql", databaseCall.getLogString(this), null, this, false);
                }
                session.startOperationProfile("sql prepare");
                try {
                    statement = databaseCall.prepareStatement(this, databaseRow, session);
                }
                finally {
                    session.endOperationProfile("sql prepare");
                }
                if (databaseCall.isNothingReturned()) {
                    vector = this.executeNoSelect(databaseCall, statement, session);
                    if (databaseCall.isLOBLocatorNeeded()) {
                        this.getLOBWriter().addCall(databaseCall);
                    }
                    break block37;
                }
                if (!databaseCall.getReturnsResultSet() || databaseCall.getReturnsResultSet() && databaseCall.shouldBuildOutputRow()) {
                    vector = session.getPlatform().executeStoredProcedure(databaseCall, (PreparedStatement)statement, this, session);
                    break block37;
                }
                resultSet = this.executeSelect(databaseCall, statement, session);
                if (databaseCall.getFirstResult() != 0) {
                    resultSet.absolute(databaseCall.getFirstResult());
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                databaseCall.matchFieldOrder(resultSet, this, session);
                if (databaseCall.isCursorReturned()) {
                    databaseCall.setStatement(statement);
                    databaseCall.setResult(resultSet);
                    return databaseCall;
                }
                session.startOperationProfile("row fetch");
                try {
                    block39: {
                        block38: {
                            if (!databaseCall.isOneRowReturned()) break block38;
                            if (resultSet.next()) {
                                if (databaseCall.isLOBLocatorNeeded()) {
                                    this.getLOBWriter().fetchLocatorAndWriteValue(databaseCall, resultSet);
                                } else {
                                    vector = this.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, session);
                                }
                                if (resultSet.next()) {
                                    session.getEventManager().moreRowsDetected(databaseCall);
                                }
                                break block39;
                            } else {
                                vector = null;
                            }
                            break block39;
                        }
                        boolean bl = resultSet.next();
                        Vector<DatabaseRow> vector2 = null;
                        if (bl) {
                            if (this.shouldUseThreadCursors()) {
                                Vector vector3 = this.buildThreadCursoredResult(databaseCall, resultSet, statement, resultSetMetaData, session);
                                return vector3;
                            }
                            vector2 = new Vector(20);
                            while (bl) {
                                vector2.addElement(this.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, session));
                                bl = resultSet.next();
                            }
                        } else {
                            vector2 = new Vector<DatabaseRow>(0);
                        }
                        vector = vector2;
                    }
                    resultSet.close();
                }
                finally {
                    session.endOperationProfile("row fetch");
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.closeStatement(statement, session);
                    throw DatabaseException.sqlException(sQLException, databaseCall, this, session);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw DatabaseException.sqlException(sQLException, databaseCall, this, session);
            }
            catch (RuntimeException runtimeException) {
                try {
                    this.closeStatement(statement, session);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(runtimeException instanceof DatabaseException)) throw runtimeException;
                ((DatabaseException)runtimeException).setCall(databaseCall);
                throw runtimeException;
            }
        }
        try {
            this.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, session);
            return vector;
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    protected Vector buildThreadCursoredResult(final DatabaseCall databaseCall, final ResultSet resultSet, final Statement statement, final ResultSetMetaData resultSetMetaData, final Session session) {
        final ThreadCursoredList threadCursoredList = new ThreadCursoredList(20);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                session.startOperationProfile("row fetch");
                try {
                    boolean bl = true;
                    while (bl) {
                        threadCursoredList.addElement(DatabaseAccessor.this.fetchRow(databaseCall.getFields(), resultSet, resultSetMetaData, session));
                        bl = resultSet.next();
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    try {
                        DatabaseAccessor.this.closeStatement(statement, session);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    threadCursoredList.throwException(DatabaseException.sqlException(sQLException, databaseCall, DatabaseAccessor.this, session));
                }
                catch (RuntimeException runtimeException) {
                    try {
                        DatabaseAccessor.this.closeStatement(statement, session);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (runtimeException instanceof DatabaseException) {
                        ((DatabaseException)runtimeException).setCall(databaseCall);
                    }
                    threadCursoredList.throwException(runtimeException);
                }
                finally {
                    session.endOperationProfile("row fetch");
                }
                try {
                    DatabaseAccessor.this.releaseStatement(statement, databaseCall.getSQLString(), databaseCall, session);
                }
                catch (SQLException sQLException) {
                    threadCursoredList.throwException(DatabaseException.sqlException(sQLException, DatabaseAccessor.this, session));
                }
                threadCursoredList.setIsComplete(true);
            }
        };
        thread.start();
        return threadCursoredList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer executeDirectNoSelect(Statement statement, DatabaseCall databaseCall, Session session) throws DatabaseException {
        int n = 0;
        try {
            session.startOperationProfile("sql execute");
            n = databaseCall != null && databaseCall.isDynamicCall(session) ? statement.executeUpdate(databaseCall.getSQLString()) : ((PreparedStatement)statement).executeUpdate();
            if (!this.getPlatform().supportsAutoCommit() && !this.isInTransaction()) {
                this.getPlatform().autoCommit(this);
            }
        }
        catch (SQLException sQLException) {
            if (!this.getPlatform().shouldIgnoreException(sQLException)) {
                throw DatabaseException.sqlException(sQLException, this, session);
            }
        }
        finally {
            session.endOperationProfile("sql execute");
        }
        return new Integer(n);
    }

    protected int executeJDK12BatchStatement(Statement statement, DatabaseCall databaseCall, Session session, boolean bl) throws DatabaseException {
        int n = 0;
        try {
            n = this.getPlatform().executeBatch(statement, bl);
        }
        catch (SQLException sQLException) {
            try {
                this.closeStatement(statement, session);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw DatabaseException.sqlException(sQLException, this, session);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.closeStatement(statement, session);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        try {
            if (databaseCall != null) {
                this.releaseStatement((PreparedStatement)statement, databaseCall.getSQLString(), databaseCall, session);
            } else {
                this.closeStatement(statement, session);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
        return n;
    }

    protected Integer executeNoSelect(DatabaseCall databaseCall, Statement statement, Session session) throws DatabaseException {
        Integer n = this.executeDirectNoSelect(statement, databaseCall, session);
        if (databaseCall.shouldBuildOutputRow()) {
            DatabaseRow databaseRow = this.buildOutputRow((CallableStatement)statement, databaseCall, session);
            databaseCall.getQuery().setProperty("output", databaseRow);
            session.getEventManager().outputParametersDetected(databaseRow, databaseCall);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet executeSelect(DatabaseCall databaseCall, Statement statement, Session session) throws SQLException {
        ResultSet resultSet;
        session.startOperationProfile("sql execute");
        try {
            resultSet = databaseCall.isDynamicCall(session) ? statement.executeQuery(databaseCall.getSQLString()) : ((PreparedStatement)statement).executeQuery();
        }
        finally {
            session.endOperationProfile("sql execute");
        }
        if (databaseCall.shouldBuildOutputRow()) {
            DatabaseRow databaseRow = this.buildOutputRow((CallableStatement)statement, databaseCall, session);
            databaseCall.getQuery().setProperty("output", databaseRow);
            session.getEventManager().outputParametersDetected(databaseRow, databaseCall);
        }
        return resultSet;
    }

    protected DatabaseRow fetchRow(Vector vector, ResultSet resultSet, ResultSetMetaData resultSetMetaData, Session session) throws DatabaseException {
        int n = vector.size();
        Vector<Object> vector2 = new Vector<Object>(n);
        DatabasePlatform databasePlatform = this.getPlatform();
        boolean bl = databasePlatform.shouldOptimizeDataConversion();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)vector.elementAt(i);
            if (databaseField != null) {
                vector2.add(this.getObject(resultSet, databaseField, resultSetMetaData, i + 1, databasePlatform, bl, session));
                continue;
            }
            vector2.add(null);
        }
        return new DatabaseRecord(vector, vector2);
    }

    public BatchWritingMechanism getActiveBatchWritingMechanism() {
        return this.activeBatchWritingMechanism;
    }

    public Vector getColumnInfo(String string, String string2, String string3, String string4, Session session) throws DatabaseException {
        Object[] objectArray;
        if (session.shouldLog(1, "query")) {
            objectArray = new Object[]{string, string2, string3, string4};
            session.log(1, "query", "query_column_meta_data_with_column", objectArray, this);
        }
        objectArray = new Vector();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(session);
            resultSet = this.getConnectionMetaData().getColumns(string, string2, string3, string4);
            Vector vector = this.buildSortedFields(null, resultSet, session);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                objectArray.addElement(this.fetchRow(vector, resultSet, resultSetMetaData, session));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw DatabaseException.sqlException(sQLException, this, session);
        }
        finally {
            this.decrementCallCount();
        }
        return objectArray;
    }

    protected Vector getColumnNames(ResultSet resultSet, Session session) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Vector<String> vector = new Vector<String>(resultSetMetaData.getColumnCount());
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            String string = resultSetMetaData.getColumnName(i + 1);
            if (string == null || string.equals("")) {
                string = "C" + (i + 1);
            }
            if (this.getPlatform().shouldForceFieldNamesToUpperCase()) {
                string = string.toUpperCase();
            }
            vector.addElement(string);
        }
        return vector;
    }

    public Connection getConnection() throws DatabaseException {
        return (Connection)this.getDatasourceConnection();
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.platform;
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    protected Object getObject(ResultSet resultSet, DatabaseField databaseField, ResultSetMetaData resultSetMetaData, int n, DatabasePlatform databasePlatform, boolean bl, Session session) throws DatabaseException {
        Object object = null;
        try {
            int n2 = databaseField.sqlType;
            if (n2 == -1) {
                n2 = resultSetMetaData.getColumnType(n);
                databaseField.setSqlType(n2);
            }
            if (bl) {
                object = this.getObjectThroughOptimizedDataConversion(resultSet, databaseField, n2, n, databasePlatform, session);
                if (object == null) {
                    return null;
                }
                if (object == this) {
                    object = null;
                }
            }
            if (object == null) {
                if (n2 == -4 && databasePlatform.usesStreamsForBinding()) {
                    InputStream inputStream = resultSet.getBinaryStream(n);
                    if (inputStream != null) {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            int n3 = inputStream.read();
                            while (n3 != -1) {
                                byteArrayOutputStream.write(n3);
                                n3 = inputStream.read();
                            }
                            object = byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            throw DatabaseException.errorReadingBlobData();
                        }
                    } else {
                        object = null;
                    }
                } else {
                    object = databasePlatform.getObjectFromResultSet(resultSet, n, n2, session);
                    if (this.isBlob(n2)) {
                        object = databasePlatform.convertObject(object, ClassConstants.APBYTE);
                    }
                    if (this.isClob(n2)) {
                        object = databasePlatform.convertObject(object, ClassConstants.STRING);
                    }
                }
            }
            if (!bl && resultSet.wasNull()) {
                object = null;
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
        return object;
    }

    protected Object getObjectThroughOptimizedDataConversion(ResultSet resultSet, DatabaseField databaseField, int n, int n2, DatabasePlatform databasePlatform, Session session) throws SQLException {
        Object object = this;
        Class clazz = databaseField.type;
        boolean bl = false;
        if (clazz == ClassConstants.PLONG || clazz == ClassConstants.LONG) {
            object = new Long(resultSet.getLong(n2));
            bl = true;
        } else if (n == 12 || n == 1) {
            object = resultSet.getString(n2);
            if (n == 1 && object != null && databasePlatform.shouldTrimStrings()) {
                object = Helper.rightTrimString((String)object);
            }
        } else if (clazz == ClassConstants.INTEGER || clazz == ClassConstants.PINT) {
            object = new Integer(resultSet.getInt(n2));
            bl = true;
        } else if (clazz == ClassConstants.FLOAT || clazz == ClassConstants.PFLOAT) {
            object = new Float(resultSet.getFloat(n2));
            bl = true;
        } else if (clazz == ClassConstants.DOUBLE || clazz == ClassConstants.PDOUBLE) {
            object = new Double(resultSet.getDouble(n2));
            bl = true;
        } else if (clazz == ClassConstants.SHORT || clazz == ClassConstants.PSHORT) {
            object = new Short(resultSet.getShort(n2));
            bl = true;
        } else if (Helper.shouldOptimizeDates() && clazz != null && (n == 92 || n == 91 || n == 93)) {
            String string = resultSet.getString(n2);
            object = databasePlatform.convertObject(string, clazz);
        } else if (clazz != null && (n == 92 || n == 91 || n == 93)) {
            if (clazz == ClassConstants.SQLDATE) {
                object = resultSet.getDate(n2);
            } else if (clazz == ClassConstants.TIME) {
                object = resultSet.getTime(n2);
            } else if (clazz == ClassConstants.TIMESTAMP) {
                object = resultSet.getTimestamp(n2);
            }
        }
        if (bl && resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    protected boolean hasStatementCache() {
        return this.statementCache != null && !this.statementCache.isEmpty();
    }

    protected synchronized Hashtable getStatementCache() {
        if (this.statementCache == null) {
            this.statementCache = new Hashtable(50);
        }
        return this.statementCache;
    }

    public Vector getTableInfo(String string, String string2, String string3, String[] stringArray, Session session) throws DatabaseException {
        Object[] objectArray;
        if (session.shouldLog(1, "query")) {
            objectArray = new Object[]{string, string2, string3};
            session.log(1, "query", "query_column_meta_data", objectArray, this);
        }
        objectArray = new Vector();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(session);
            resultSet = this.getConnectionMetaData().getTables(string, string2, string3, stringArray);
            Vector vector = this.buildSortedFields(null, resultSet, session);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                objectArray.addElement(this.fetchRow(vector, resultSet, resultSetMetaData, session));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw DatabaseException.sqlException(sQLException, this, session);
        }
        finally {
            this.decrementCallCount();
        }
        return objectArray;
    }

    public boolean isDatasourceConnected() {
        try {
            return !this.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, null);
        }
    }

    protected boolean isInBatchWritingMode(Session session) {
        return this.getPlatform().usesBatchWriting() && this.isInTransaction();
    }

    public boolean shouldUseThreadCursors() {
        return this.shouldUseThreadCursors;
    }

    public void setShouldUseThreadCursors(boolean bl) {
        this.shouldUseThreadCursors = bl;
    }

    public Statement prepareStatement(DatabaseCall databaseCall, Session session) throws SQLException {
        return this.prepareStatement(databaseCall, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement prepareStatement(DatabaseCall databaseCall, Session session, boolean bl) throws SQLException {
        Statement statement = null;
        if (databaseCall.usesBinding(session) && databaseCall.shouldCacheStatement(session)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                statement = (PreparedStatement)this.getStatementCache().get(databaseCall.getSQLString());
                if (statement != null) {
                    this.getStatementCache().remove(databaseCall.getSQLString());
                }
            }
        }
        if (statement == null) {
            if (databaseCall.isCallableStatementRequired()) {
                if (databaseCall.isResultSetScrollable()) {
                    statement = this.getConnection().prepareCall(databaseCall.getSQLString(), databaseCall.getResultSetType(), databaseCall.getResultSetConcurrency());
                    statement.setFetchSize(databaseCall.getResultSetFetchSize());
                } else {
                    statement = this.getConnection().prepareCall(databaseCall.getSQLString());
                }
            } else if (databaseCall.isResultSetScrollable()) {
                statement = this.getConnection().prepareStatement(databaseCall.getSQLString(), databaseCall.getResultSetType(), databaseCall.getResultSetConcurrency());
                statement.setFetchSize(databaseCall.getResultSetFetchSize());
            } else {
                statement = databaseCall.isDynamicCall(session) ? this.allocateDynamicStatement() : (bl ? this.getPlatform().getConnection(session, this.getConnection()).prepareStatement(databaseCall.getSQLString()) : this.getConnection().prepareStatement(databaseCall.getSQLString()));
            }
        }
        return statement;
    }

    protected void reconnect(Session session) {
        this.clearStatementCache(session);
        super.reconnect(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseStatement(Statement statement, String string, DatabaseCall databaseCall, Session session) throws SQLException {
        if (databaseCall.usesBinding(session) && databaseCall.shouldCacheStatement(session)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                if (!this.getStatementCache().containsKey(string)) {
                    preparedStatement.clearParameters();
                    if (this.getStatementCache().size() > this.getPlatform().getStatementCacheSize()) {
                        PreparedStatement preparedStatement2 = (PreparedStatement)this.getStatementCache().remove(this.getStatementCache().keys().nextElement());
                        this.closeStatement(preparedStatement2, session);
                    } else {
                        this.decrementCallCount();
                    }
                    this.getStatementCache().put(string, preparedStatement);
                } else {
                    this.closeStatement(statement, session);
                }
            }
        } else if (statement == this.dynamicStatement) {
            if (databaseCall.getQueryTimeout() > 0) {
                statement.setQueryTimeout(0);
            }
            if (databaseCall.getMaxRows() > 0) {
                statement.setMaxRows(0);
            }
            if (databaseCall.getResultSetFetchSize() > 0) {
                statement.setFetchSize(0);
            }
            this.setIsDynamicStatementInUse(false);
            this.decrementCallCount();
        } else {
            this.closeStatement(statement, session);
        }
    }

    public void rollbackTransaction(Session session) throws DatabaseException {
        this.getActiveBatchWritingMechanism().clear();
        super.rollbackTransaction(session);
    }

    public void basicRollbackTransaction(Session session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().rollback();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().rollbackTransaction(this);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, this, session);
        }
    }

    public void setActiveBatchWritingMechanismToParameterizedSQL() {
        this.activeBatchWritingMechanism = this.parameterizedMechanism;
        if (((DatabaseLogin)this.getLogin()).getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE) {
            ((DatabaseLogin)this.getLogin()).setMaxBatchWritingSize(DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE);
        }
    }

    public void setActiveBatchWritingMechanismToDynamicSQL() {
        this.activeBatchWritingMechanism = this.dynamicSQLMechanism;
        if (((DatabaseLogin)this.getLogin()).getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE) {
            ((DatabaseLogin)this.getLogin()).setMaxBatchWritingSize(DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE);
        }
    }

    protected void setStatementCache(Hashtable hashtable) {
        this.statementCache = hashtable;
    }

    protected Vector sortFields(Vector vector, Vector vector2) {
        Vector<DatabaseField> vector3 = new Vector<DatabaseField>(vector2.size());
        Vector vector4 = (Vector)vector.clone();
        Enumeration enumeration = vector2.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DatabaseField databaseField = null;
            Enumeration enumeration2 = vector4.elements();
            while (enumeration2.hasMoreElements()) {
                databaseField = (DatabaseField)enumeration2.nextElement();
                if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                    if (!databaseField.getName().equalsIgnoreCase(string)) continue;
                    bl = true;
                    vector3.addElement(databaseField);
                    break;
                }
                if (!databaseField.getName().equals(string)) continue;
                bl = true;
                vector3.addElement(databaseField);
                break;
            }
            if (bl) {
                vector4.removeElement(databaseField);
            } else {
                vector3.addElement(new DatabaseField());
            }
            bl = false;
        }
        return vector3;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("DatabaseAccessor(");
        if (this.isConnected()) {
            stringWriter.write(ToStringLocalization.buildMessage("connected", null));
        } else {
            stringWriter.write(ToStringLocalization.buildMessage("disconnected", null));
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }

    private boolean isBlob(int n) {
        return n == 2004 || n == -4;
    }

    private boolean isClob(int n) {
        return n == 2005 || n == -1;
    }

    public void writesCompleted(Session session) {
        if (this.isInBatchWritingMode(session)) {
            this.getActiveBatchWritingMechanism().executeBatchedStatements(session);
        }
    }
}

