/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.JavaPlatform;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.ValueReadQuery;

public class DB2Platform
extends DatabasePlatform {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$FunctionExpression;

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("BLOB(x'");
            Helper.writeHexString(byArray, writer);
            writer.write("')");
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendDB2Date(date, writer);
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendDB2Date(Date date, Writer writer) throws IOException {
        writer.write("'");
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        if (calendar.get(2) + 1 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(2) + 1));
        writer.write(47);
        if (calendar.get(5) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(5)));
        writer.write(47);
        writer.write(Integer.toString(calendar.get(1)));
        writer.write("'");
        Helper.releaseCalendar(calendar);
    }

    protected void appendDB2Timestamp(Timestamp timestamp, Writer writer) throws IOException {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (calendar.get(11) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(11)));
        writer.write(46);
        if (calendar.get(12) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(12)));
        writer.write(46);
        if (calendar.get(13) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(13)));
        writer.write(46);
        Helper.releaseCalendar(calendar);
        String string = Integer.toString(timestamp.getNanos());
        int n = 0;
        for (int i = Math.min(9 - string.length(), 6); i > 0; --i) {
            writer.write(48);
            ++n;
        }
        if (string.length() + n > 6) {
            string = string.substring(0, 6 - n);
        }
        writer.write(string);
    }

    protected void appendDB2Calendar(Calendar calendar, Writer writer) throws IOException {
        int n;
        int n2;
        int n3;
        Object object;
        if (!Helper.getDefaultTimeZone().equals(calendar.getTimeZone())) {
            object = Helper.allocateCalendar();
            JavaPlatform.setTimeInMillis((Calendar)object, JavaPlatform.getTimeInMillis(calendar));
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
            Helper.releaseCalendar((Calendar)object);
        } else {
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
        }
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (n3 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(n3));
        writer.write(46);
        if (n2 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(n2));
        writer.write(46);
        if (n < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(n));
        writer.write(46);
        object = Integer.toString(calendar.get(14));
        int n4 = 0;
        for (int i = Math.min(3 - ((String)object).length(), 3); i > 0; --i) {
            writer.write(48);
            ++n4;
        }
        if (((String)object).length() + n4 > 3) {
            object = ((String)object).substring(0, 3 - n4);
        }
        writer.write((String)object);
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Timestamp(timestamp, writer);
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Calendar(calendar, writer);
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DB2Platform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DB2Platform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = DB2Platform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = DB2Platform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = DB2Platform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = DB2Platform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DB2Platform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Platform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DB2Platform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("DECIMAL", 15));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = DB2Platform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = DB2Platform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DB2Platform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DB2Platform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = DB2Platform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATE", false));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = DB2Platform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("TIME", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DB2Platform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("TIMESTAMP", false));
        return hashtable;
    }

    public int getMaxFieldNameSize() {
        return 128;
    }

    public int getMaxForeignKeyNameSize() {
        return 18;
    }

    public Vector getNativeTableInfo(String string, String string2, Session session) {
        String string3 = "SELECT * FROM SYSIBM.SYSTABLES WHERE TBCREATOR NOT IN ('SYS', 'SYSTEM')";
        if (string != null) {
            string3 = string.indexOf(37) != -1 ? string3 + " AND TBNAME LIKE " + string : string3 + " AND TBNAME = " + string;
        }
        if (string2 != null) {
            string3 = string2.indexOf(37) != -1 ? string3 + " AND TBCREATOR LIKE " + string2 : string3 + " AND TBCREATOR = " + string2;
        }
        return session.executeSelectingCall(new SQLCall(string3));
    }

    public String getProcedureCallHeader() {
        return "CALL ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getProcedureEndString() {
        return "END";
    }

    public String getProcedureBeginString() {
        return "BEGIN";
    }

    public String getProcedureAsString() {
        return "";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT DISTINCT CURRENT TIMESTAMP FROM SYSIBM.SYSTABLES");
        }
        return this.timestampQuery;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(28, "UCASE"));
        this.addOperator(ExpressionOperator.simpleFunction(29, "LCASE"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.todayOperator());
        this.addOperator(ExpressionOperator.simpleFunction(42, "DECIMAL"));
        this.addOperator(ExpressionOperator.simpleFunction(114, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(48, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(53, "DATE"));
    }

    public boolean isDB2() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DB2Platform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MAX_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = DB2Platform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Integer.MAX_VALUE));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = DB2Platform.class$("java.lang.Float")) : class$java$lang$Float, new Float(1.2345679E8f));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = DB2Platform.class$("java.lang.Double")) : class$java$lang$Double, new Double(3.4028234663852886E38));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = DB2Platform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DB2Platform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Platform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DB2Platform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("0.999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DB2Platform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MIN_VALUE));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = DB2Platform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Integer.MIN_VALUE));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = DB2Platform.class$("java.lang.Float")) : class$java$lang$Float, new Float(-1.2345679E8f));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = DB2Platform.class$("java.lang.Double")) : class$java$lang$Double, new Double(1.4E-45f));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = DB2Platform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DB2Platform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DB2Platform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-999999999999999"));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DB2Platform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("-0.999999999999999"));
        return hashtable;
    }

    public boolean shouldIgnoreException(SQLException sQLException) {
        if (sQLException.getMessage().equals("No data found") || sQLException.getMessage().equals("No row was found for FETCH, UPDATE or DELETE; or the result of a query is an empty table") || sQLException.getErrorCode() == 100) {
            return true;
        }
        return super.shouldIgnoreException(sQLException);
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    protected ExpressionOperator todayOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(54);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement("CURRENT TIMESTAMP");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = DB2Platform.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

