/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.exceptions.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.toplink.internal.helper.Helper;

public class ExceptionMessageGenerator {
    public static String buildMessage(Class clazz, int n, Object[] objectArray) {
        String string = System.getProperty("line.separator");
        String string2 = Helper.getShortClassName(clazz);
        String string3 = "";
        ResourceBundle resourceBundle = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = "null";
        }
        resourceBundle = ResourceBundle.getBundle("oracle.toplink.exceptions.i18n." + string2 + "Resource", Locale.getDefault());
        try {
            string3 = resourceBundle.getString(String.valueOf(n));
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = ResourceBundle.getBundle("oracle.toplink.exceptions.i18n.ExceptionResource", Locale.getDefault());
            String string4 = resourceBundle.getString("NoExceptionTranslationForThisLocale");
            Object[] objectArray2 = new Object[]{string};
            return ExceptionMessageGenerator.format(string3, objectArray) + ExceptionMessageGenerator.format(string4, objectArray2);
        }
        return ExceptionMessageGenerator.format(string3, objectArray);
    }

    protected static String format(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            ResourceBundle resourceBundle = null;
            resourceBundle = ResourceBundle.getBundle("oracle.toplink.exceptions.i18n.ExceptionResource", Locale.getDefault());
            String string2 = resourceBundle.getString("ErrorFormattingMessage");
            Vector<Object> vector = new Vector<Object>();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        vector.add(objectArray[i].toString());
                        continue;
                    }
                    catch (Exception exception2) {
                        vector.add(exception2);
                    }
                }
            }
            return MessageFormat.format(string2, string, vector);
        }
    }

    public static String getHeader(String string) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("oracle.toplink.exceptions.i18n.ExceptionResource", Locale.getDefault());
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[" + string + "]";
        }
    }
}

