/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.exceptions;

import java.lang.reflect.Method;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.indirection.ContainerIndirectionPolicy;
import oracle.toplink.internal.indirection.IndirectionPolicy;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorEvent;

public class DescriptorException
extends ValidationException {
    protected transient Descriptor descriptor;
    protected transient DatabaseMapping mapping;
    public static final int ATTRIBUTE_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 1;
    public static final int ATTRIBUTE_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 2;
    public static final int ATTRIBUTE_NAME_NOT_SPECIFIED = 6;
    public static final int ATTRIBUTE_TYPE_NOT_VALID = 7;
    public static final int CLASS_INDICATOR_FIELD_NOT_FOUND = 8;
    public static final int DIRECT_FIELD_NAME_NOT_SET = 9;
    public static final int FIELD_NAME_NOT_SET_IN_MAPPING = 10;
    public static final int FOREIGN_KEYS_DEFINED_INCORRECTLY = 11;
    public static final int IDENTITY_MAP_NOT_SPECIFIED = 12;
    public static final int ILLEGAL_ACCESS_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 13;
    public static final int ILLEGAL_ACCESS_WHILE_CLONING = 14;
    public static final int ILLEGAL_ACCESS_WHILE_CONSTRUCTOR_INSTANTIATION = 15;
    public static final int ILLEGAL_ACCESS_WHILE_EVENT_EXECUTION = 16;
    public static final int ILLEGAL_ACCESS_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 17;
    public static final int ILLEGAL_ACCESS_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 18;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_ATTRIBUTE_METHOD = 19;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_FIELD_TO_METHOD = 20;
    public static final int ILLEGAL_ACCESS_WHILE_INVOKING_ROW_EXTRACTION_METHOD = 21;
    public static final int ILLEGAL_ACCESS_WHILE_METHOD_INSTANTIATION = 22;
    public static final int ILLEGAL_ACCESS_WHILE_OBSOLETE_EVENT_EXECUTION = 23;
    public static final int ILLEGAL_ACCESS_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 24;
    public static final int ILLEGAL_ACCESS_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 25;
    public static final int ILLEGAL_ARGUMENT_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 26;
    public static final int ILLEGAL_ARGUMENT_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 27;
    public static final int ILLEGAL_ARGUMENT_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 28;
    public static final int ILLEGAL_ARGUMENT_WHILE_INVOKING_ATTRIBUTE_METHOD = 29;
    public static final int ILLEGAL_ARGUMENT_WHILE_INVOKING_FIELD_TO_METHOD = 30;
    public static final int ILLEGAL_ARGUMENT_WHILE_OBSOLETE_EVENT_EXECUTION = 31;
    public static final int ILLEGAL_ARGUMENT_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 32;
    public static final int ILLEGAL_ARGUMENT_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 33;
    public static final int INSTANTIATION_WHILE_CONSTRUCTOR_INSTANTIATION = 34;
    public static final int INVALID_DATA_MODIFICATION_EVENT = 35;
    public static final int INVALID_DATA_MODIFICATION_EVENT_CODE = 36;
    public static final int INVALID_DESCRIPTOR_EVENT_CODE = 37;
    public static final int INVALID_IDENTITY_MAP = 38;
    public static final int JAVA_CLASS_NOT_SPECIFIED = 39;
    public static final int DESCRIPTOR_FOR_INTERFACE_IS_MISSING = 40;
    public static final int MAPPING_FOR_SEQUENCE_NUMBER_FIELD = 41;
    public static final int MISSING_CLASS_FOR_INDICATOR_FIELD_VALUE = 43;
    public static final int MISSING_CLASS_INDICATOR_FIELD = 44;
    public static final int MISSING_MAPPING_FOR_FIELD = 45;
    public static final int NO_MAPPING_FOR_PRIMARY_KEY = 46;
    public static final int MULTIPLE_TABLE_PRIMARY_KEY_NOT_SPECIFIED = 47;
    public static final int MULTIPLE_WRITE_MAPPINGS_FOR_FIELD = 48;
    public static final int NO_ATTRIBUTE_TRANSFORMATION_METHOD = 49;
    public static final int NO_FIELD_NAME_FOR_MAPPING = 50;
    public static final int NO_FOREIGN_KEYS_ARE_SPECIFIED = 51;
    public static final int NO_REFERENCE_KEY_IS_SPECIFIED = 52;
    public static final int NO_RELATION_TABLE = 53;
    public static final int NO_SOURCE_RELATION_KEYS_SPECIFIED = 54;
    public static final int NO_SUCH_METHOD_ON_FIND_OBSOLETE_METHOD = 55;
    public static final int NO_SUCH_METHOD_ON_INITIALIZING_ATTRIBUTE_METHOD = 56;
    public static final int NO_SUCH_METHOD_WHILE_CONSTRUCTOR_INSTANTIATION = 57;
    public static final int NO_SUCH_METHOD_WHILE_CONVERTING_TO_METHOD = 58;
    public static final int NO_SUCH_FIELD_WHILE_INITIALIZING_ATTRIBUTES_IN_INSTANCE_VARIABLE_ACCESSOR = 59;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_ATTRIBUTES_IN_METHOD_ACCESSOR = 60;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_CLASS_EXTRACTION_METHOD = 61;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_COPY_POLICY = 62;
    public static final int NO_SUCH_METHOD_WHILE_INITIALIZING_INSTANTIATION_POLICY = 63;
    public static final int NO_TARGET_FOREIGN_KEYS_SPECIFIED = 64;
    public static final int NO_TARGET_RELATION_KEYS_SPECIFIED = 65;
    public static final int NOT_DESERIALIZABLE = 66;
    public static final int NOT_SERIALIZABLE = 67;
    public static final int NULL_FOR_NON_NULL_AGGREGATE = 68;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 69;
    public static final int NULL_POINTER_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 70;
    public static final int NULL_POINTER_WHILE_SETTING_VALUE_THRU_INSTANCE_VARIABLE_ACCESSOR = 71;
    public static final int NULL_POINTER_WHILE_SETTING_VALUE_THRU_METHOD_ACCESSOR = 72;
    public static final int PARENT_DESCRIPTOR_NOT_SPECIFIED = 73;
    public static final int PRIMARY_KEY_FIELDS_NOT_SPECIFIED = 74;
    public static final int REFERENCE_CLASS_NOT_SPECIFIED = 75;
    public static final int REFERENCE_DESCRIPTOR_IS_NOT_AGGREGATE = 77;
    public static final int REFERENCE_KEY_FIELD_NOT_PROPERLY_SPECIFIED = 78;
    public static final int REFERENCE_TABLE_NOT_SPECIFIED = 79;
    public static final int RELATION_KEY_FIELD_NOT_PROPERLY_SPECIFIED = 80;
    public static final int RETURN_TYPE_IN_GET_ATTRIBUTE_ACCESSOR = 81;
    public static final int SECURITY_ON_FIND_METHOD = 82;
    public static final int SECURITY_ON_FIND_OBSOLETE_METHOD = 83;
    public static final int SECURITY_ON_INITIALIZING_ATTRIBUTE_METHOD = 84;
    public static final int SECURITY_WHILE_CONVERTING_TO_METHOD = 85;
    public static final int SECURITY_WHILE_INITIALIZING_ATTRIBUTES_IN_INSTANCE_VARIABLE_ACCESSOR = 86;
    public static final int SECURITY_WHILE_INITIALIZING_ATTRIBUTES_IN_METHOD_ACCESSOR = 87;
    public static final int SECURITY_WHILE_INITIALIZING_CLASS_EXTRACTION_METHOD = 88;
    public static final int SECURITY_WHILE_INITIALIZING_COPY_POLICY = 89;
    public static final int SECURITY_WHILE_INITIALIZING_INSTANTIATION_POLICY = 90;
    public static final int SEQUENCE_NUMBER_PROPERTY_NOT_SPECIFIED = 91;
    public static final int SIZE_MISMATCH_OF_FOREIGN_KEYS = 92;
    public static final int TABLE_NOT_PRESENT = 93;
    public static final int TABLE_NOT_SPECIFIED = 94;
    public static final int TARGET_FOREIGN_KEYS_SIZE_MISMATCH = 96;
    public static final int TARGET_INVOCATION_WHILE_CLONING = 97;
    public static final int TARGET_INVOCATION_WHILE_EVENT_EXECUTION = 98;
    public static final int TARGET_INVOCATION_WHILE_GETTING_VALUE_THRU_METHOD_ACCESSOR = 99;
    public static final int TARGET_INVOCATION_WHILE_INSTANTIATING_METHOD_BASED_PROXY = 100;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_ATTRIBUTE_METHOD = 101;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_FIELD_TO_METHOD = 102;
    public static final int TARGET_INVOCATION_WHILE_INVOKING_ROW_EXTRACTION_METHOD = 103;
    public static final int TARGET_INVOCATION_WHILE_METHOD_INSTANTIATION = 104;
    public static final int TARGET_INVOCATION_WHILE_OBSOLETE_EVENT_EXECUTION = 105;
    public static final int TARGET_INVOCATION_WHILE_SETTING_VALUE_THRU_METHOD_ACESSOR = 106;
    public static final int VALUE_NOT_FOUND_IN_CLASS_INDICATOR_MAPPING = 108;
    public static final int WRITE_LOCK_FIELD_IN_CHILD_DESCRIPTOR = 109;
    public static final int DESCRIPTOR_IS_MISSING = 110;
    public static final int MULTIPLE_TABLE_PRIMARY_KEY_MUST_BE_FULLY_QUALIFIED = 111;
    public static final int ONLY_ONE_TABLE_CAN_BE_ADDED_WITH_THIS_METHOD = 112;
    public static final int NULL_POINTER_WHILE_CONSTRUCTOR_INSTANTIATION = 113;
    public static final int NULL_POINTER_WHILE_METHOD_INSTANTIATION = 114;
    public static final int NO_ATTRBUTE_VALUE_CONVERSION_TO_FIELD_VALUE_PROVIDED = 115;
    public static final int NO_FIELD_VALUE_CONVERSION_TO_ATTRIBUTE_VALUE_PROVIDED = 116;
    public static final int LOCK_MAPPING_CANNOT_BE_READONLY = 118;
    public static final int LOCK_MAPPING_MUST_BE_READONLY = 119;
    public static final int CHILD_DOES_NOT_DEFINE_ABSTRACT_QUERY_KEY = 120;
    public static final int SET_EXISTENCE_CHECKING_NOT_UNDERSTOOD = 122;
    public static final int VALUE_HOLDER_INSTANTIATION_MISMATCH = 125;
    public static final int NO_SUB_CLASS_MATCH = 126;
    public static final int RETURN_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 127;
    public static final int RETURN_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 128;
    public static final int PARAMETER_AND_MAPPING_WITH_INDIRECTION_MISMATCH = 129;
    public static final int PARAMETER_AND_MAPPING_WITHOUT_INDIRECTION_MISMATCH = 130;
    public static final int GET_METHOD_RETURN_TYPE_NOT_VALID = 131;
    public static final int SET_METHOD_PARAMETER_TYPE_NOT_VALID = 133;
    public static final int ILLEGAL_TABLE_NAME_IN_MULTIPLE_TABLE_FOREIGN_KEY = 135;
    public static final int ATTRIBUTE_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 138;
    public static final int RETURN_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 139;
    public static final int PARAMETER_AND_MAPPING_WITH_TRANSPARENT_INDIRECTION_MISMATCH = 140;
    public static final int FIELD_IS_NOT_PRESENT_IN_DATABASE = 141;
    public static final int TABLE_IS_NOT_PRESENT_IN_DATABASE = 142;
    public static final int MULTIPLE_TABLE_INSERT_ORDER_MISMATCH = 143;
    public static final int INVALID_USE_OF_TRANSPARENT_INDIRECTION = 144;
    public static final int MISSING_INDIRECT_CONTAINER_CONSTRUCTOR = 145;
    public static final int COULD_NOT_INSTANTIATE_INDIRECT_CONTAINER_CLASS = 146;
    public static final int INVALID_CONTAINER_POLICY = 147;
    public static final int INVALID_CONTAINER_POLICY_WITH_TRANSPARENT_INDIRECTION = 148;
    public static final int INVALID_USE_OF_NO_INDIRECTION = 149;
    public static final int INDIRECT_CONTAINER_INSTANTIATION_MISMATCH = 150;
    public static final int INVALID_MAPPING_OPERATION = 151;
    public static final int INVALID_INDIRECTION_POLICY_OPERATION = 152;
    public static final int REFERENCE_DESCRIPTOR_IS_NOT_AGGREGATECOLLECTION = 153;
    public static final int INVALID_INDIRECTION_CONTAINER_CLASS = 154;
    public static final int MISSING_FOREIGN_KEY_TRANSLATION = 155;
    public static final int STRUCTURE_NAME_NOT_SET_IN_MAPPING = 156;
    public static final int NORMAL_DESCRIPTORS_DO_NOT_SUPPORT_NON_RELATIONAL_EXTENSIONS = 157;
    public static final int PARENT_CLASS_IS_SELF = 158;
    public static final int PROXY_INDIRECTION_NOT_AVAILABLE = 159;
    public static final int INVALID_ATTRIBUTE_TYPE_FOR_PROXY_INDIRECTION = 160;
    public static final int INVALID_GET_RETURN_TYPE_FOR_PROXY_INDIRECTION = 161;
    public static final int INVALID_SET_PARAMETER_TYPE_FOR_PROXY_INDIRECTION = 162;
    public static final int INCORRECT_COLLECTION_POLICY = 163;
    public static final int INVALID_AMENDMENT_METHOD = 164;
    public static final int ERROR_OCCURED_IN_AMENDMENT_METHOD = 165;
    public static final int VARIABLE_ONE_TO_ONE_MAPPING_IS_NOT_DEFINED = 166;
    public static final int NO_CONSTRUCTOR_INDIRECT_COLLECTION_CLASS = 167;
    public static final int TARGET_INVOCATION_WHILE_CONSTRUCTOR_INSTANTIATION = 168;
    public static final int TARGET_INVOCATION_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 169;
    public static final int ILLEGAL_ACCESS_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 170;
    public static final int INSTANTIATION_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 171;
    public static final int NO_SUCH_METHOD_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 172;
    public static final int NULL_POINTER_WHILE_CONSTRUCTOR_INSTANTIATION_OF_FACTORY = 173;
    public static final int ILLEGAL_ACCESS_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 174;
    public static final int TARGET_INVOCATION_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 175;
    public static final int NULL_POINTER_WHILE_METHOD_INSTANTIATION_OF_FACTORY = 176;
    public static final int NO_MAPPING_FOR_ATTRIBUTENAME = 177;
    public static final int NO_MAPPING_FOR_ATTRIBUTENAME_IN_ENTITY_BEAN = 178;
    public static final int UNSUPPORTED_TYPE_FOR_BIDIRECTIONAL_RELATIONSHIP_MAINTENANCE = 179;
    public static final int REFERENCE_DESCRIPTOR_CANNOT_BE_AGGREGATE = 180;
    public static final int ATTRIBUTE_TRANSFORMER_CLASS_NOT_FOUND = 181;
    public static final int FIELD_TRANSFORMER_CLASS_NOT_FOUND = 182;
    public static final int ATTRIBUTE_TRANSFORMER_CLASS_INVALID = 183;
    public static final int FIELD_TRANSFORMER_CLASS_INVALID = 184;
    public static final int RETURNING_POLICY_FIELD_TYPE_CONFLICT = 185;
    public static final int RETURNING_POLICY_FIELD_INSERT_CONFLICT = 186;
    public static final int RETURNING_POLICY_AND_DESCRIPTOR_FIELD_TYPE_CONFLICT = 187;
    public static final int RETURNING_POLICY_UNMAPPED_FIELD_TYPE_NOT_SET = 188;
    public static final int RETURNING_POLICY_MAPPED_FIELD_TYPE_NOT_SET = 189;
    public static final int RETURNING_POLICY_MAPPING_NOT_SUPPORTED = 190;
    public static final int RETURNING_POLICY_FIELD_NOT_SUPPORTED = 191;
    public static final int CUSTOM_QUERY_AND_RETURNING_POLICY_CONFLICT = 192;
    public static final int NO_CUSTOM_QUERY_FOR_RETURNING_POLICY = 193;
    public static final int CLASS_EXTRACTION_METHOD_MUST_BE_STATIC = 194;
    public static final int ISOLATED_DESCRIPTOR_REFERENCED_BY_SHARED_DESCRIPTOR = 195;
    public static final int UPDATE_ALL_FIELDS_NOT_SET = 196;
    public static final int INVALID_MAPPING_TYPE = 197;
    public static final int NEED_TO_IMPLEMENT_CHANGETRACKER = 198;
    public static final int NEED_TO_IMPLEMENT_FETCHGROUPTRACKER = 199;
    public static final int ATTEMPT_TO_REGISTER_DEAD_INDIRECTION = 200;
    public static final int UNIT_OF_WORK_ISOLATED_OBJECTS_ACCESSED_IN_SESSION = 201;
    static /* synthetic */ Class class$oracle$toplink$exceptions$DescriptorException;

    protected DescriptorException(String string) {
        super(string);
    }

    protected DescriptorException(String string, DatabaseMapping databaseMapping) {
        this(string);
        if (databaseMapping != null) {
            this.mapping = databaseMapping;
            this.descriptor = databaseMapping.getDescriptor();
        }
    }

    protected DescriptorException(String string, Descriptor descriptor) {
        this(string);
        this.descriptor = descriptor;
    }

    protected DescriptorException(String string, Descriptor descriptor, Throwable throwable) {
        this(string, descriptor);
        this.setInternalException(throwable);
    }

    public static DescriptorException attemptToRegisterDeadIndirection(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 200, objectArray), databaseMapping);
        descriptorException.setErrorCode(200);
        return descriptorException;
    }

    public static DescriptorException attributeAndMappingWithIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 1, objectArray), databaseMapping);
        descriptorException.setErrorCode(1);
        return descriptorException;
    }

    public static DescriptorException attributeAndMappingWithoutIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 2, objectArray), databaseMapping);
        descriptorException.setErrorCode(2);
        return descriptorException;
    }

    public static DescriptorException attributeAndMappingWithTransparentIndirectionMismatch(DatabaseMapping databaseMapping, String string) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 138, objectArray), databaseMapping);
        descriptorException.setErrorCode(138);
        return descriptorException;
    }

    public static DescriptorException attributeNameNotSpecified() {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 6, objectArray));
        descriptorException.setErrorCode(6);
        return descriptorException;
    }

    public static DescriptorException attributeTransformerClassNotFound(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 181, objectArray));
        descriptorException.setErrorCode(181);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException attributeTransformerClassInvalid(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 183, objectArray));
        descriptorException.setErrorCode(183);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException attributeTypeNotValid(CollectionMapping collectionMapping) {
        Object[] objectArray = new Object[]{collectionMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 7, objectArray), collectionMapping);
        descriptorException.setErrorCode(7);
        return descriptorException;
    }

    public static DescriptorException childDoesNotDefineAbstractQueryKeyOfParent(Descriptor descriptor, Descriptor descriptor2, String string) {
        Object[] objectArray = new Object[]{string, descriptor2, descriptor};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 120, objectArray));
        descriptorException.setErrorCode(120);
        return descriptorException;
    }

    public static DescriptorException classIndicatorFieldNotFound(Descriptor descriptor, Descriptor descriptor2) {
        Object[] objectArray = new Object[]{descriptor2, descriptor, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 8, objectArray), descriptor2);
        descriptorException.setErrorCode(8);
        return descriptorException;
    }

    public static DescriptorException couldNotInstantiateIndirectContainerClass(Class clazz, Exception exception) {
        Object[] objectArray = new Object[]{clazz, Helper.getShortClassName(clazz)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 146, objectArray));
        descriptorException.setErrorCode(146);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException descriptorForInterfaceIsMissing(String string) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 40, objectArray));
        descriptorException.setErrorCode(40);
        return descriptorException;
    }

    public static DescriptorException descriptorIsMissing(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 110, objectArray), databaseMapping);
        descriptorException.setErrorCode(110);
        return descriptorException;
    }

    public static DescriptorException directFieldNameNotSet(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 9, objectArray), databaseMapping);
        descriptorException.setErrorCode(9);
        return descriptorException;
    }

    public static DescriptorException errorOccuredInAmendmentMethod(Class clazz, String string, Exception exception, Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 165, objectArray), descriptor, exception);
        descriptorException.setErrorCode(165);
        return descriptorException;
    }

    public static DescriptorException fieldIsNotPresentInDatabase(Descriptor descriptor, String string, String string2) {
        Object[] objectArray = new Object[]{string2, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 141, objectArray), descriptor);
        descriptorException.setErrorCode(141);
        return descriptorException;
    }

    public static DescriptorException fieldNameNotSetInMapping(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 10, objectArray), databaseMapping);
        descriptorException.setErrorCode(10);
        return descriptorException;
    }

    public static DescriptorException fieldTransformerClassNotFound(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 182, objectArray));
        descriptorException.setErrorCode(182);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException fieldTransformerClassInvalid(String string, AbstractTransformationMapping abstractTransformationMapping, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 184, objectArray));
        descriptorException.setErrorCode(182);
        descriptorException.setMapping(abstractTransformationMapping);
        descriptorException.setInternalException(exception);
        return descriptorException;
    }

    public static DescriptorException foreignKeysDefinedIncorrectly(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 11, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(11);
        return descriptorException;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getMessage() {
        if (this.getDescriptor() == null) {
            return super.getMessage();
        }
        if (this.getMapping() != null) {
            return super.getMessage() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("MappingHeader") + this.getMapping().toString() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("DescriptorHeader") + this.getDescriptor().toString();
        }
        return super.getMessage() + DescriptorException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("DescriptorHeader") + this.getDescriptor().toString();
    }

    public static DescriptorException getMethodReturnTypeNotValid(CollectionMapping collectionMapping) {
        Object[] objectArray = new Object[]{collectionMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 131, objectArray), collectionMapping);
        descriptorException.setErrorCode(131);
        return descriptorException;
    }

    public static DescriptorException identityMapNotSpecified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 12, objectArray), descriptor);
        descriptorException.setErrorCode(12);
        return descriptorException;
    }

    public static DescriptorException illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 13, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(13);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileCloning(Object object, String string, Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{object, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 14, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(14);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileConstructorInstantiation(Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 15, objectArray), descriptor, exception);
        descriptorException.setErrorCode(15);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileConstructorInstantiationOfFactory(Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 170, objectArray), descriptor, exception);
        descriptorException.setErrorCode(170);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileEventExecution(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 16, objectArray), descriptor, exception);
        descriptorException.setErrorCode(16);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 17, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(17);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInstantiatingMethodBasedProxy(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 18, objectArray));
        descriptorException.setErrorCode(18);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingAttributeMethod(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 19, objectArray));
        descriptorException.setErrorCode(19);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingFieldToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 20, objectArray));
        descriptorException.setErrorCode(20);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileInvokingRowExtractionMethod(DatabaseRow databaseRow, Method method, Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{databaseRow, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 21, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(21);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileMethodInstantiation(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 22, objectArray), descriptor, exception);
        descriptorException.setErrorCode(22);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileMethodInstantiationOfFactory(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 174, objectArray), descriptor, exception);
        descriptorException.setErrorCode(174);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileObsoleteEventExecute(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 23, objectArray), descriptor, exception);
        descriptorException.setErrorCode(23);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileSettingValueThruInstanceVariableAccessor(String string, String string2, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, String.valueOf(object), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 24, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(24);
        return descriptorException;
    }

    public static DescriptorException illegalAccessWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 25, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(25);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileGettingValueThruInstanceVariableAccessor(String string, String string2, String string3, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 26, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(26);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 27, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(27);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInstantiatingMethodBasedProxy(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 28, objectArray));
        descriptorException.setErrorCode(28);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInvokingAttributeMethod(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 29, objectArray));
        descriptorException.setErrorCode(29);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileInvokingFieldToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 30, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setErrorCode(30);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileObsoleteEventExecute(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 31, objectArray), descriptor, exception);
        descriptorException.setErrorCode(31);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileSettingValueThruInstanceVariableAccessor(String string, String string2, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{String.valueOf(object), string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 32, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(32);
        return descriptorException;
    }

    public static DescriptorException illegalArgumentWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 33, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(33);
        return descriptorException;
    }

    public static DescriptorException illegalTableNameInMultipleTableForeignKeyField(Descriptor descriptor, DatabaseTable databaseTable) {
        Object[] objectArray = new Object[]{databaseTable};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 135, objectArray), descriptor);
        descriptorException.setErrorCode(135);
        return descriptorException;
    }

    public static DescriptorException incorrectCollectionPolicy(DatabaseMapping databaseMapping, Class clazz, Class clazz2) {
        Object[] objectArray = new Object[]{clazz, clazz2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 163, objectArray), databaseMapping);
        descriptorException.setErrorCode(163);
        return descriptorException;
    }

    public static DescriptorException indirectContainerInstantiationMismatch(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), object, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 150, objectArray), databaseMapping);
        descriptorException.setErrorCode(150);
        return descriptorException;
    }

    public static DescriptorException instantiationWhileConstructorInstantiation(Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 34, objectArray), descriptor, exception);
        descriptorException.setErrorCode(34);
        return descriptorException;
    }

    public static DescriptorException instantiationWhileConstructorInstantiationOfFactory(Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 171, objectArray), descriptor, exception);
        descriptorException.setErrorCode(171);
        return descriptorException;
    }

    public static DescriptorException invalidAmendmentMethod(Class clazz, String string, Exception exception, Descriptor descriptor) {
        Object[] objectArray = new Object[]{clazz, string, CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 164, objectArray), descriptor, exception);
        descriptorException.setErrorCode(164);
        return descriptorException;
    }

    public static DescriptorException invalidAttributeTypeForProxyIndirection(Class clazz, Class[] classArray, DatabaseMapping databaseMapping) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), databaseMapping.getDescriptor().getJavaClass().getName(), clazz.getName(), stringBuffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 160, objectArray), databaseMapping);
        descriptorException.setErrorCode(160);
        return descriptorException;
    }

    public static DescriptorException invalidContainerPolicy(ContainerPolicy containerPolicy, Class clazz) {
        Object[] objectArray = new Object[]{containerPolicy, clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 147, objectArray));
        descriptorException.setErrorCode(147);
        return descriptorException;
    }

    public static DescriptorException invalidContainerPolicyWithTransparentIndirection(DatabaseMapping databaseMapping, ContainerPolicy containerPolicy) {
        Object[] objectArray = new Object[]{containerPolicy};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 148, objectArray), databaseMapping);
        descriptorException.setErrorCode(148);
        return descriptorException;
    }

    public static DescriptorException invalidDataModificationEvent(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 35, objectArray), databaseMapping);
        descriptorException.setErrorCode(35);
        return descriptorException;
    }

    public static DescriptorException invalidDataModificationEventCode(Object object, ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 36, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(36);
        return descriptorException;
    }

    public static DescriptorException invalidDescriptorEventCode(DescriptorEvent descriptorEvent, Descriptor descriptor) {
        Object[] objectArray = new Object[]{new Integer(descriptorEvent.getEventCode())};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 37, objectArray), descriptor);
        descriptorException.setErrorCode(37);
        return descriptorException;
    }

    public static DescriptorException invalidGetMethodReturnTypeForProxyIndirection(Class clazz, Class[] classArray, DatabaseMapping databaseMapping) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        Object[] objectArray = new Object[]{databaseMapping.getGetMethodName(), databaseMapping.getDescriptor().getJavaClass().getName(), clazz.getName(), stringBuffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 161, objectArray), databaseMapping);
        descriptorException.setErrorCode(161);
        return descriptorException;
    }

    public static DescriptorException invalidIdentityMap(Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 38, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(38);
        return descriptorException;
    }

    public static DescriptorException invalidIndirectionContainerClass(ContainerIndirectionPolicy containerIndirectionPolicy, Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 154, objectArray), containerIndirectionPolicy.getMapping());
        descriptorException.setErrorCode(154);
        return descriptorException;
    }

    public static DescriptorException invalidIndirectionPolicyOperation(IndirectionPolicy indirectionPolicy, String string) {
        Object[] objectArray = new Object[]{indirectionPolicy, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 152, objectArray), indirectionPolicy.getMapping());
        descriptorException.setErrorCode(152);
        return descriptorException;
    }

    public static DescriptorException invalidMappingOperation(DatabaseMapping databaseMapping, String string) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 151, objectArray), databaseMapping);
        descriptorException.setErrorCode(151);
        return descriptorException;
    }

    public static DescriptorException invalidSetMethodParameterTypeForProxyIndirection(Class clazz, Class[] classArray, DatabaseMapping databaseMapping) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i == classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        Object[] objectArray = new Object[]{databaseMapping.getSetMethodName(), databaseMapping.getDescriptor().getJavaClass().getName(), clazz.getName(), stringBuffer.toString(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 162, objectArray), databaseMapping);
        descriptorException.setErrorCode(162);
        return descriptorException;
    }

    public static DescriptorException invalidUseOfNoIndirection(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 149, objectArray), databaseMapping);
        descriptorException.setErrorCode(149);
        return descriptorException;
    }

    public static DescriptorException invalidUseOfTransparentIndirection(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        String string = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 144, objectArray);
        DescriptorException descriptorException = new DescriptorException(string, databaseMapping);
        descriptorException.setErrorCode(144);
        return descriptorException;
    }

    public static DescriptorException isolateDescriptorReferencedBySharedDescriptor(String string, String string2, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string, string2};
        String string3 = ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 195, objectArray);
        DescriptorException descriptorException = new DescriptorException(string3, databaseMapping);
        descriptorException.setErrorCode(195);
        return descriptorException;
    }

    public static DescriptorException javaClassNotSpecified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 39, objectArray), descriptor);
        descriptorException.setErrorCode(39);
        return descriptorException;
    }

    public static DescriptorException mappingCanNotBeReadOnly(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getDescriptor().getClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 118, objectArray), databaseMapping);
        descriptorException.setErrorCode(118);
        return descriptorException;
    }

    public static DescriptorException mappingForSequenceNumberField(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 41, objectArray));
        descriptorException.setErrorCode(41);
        descriptorException.setDescriptor(descriptor);
        return descriptorException;
    }

    public static DescriptorException missingClassForIndicatorFieldValue(Object object, Descriptor descriptor) {
        Object[] objectArray = new Object[]{object, object.getClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 43, objectArray), descriptor);
        descriptorException.setErrorCode(43);
        return descriptorException;
    }

    public static DescriptorException missingClassIndicatorField(DatabaseRow databaseRow, Descriptor descriptor) {
        Object[] objectArray = new Object[]{databaseRow};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 44, objectArray), descriptor);
        descriptorException.setErrorCode(44);
        return descriptorException;
    }

    public static DescriptorException missingForeignKeyTranslation(ForeignReferenceMapping foreignReferenceMapping, DatabaseField databaseField) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 155, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(155);
        return descriptorException;
    }

    public static DescriptorException missingIndirectContainerConstructor(Class clazz) {
        Object[] objectArray = new Object[]{clazz.getName(), clazz.getName() + "()"};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 145, objectArray));
        descriptorException.setErrorCode(145);
        return descriptorException;
    }

    public static DescriptorException missingMappingForField(DatabaseField databaseField, Descriptor descriptor) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 45, objectArray));
        descriptorException.setErrorCode(45);
        descriptorException.setDescriptor(descriptor);
        return descriptorException;
    }

    public static DescriptorException multipleTableInsertOrderMismatch(Descriptor descriptor) {
        Object[] objectArray = new Object[]{descriptor.getMultipleTableInsertOrder(), descriptor.getTables(), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 143, objectArray));
        descriptorException.setErrorCode(143);
        descriptorException.setDescriptor(descriptor);
        return descriptorException;
    }

    public static DescriptorException multipleTablePrimaryKeyMustBeFullyQualified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 111, objectArray), descriptor);
        descriptorException.setErrorCode(111);
        return descriptorException;
    }

    public static DescriptorException multipleTablePrimaryKeyNotSpecified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 47, objectArray), descriptor);
        descriptorException.setErrorCode(47);
        return descriptorException;
    }

    public static DescriptorException multipleWriteMappingsForField(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 48, objectArray), databaseMapping);
        descriptorException.setErrorCode(48);
        return descriptorException;
    }

    public static DescriptorException mustBeReadOnlyMappingWhenStoredInCache(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getDescriptor().getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 119, objectArray), databaseMapping);
        descriptorException.setErrorCode(119);
        return descriptorException;
    }

    public static DescriptorException noAttributeTransformationMethod(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 49, objectArray), databaseMapping);
        descriptorException.setErrorCode(49);
        return descriptorException;
    }

    public static DescriptorException noAttributeValueConversionToFieldValueProvided(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 115, objectArray), databaseMapping);
        descriptorException.setErrorCode(115);
        return descriptorException;
    }

    public static DescriptorException noConstructorIndirectionContainerClass(ContainerIndirectionPolicy containerIndirectionPolicy, Class clazz) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 167, objectArray), containerIndirectionPolicy.getMapping());
        descriptorException.setErrorCode(167);
        return descriptorException;
    }

    public static DescriptorException noFieldNameForMapping(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 50, objectArray), databaseMapping);
        descriptorException.setErrorCode(50);
        return descriptorException;
    }

    public static DescriptorException noFieldValueConversionToAttributeValueProvided(Object object, DatabaseField databaseField, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object, databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 116, objectArray), databaseMapping);
        descriptorException.setErrorCode(116);
        return descriptorException;
    }

    public static DescriptorException noForeignKeysAreSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 51, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(51);
        return descriptorException;
    }

    public static DescriptorException noMappingForPrimaryKey(DatabaseField databaseField, Descriptor descriptor) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 46, objectArray), descriptor);
        descriptorException.setErrorCode(46);
        return descriptorException;
    }

    public static DescriptorException noReferenceKeyIsSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 52, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(52);
        return descriptorException;
    }

    public static DescriptorException noRelationTable(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 53, objectArray), databaseMapping);
        descriptorException.setErrorCode(53);
        return descriptorException;
    }

    public static DescriptorException normalDescriptorsDoNotSupportNonRelationalExtensions(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 157, objectArray), descriptor);
        descriptorException.setErrorCode(157);
        return descriptorException;
    }

    public static DescriptorException noSourceRelationKeysSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 54, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(54);
        return descriptorException;
    }

    public static DescriptorException noSubClassMatch(Class clazz, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 126, objectArray), databaseMapping);
        descriptorException.setErrorCode(126);
        return descriptorException;
    }

    public static DescriptorException noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 59, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(59);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodOnFindObsoleteMethod(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 55, objectArray), descriptor, exception);
        descriptorException.setErrorCode(55);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodOnInitializingAttributeMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 56, objectArray));
        descriptorException.setErrorCode(56);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConstructorInstantiation(Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 57, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(57);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConstructorInstantiationOfFactory(Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 172, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(172);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileConvertingToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 58, objectArray));
        descriptorException.setErrorCode(58);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingAttributesInMethodAccessor(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 60, objectArray));
        descriptorException.setErrorCode(60);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingClassExtractionMethod(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 61, objectArray), descriptor, exception);
        descriptorException.setErrorCode(61);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingCopyPolicy(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 62, objectArray), descriptor, exception);
        descriptorException.setErrorCode(62);
        return descriptorException;
    }

    public static DescriptorException noSuchMethodWhileInitializingInstantiationPolicy(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 63, objectArray), descriptor, exception);
        descriptorException.setErrorCode(63);
        return descriptorException;
    }

    public static DescriptorException noTargetForeignKeysSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 64, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(64);
        return descriptorException;
    }

    public static DescriptorException noTargetRelationKeysSpecified(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 65, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(65);
        return descriptorException;
    }

    public static DescriptorException notDeserializable(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 66, objectArray));
        descriptorException.setErrorCode(66);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException notSerializable(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 67, objectArray));
        descriptorException.setErrorCode(67);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException nullForNonNullAggregate(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 68, objectArray), databaseMapping);
        descriptorException.setErrorCode(68);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileConstructorInstantiation(Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 113, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(113);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileConstructorInstantiationOfFactory(Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 173, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(173);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruInstanceVariableAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 69, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(69);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 70, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(70);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileMethodInstantiation(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 114, objectArray), descriptor, exception);
        descriptorException.setErrorCode(114);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileMethodInstantiationOfFactory(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 176, objectArray), descriptor, exception);
        descriptorException.setErrorCode(176);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileSettingValueThruInstanceVariableAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 71, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(71);
        return descriptorException;
    }

    public static DescriptorException nullPointerWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object)};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 72, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(72);
        return descriptorException;
    }

    public static DescriptorException onlyOneTableCanBeAddedWithThisMethod(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 112, objectArray), descriptor);
        descriptorException.setErrorCode(112);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 129, objectArray), databaseMapping);
        descriptorException.setErrorCode(129);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithoutIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 130, objectArray), databaseMapping);
        descriptorException.setErrorCode(130);
        return descriptorException;
    }

    public static DescriptorException parameterAndMappingWithTransparentIndirectionMismatch(DatabaseMapping databaseMapping, String string) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 140, objectArray), databaseMapping);
        descriptorException.setErrorCode(140);
        return descriptorException;
    }

    public static DescriptorException parentClassIsSelf(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 158, objectArray), descriptor);
        descriptorException.setErrorCode(158);
        return descriptorException;
    }

    public static DescriptorException parentDescriptorNotSpecified(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 73, objectArray), descriptor);
        descriptorException.setErrorCode(73);
        return descriptorException;
    }

    public static DescriptorException primaryKeyFieldsNotSepcified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 74, objectArray), descriptor);
        descriptorException.setErrorCode(74);
        return descriptorException;
    }

    public static DescriptorException proxyIndirectionNotAvailable(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 159, objectArray), databaseMapping);
        descriptorException.setErrorCode(159);
        return descriptorException;
    }

    public static DescriptorException referenceClassNotSpecified(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 75, objectArray), databaseMapping);
        descriptorException.setErrorCode(75);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorIsNotAggregate(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 77, objectArray), databaseMapping);
        descriptorException.setErrorCode(77);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorCannotBeAggregate(DatabaseMapping databaseMapping) {
        DescriptorException descriptorException = new DescriptorException("Reference descriptor cannot be aggregate.", databaseMapping);
        descriptorException.setErrorCode(180);
        return descriptorException;
    }

    public static DescriptorException referenceDescriptorIsNotAggregateCollection(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 153, objectArray), databaseMapping);
        descriptorException.setErrorCode(153);
        return descriptorException;
    }

    public static DescriptorException referenceKeyFieldNotProperlySpecified(DatabaseField databaseField, ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 78, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(78);
        return descriptorException;
    }

    public static DescriptorException referenceTableNotSpecified(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 79, objectArray), databaseMapping);
        descriptorException.setErrorCode(79);
        return descriptorException;
    }

    public static DescriptorException relationKeyFieldNotProperlySpecified(DatabaseField databaseField, ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{databaseField};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 80, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(80);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 127, objectArray), databaseMapping);
        descriptorException.setErrorCode(127);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithoutIndirectionMismatch(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 128, objectArray), databaseMapping);
        descriptorException.setErrorCode(128);
        return descriptorException;
    }

    public static DescriptorException returnAndMappingWithTransparentIndirectionMismatch(DatabaseMapping databaseMapping, String string) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 139, objectArray), databaseMapping);
        descriptorException.setErrorCode(139);
        return descriptorException;
    }

    public static DescriptorException returnTypeInGetAttributeAccessor(String string, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 81, objectArray));
        descriptorException.setErrorCode(81);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException securityOnFindMethod(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 82, objectArray), descriptor, exception);
        descriptorException.setErrorCode(82);
        return descriptorException;
    }

    public static DescriptorException securityOnFindObsoleteMethod(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 83, objectArray), descriptor, exception);
        descriptorException.setErrorCode(83);
        return descriptorException;
    }

    public static DescriptorException securityOnInitializingAttributeMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 84, objectArray));
        descriptorException.setErrorCode(84);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException securityWhileConvertingToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 85, objectArray));
        descriptorException.setErrorCode(85);
        descriptorException.setMapping(databaseMapping);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingAttributesInInstanceVariableAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 86, objectArray));
        descriptorException.setErrorCode(86);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingAttributesInMethodAccessor(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 87, objectArray));
        descriptorException.setErrorCode(87);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingClassExtractionMethod(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 88, objectArray), descriptor, exception);
        descriptorException.setErrorCode(88);
        return descriptorException;
    }

    public static DescriptorException classExtractionMethodMustBeStatic(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 194, objectArray), descriptor);
        descriptorException.setErrorCode(194);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingCopyPolicy(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 89, objectArray), descriptor, exception);
        descriptorException.setErrorCode(89);
        return descriptorException;
    }

    public static DescriptorException securityWhileInitializingInstantiationPolicy(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 90, objectArray), descriptor, exception);
        descriptorException.setErrorCode(90);
        return descriptorException;
    }

    public static DescriptorException sequenceNumberPropertyNotSpecified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 91, objectArray), descriptor);
        descriptorException.setErrorCode(91);
        return descriptorException;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static DescriptorException setExistenceCheckingNotUnderstood(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 122, objectArray), descriptor);
        descriptorException.setErrorCode(122);
        return descriptorException;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        if (databaseMapping != null) {
            this.mapping = databaseMapping;
            this.setDescriptor(databaseMapping.getDescriptor());
        }
    }

    public static DescriptorException setMethodParameterTypeNotValid(CollectionMapping collectionMapping) {
        Object[] objectArray = new Object[]{collectionMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 133, objectArray), collectionMapping);
        descriptorException.setErrorCode(133);
        return descriptorException;
    }

    public static DescriptorException sizeMismatchOfForeignKeys(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 92, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(92);
        return descriptorException;
    }

    public static DescriptorException structureNameNotSetInMapping(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 156, objectArray), databaseMapping);
        descriptorException.setErrorCode(156);
        return descriptorException;
    }

    public static DescriptorException tableIsNotPresentInDatabase(Descriptor descriptor) {
        Object[] objectArray = new Object[]{descriptor.getTableName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 142, objectArray), descriptor);
        descriptorException.setErrorCode(142);
        return descriptorException;
    }

    public static DescriptorException tableNotPresent(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 93, objectArray), descriptor);
        descriptorException.setErrorCode(93);
        return descriptorException;
    }

    public static DescriptorException tableNotSpecified(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 94, objectArray), descriptor);
        descriptorException.setErrorCode(94);
        return descriptorException;
    }

    public static DescriptorException targetForeignKeysSizeMismatch(ForeignReferenceMapping foreignReferenceMapping) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 96, objectArray), foreignReferenceMapping);
        descriptorException.setErrorCode(96);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileCloning(Object object, String string, Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{object, string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 97, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(97);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileConstructorInstantiation(Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 168, objectArray), descriptor, exception);
        descriptorException.setErrorCode(168);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileConstructorInstantiationOfFactory(Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 169, objectArray), descriptor, exception);
        descriptorException.setErrorCode(169);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileEventExecution(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 98, objectArray), descriptor, exception);
        descriptorException.setErrorCode(98);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileGettingValueThruMethodAccessor(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 99, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(99);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInstantiatingMethodBasedProxy(Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 100, objectArray));
        descriptorException.setErrorCode(100);
        descriptorException.setInternalException(throwable);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingAttributeMethod(DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 101, objectArray));
        descriptorException.setErrorCode(101);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingFieldToMethod(String string, DatabaseMapping databaseMapping, Throwable throwable) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 102, objectArray));
        descriptorException.setErrorCode(102);
        descriptorException.setInternalException(throwable);
        descriptorException.setMapping(databaseMapping);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileInvokingRowExtractionMethod(DatabaseRow databaseRow, Method method, Descriptor descriptor, Throwable throwable) {
        Object[] objectArray = new Object[]{databaseRow, method};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 103, objectArray), descriptor, throwable);
        descriptorException.setErrorCode(103);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileMethodInstantiation(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 104, objectArray), descriptor, exception);
        descriptorException.setErrorCode(104);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileMethodInstantiationOfFactory(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 175, objectArray), descriptor, exception);
        descriptorException.setErrorCode(175);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileObsoleteEventExecute(String string, Descriptor descriptor, Exception exception) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 105, objectArray), descriptor, exception);
        descriptorException.setErrorCode(105);
        return descriptorException;
    }

    public static DescriptorException targetInvocationWhileSettingValueThruMethodAccessor(String string, Object object, Throwable throwable) {
        Object[] objectArray = new Object[]{string, String.valueOf(object), CR};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 106, objectArray));
        descriptorException.setInternalException(throwable);
        descriptorException.setErrorCode(106);
        return descriptorException;
    }

    public static DescriptorException unsupportedTypeForBidirectionalRelationshipMaintenance(DatabaseMapping databaseMapping, ContainerPolicy containerPolicy) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), containerPolicy};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 179, objectArray), databaseMapping);
        descriptorException.setErrorCode(179);
        return descriptorException;
    }

    public static DescriptorException valueHolderInstantiationMismatch(Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName(), object};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 125, objectArray), databaseMapping);
        descriptorException.setErrorCode(125);
        return descriptorException;
    }

    public static DescriptorException valueNotFoundInClassIndicatorMapping(Descriptor descriptor, Descriptor descriptor2) {
        Object[] objectArray = new Object[]{descriptor};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 108, objectArray), descriptor2);
        descriptorException.setErrorCode(108);
        return descriptorException;
    }

    public static DescriptorException variableOneToOneMappingIsNotDefinedProperly(DatabaseMapping databaseMapping, Descriptor descriptor, String string) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 166, objectArray), databaseMapping);
        descriptorException.setErrorCode(166);
        return descriptorException;
    }

    public static DescriptorException writeLockFieldInChildDescriptor(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 109, objectArray), descriptor);
        descriptorException.setErrorCode(109);
        return descriptorException;
    }

    public static DescriptorException mappingForAttributeIsMissing(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 177, objectArray), descriptor);
        descriptorException.setErrorCode(177);
        return descriptorException;
    }

    public static DescriptorException attributeMappingIsMissingForEntityBean(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 178, objectArray));
        descriptorException.setErrorCode(178);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldTypeConflict(String string, String string2, String string3, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 185, objectArray), descriptor);
        descriptorException.setErrorCode(185);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldInsertConflict(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 186, objectArray), descriptor);
        descriptorException.setErrorCode(186);
        return descriptorException;
    }

    public static DescriptorException returningPolicyAndDescriptorFieldTypeConflict(String string, String string2, String string3, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string, string2, string3};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 187, objectArray), descriptor);
        descriptorException.setErrorCode(187);
        return descriptorException;
    }

    public static DescriptorException returningPolicyUnmappedFieldTypeNotSet(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 188, objectArray), descriptor);
        descriptorException.setErrorCode(188);
        return descriptorException;
    }

    public static DescriptorException returningPolicyMappedFieldTypeNotSet(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 189, objectArray), descriptor);
        descriptorException.setErrorCode(189);
        return descriptorException;
    }

    public static DescriptorException returningPolicyMappingNotSupported(String string, String string2, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 190, objectArray), databaseMapping);
        descriptorException.setErrorCode(190);
        return descriptorException;
    }

    public static DescriptorException returningPolicyFieldNotSupported(String string, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 191, objectArray), descriptor);
        descriptorException.setErrorCode(191);
        return descriptorException;
    }

    public static DescriptorException customQueryAndReturningPolicyFieldConflict(String string, String string2, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 192, objectArray), descriptor);
        descriptorException.setErrorCode(192);
        return descriptorException;
    }

    public static DescriptorException noCustomQueryForReturningPolicy(String string, String string2, Descriptor descriptor) {
        Object[] objectArray = new Object[]{string, string2};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 193, objectArray), descriptor);
        descriptorException.setErrorCode(193);
        return descriptorException;
    }

    public static DescriptorException updateAllFieldsNotSet(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 196, objectArray), descriptor);
        descriptorException.setErrorCode(196);
        return descriptorException;
    }

    public static DescriptorException invalidMappingType(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.getAttributeName()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 197, objectArray), databaseMapping);
        descriptorException.setErrorCode(197);
        return descriptorException;
    }

    public static DescriptorException needToImplementChangeTracker(Descriptor descriptor) {
        Object[] objectArray = new Object[]{descriptor.getJavaClass()};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 198, objectArray), descriptor);
        descriptorException.setErrorCode(198);
        return descriptorException;
    }

    public static DescriptorException needToImplementFetchGroupTracker(Class clazz, Descriptor descriptor) {
        Object[] objectArray = new Object[]{clazz};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 199, objectArray), descriptor);
        descriptorException.setErrorCode(199);
        return descriptorException;
    }

    public static DescriptorException unitOfWorkIsolatedObjectsAccessedInSession(Descriptor descriptor) {
        Object[] objectArray = new Object[]{};
        DescriptorException descriptorException = new DescriptorException(ExceptionMessageGenerator.buildMessage(class$oracle$toplink$exceptions$DescriptorException == null ? (class$oracle$toplink$exceptions$DescriptorException = DescriptorException.class$("oracle.toplink.exceptions.DescriptorException")) : class$oracle$toplink$exceptions$DescriptorException, 201, objectArray), descriptor);
        descriptorException.setErrorCode(201);
        return descriptorException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

