/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ejb.cmp.was.deploy;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import oracle.toplink.ejb.cmp.was.deploy.TopLinkEntityDescriptor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.tools.ejbjar.CmpField;
import oracle.toplink.tools.ejbjar.EjbJar;
import oracle.toplink.tools.ejbjar.EjbJarXMLDocument;
import oracle.toplink.tools.ejbjar.EnterpriseObject;
import oracle.toplink.tools.ejbjar.Entity;
import oracle.toplink.tools.ejbjar.Session;
import oracle.toplink.tools.ejbjar.XMLParser;

public class DeployHelper {
    protected static Vector getDescriptors(String string) throws Exception {
        Vector<DeploymentDescriptor> vector = new Vector<DeploymentDescriptor>();
        XMLParser.allowNonEjb_2_0_DocType();
        Vector vector2 = new EjbJarXMLDocument(string).getEjbJar().getEnterpriseObjects();
        XMLParser.doNotAllowNonEjb_2_0_DocType();
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(DeployHelper.buildDeploymentDescriptor((EnterpriseObject)vector2.elementAt(i)));
        }
        return vector;
    }

    protected static EjbJar getEjbJar(String string) throws Exception {
        Vector vector = new Vector();
        XMLParser.allowNonEjb_2_0_DocType();
        EjbJar ejbJar = new EjbJarXMLDocument(string).getEjbJar();
        XMLParser.doNotAllowNonEjb_2_0_DocType();
        return ejbJar;
    }

    protected static DeploymentDescriptor buildDeploymentDescriptor(EnterpriseObject enterpriseObject) throws Exception {
        Object object = null;
        if (enterpriseObject.isEntity()) {
            Entity entity = (Entity)enterpriseObject;
            TopLinkEntityDescriptor topLinkEntityDescriptor = new TopLinkEntityDescriptor();
            Vector vector = entity.getCmpFields();
            Field[] fieldArray = new Field[entity.getCmpFields().size()];
            Class clazz = PrivilegedAccessController.getClassForName(entity.getEjbClass());
            for (int i = 0; i < vector.size(); ++i) {
                fieldArray[i] = Helper.getDeclaredField(clazz, ((CmpField)vector.elementAt(i)).getFieldName());
            }
            topLinkEntityDescriptor.setContainerManagedFields(fieldArray);
            topLinkEntityDescriptor.setHomeInterfaceClassName(entity.getHome());
            topLinkEntityDescriptor.setRemoteInterfaceClassName(entity.getRemote());
            topLinkEntityDescriptor.setPrimaryKeyClassName(entity.getPrimaryKeyClass());
            topLinkEntityDescriptor.setReentrant(entity.getReentrant());
            topLinkEntityDescriptor.setPrimaryKeyFieldName(entity.getPrimaryKeyField());
            object = topLinkEntityDescriptor;
        } else if (enterpriseObject.isSession()) {
            SessionDescriptor sessionDescriptor = new SessionDescriptor();
            Session session = (Session)enterpriseObject;
            if (session.getSessionType().equals("Stateful")) {
                sessionDescriptor.setStateManagementType(1);
            } else {
                sessionDescriptor.setStateManagementType(0);
            }
            sessionDescriptor.setHomeInterfaceClassName(session.getHome());
            sessionDescriptor.setRemoteInterfaceClassName(session.getRemote());
            object = sessionDescriptor;
        }
        object.setEnterpriseBeanClassName(enterpriseObject.getEjbClass());
        return object;
    }

    protected static String[] parseJarErrors(String[] stringArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("IVJ0828E") >= 0 || stringArray[i].indexOf("IVJ0824E") >= 0 || !bl) continue;
            vector.addElement(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static String[] parseEntityBeanErrors(String[] stringArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("IVJ0513W") >= 0 || bl || stringArray[i].indexOf("IVJ0526E") >= 0 || stringArray[i].indexOf("IVJ0543E") >= 0 || stringArray[i].indexOf("IVJ0550W") >= 0 || stringArray[i].indexOf("IVJ0525E") >= 0) continue;
            vector.addElement(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String removeTrailingFileSeparator(String string) {
        String string2 = string.trim();
        if (string2 == "") {
            return string2;
        }
        char c = string2.charAt(string2.length() - 1);
        if (c == File.separatorChar || c == '\\' || c == '/') {
            string2 = string2.length() > 1 ? string2.substring(0, string2.length() - 1) : "";
        }
        return string2;
    }
}

