/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.interactions;

import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.EISMappedRecord;
import oracle.toplink.eis.interactions.EISInteraction;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sessions.DatabaseRecord;

public class IndexedInteraction
extends EISInteraction {
    public void addArgument(String string) {
        this.getArguments().addElement(new DatabaseField(string));
    }

    public void addArgumentValue(Object object) {
        this.getArguments().addElement(object);
    }

    public void addOutputArgument(String string) {
        this.getOutputArguments().addElement(new DatabaseField(string));
    }

    public Vector getArguments() {
        return super.getArguments();
    }

    public Vector getOutputArguments() {
        return super.getOutputArguments();
    }

    public void setArguments(Vector vector) {
        super.setArguments(vector);
    }

    public void setOutputArguments(Vector vector) {
        super.setOutputArguments(vector);
    }

    public Record createInputRecord(EISAccessor eISAccessor) {
        try {
            IndexedRecord indexedRecord = eISAccessor.getRecordFactory().createIndexedRecord(this.getInputRecordName());
            for (int i = 0; i < this.getParameters().size(); ++i) {
                Object e = this.getParameters().get(i);
                indexedRecord.add(this.createRecordElement("", e, eISAccessor));
            }
            return indexedRecord;
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public DatabaseRow buildRow(Record record, EISAccessor eISAccessor) {
        DatabaseRow databaseRow = null;
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            databaseRow = new DatabaseRecord(indexedRecord.size());
            for (int i = 0; i < indexedRecord.size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                databaseRow.put(databaseField, indexedRecord.get(i));
            }
        } else if (record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            if (this.getOutputArgumentNames().size() == 1) {
                mappedRecord = (MappedRecord)mappedRecord.get(this.getOutputArgumentNames().get(0));
            } else if (this.getOutputArgumentNames().size() > 1) {
                databaseRow = new DatabaseRecord(this.getOutputArgumentNames().size());
                for (int i = 0; i < this.getOutputArgumentNames().size(); ++i) {
                    DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                    databaseRow.put(databaseField, mappedRecord.get(this.getOutputArgumentNames().get(i)));
                }
                return databaseRow;
            }
            databaseRow = new EISMappedRecord((Map)mappedRecord, eISAccessor);
        } else {
            databaseRow = new DatabaseRecord(1);
            databaseRow.put(this.getOutputResultPath(), (Object)record);
        }
        return databaseRow;
    }
}

