/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISDOMRecord;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.RecordConverter;
import oracle.toplink.eis.interactions.EISInteraction;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.queryframework.Call;
import org.w3c.dom.Element;

public class EISPlatform
extends DatasourcePlatform {
    protected boolean isIndexedRecordSupported;
    protected boolean isMappedRecordSupported;
    protected boolean isDOMRecordSupported;
    protected boolean shouldConvertDataToStrings;
    protected boolean supportsLocalTransactions;
    protected boolean requiresAutoCommit;
    protected RecordConverter recordConverter;
    protected Method domMethod;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public EISPlatform() {
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(false);
        this.setShouldConvertDataToStrings(false);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(false);
    }

    public RecordConverter getRecordConverter() {
        return this.recordConverter;
    }

    public void setRecordConverter(RecordConverter recordConverter) {
        this.recordConverter = recordConverter;
    }

    public boolean requiresAutoCommit() {
        return this.requiresAutoCommit;
    }

    public void setRequiresAutoCommit(boolean bl) {
        this.requiresAutoCommit = bl;
    }

    public boolean supportsLocalTransactions() {
        return this.supportsLocalTransactions;
    }

    public void setSupportsLocalTransactions(boolean bl) {
        this.supportsLocalTransactions = bl;
    }

    public boolean isIndexedRecordSupported() {
        return this.isIndexedRecordSupported;
    }

    public void setIsIndexedRecordSupported(boolean bl) {
        this.isIndexedRecordSupported = bl;
    }

    public boolean isMappedRecordSupported() {
        return this.isMappedRecordSupported;
    }

    public void setIsMappedRecordSupported(boolean bl) {
        this.isMappedRecordSupported = bl;
    }

    public boolean isDOMRecordSupported() {
        return this.isDOMRecordSupported;
    }

    public void setIsDOMRecordSupported(boolean bl) {
        this.isDOMRecordSupported = bl;
    }

    public boolean shouldConvertDataToStrings() {
        return this.shouldConvertDataToStrings;
    }

    public void setShouldConvertDataToStrings(boolean bl) {
        this.shouldConvertDataToStrings = bl;
    }

    public InteractionSpec buildInteractionSpec(EISInteraction eISInteraction) {
        return eISInteraction.getInteractionSpec();
    }

    public Record createInputRecord(EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Record record = eISInteraction.createInputRecord(eISAccessor);
        if (this.getRecordConverter() != null) {
            record = this.getRecordConverter().converterToAdapterRecord(record);
        }
        return record;
    }

    public Record createOutputRecord(EISInteraction eISInteraction, EISAccessor eISAccessor) {
        return null;
    }

    public DatabaseRow buildRow(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Record record2 = record;
        if (this.getRecordConverter() != null) {
            record2 = this.getRecordConverter().converterFromAdapterRecord(record2);
        }
        return eISInteraction.buildRow(record2, eISAccessor);
    }

    public Vector buildRows(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Record record2 = record;
        if (this.getRecordConverter() != null) {
            record2 = this.getRecordConverter().converterFromAdapterRecord(record2);
        }
        return eISInteraction.buildRows(record2, eISAccessor);
    }

    public Record createDOMRecord(String string, EISAccessor eISAccessor) {
        try {
            return eISAccessor.getRecordFactory().createMappedRecord(string);
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public DatabaseRow createDatabaseRowFromDOMRecord(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        return new EISDOMRecord(record);
    }

    public Object getValueFromRecord(String string, MappedRecord mappedRecord, EISAccessor eISAccessor) {
        return mappedRecord.get((Object)string);
    }

    public void setDOMInRecord(Element element, Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        Object[] objectArray;
        if (this.domMethod == null) {
            objectArray = new Class[]{class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = EISPlatform.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element};
            try {
                this.domMethod = PrivilegedAccessController.getMethod(record.getClass(), "setDom", (Class[])objectArray, false);
            }
            catch (Exception exception) {
                try {
                    this.domMethod = PrivilegedAccessController.getMethod(record.getClass(), "setDOM", (Class[])objectArray, false);
                }
                catch (Exception exception2) {
                    throw new EISException(exception2);
                }
            }
        }
        try {
            objectArray = new Object[]{element};
            PrivilegedAccessController.invokeMethod(this.domMethod, record, objectArray);
        }
        catch (Exception exception) {
            throw new EISException(exception);
        }
    }

    public void setValueInRecord(String string, Object object, MappedRecord mappedRecord, EISAccessor eISAccessor) {
        Object object2 = object;
        if (this.shouldConvertDataToStrings()) {
            object2 = this.getConversionManager().convertObject(object, ClassConstants.STRING);
        }
        mappedRecord.put((Object)string, object2);
    }

    public void appendParameter(Call call, Writer writer, Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                this.appendParameter(call, writer, vector.elementAt(i));
            }
        } else if (object instanceof DOMRecord) {
            String string = ((DOMRecord)object).transformToXML();
            int n = string.indexOf(62);
            string = string.substring(n + 1, string.length());
            try {
                writer.write(string);
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        } else {
            super.appendParameter(call, writer, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

