/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;

public class InterfacePolicy
implements Serializable {
    protected Vector parentInterfaces;
    protected Vector parentInterfaceNames;
    protected Vector parentDescriptors;
    protected Vector childDescriptors = NonSynchronizedVector.newInstance();
    protected Descriptor descriptor;
    protected Class implementorDescriptor;
    protected String implementorDescriptorClassName;

    public InterfacePolicy() {
        this.parentInterfaces = NonSynchronizedVector.newInstance(2);
        this.parentInterfaceNames = NonSynchronizedVector.newInstance(2);
        this.parentDescriptors = NonSynchronizedVector.newInstance(2);
    }

    public InterfacePolicy(Descriptor descriptor) {
        this();
        this.descriptor = descriptor;
    }

    public void addChildDescriptor(Descriptor descriptor) {
        this.getChildDescriptors().addElement(descriptor);
    }

    public void addParentDescriptor(Descriptor descriptor) {
        this.getParentDescriptors().addElement(descriptor);
    }

    public void addParentInterface(Class clazz) {
        this.getParentInterfaces().addElement(clazz);
    }

    public void addParentInterfaceName(String string) {
        this.getParentInterfaceNames().addElement(string);
    }

    public Vector getChildDescriptors() {
        return this.childDescriptors;
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getImplementorDescriptor() {
        return this.implementorDescriptor;
    }

    public String getImplementorDescriptorClassName() {
        if (this.implementorDescriptorClassName == null && this.implementorDescriptor != null) {
            this.implementorDescriptorClassName = this.implementorDescriptor.getName();
        }
        return this.implementorDescriptorClassName;
    }

    public Vector getParentDescriptors() {
        return this.parentDescriptors;
    }

    public Vector getParentInterfaces() {
        return this.parentInterfaces;
    }

    public Vector getParentInterfaceNames() {
        if (this.parentInterfaceNames.isEmpty() && !this.parentInterfaces.isEmpty()) {
            for (int i = 0; i < this.parentInterfaces.size(); ++i) {
                this.parentInterfaceNames.addElement(((Class)this.parentInterfaces.elementAt(i)).getName());
            }
        }
        return this.parentInterfaceNames;
    }

    public void initialize(Session session) {
    }

    public boolean isInterfaceChildDescriptor() {
        return this.parentInterfaces != null && !this.parentInterfaces.isEmpty() || this.parentInterfaceNames != null && !this.parentInterfaceNames.isEmpty();
    }

    public Object selectAllObjectsUsingMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException {
        ContainerPolicy containerPolicy = readAllQuery.getContainerPolicy();
        Object object = containerPolicy.containerInstance(1);
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            ReadAllQuery readAllQuery2 = (ReadAllQuery)readAllQuery.clone();
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            Class clazz = descriptor.getJavaClass();
            readAllQuery2.setReferenceClass(clazz);
            readAllQuery2.setDescriptor(descriptor);
            object = containerPolicy.concatenateContainers(object, readAllQuery.getSession().executeQuery(readAllQuery2));
        }
        return object;
    }

    public Object selectOneObjectUsingMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException, QueryException {
        Object object = null;
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements() && object == null) {
            ReadObjectQuery readObjectQuery2 = (ReadObjectQuery)readObjectQuery.clone();
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            Class clazz = descriptor.getJavaClass();
            readObjectQuery2.setReferenceClass(clazz);
            readObjectQuery2.setDescriptor(descriptor);
            object = readObjectQuery.getSession().executeQuery(readObjectQuery2);
        }
        return object;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setImplementorDescriptor(Class clazz) {
        this.implementorDescriptor = clazz;
    }

    public void setImplementorDescriptorClassName(String string) {
        this.implementorDescriptorClassName = string;
    }

    public void setParentInterfaces(Vector vector) {
        this.parentInterfaces = vector;
    }

    public void setParentInterfaceNames(Vector vector) {
        this.parentInterfaceNames = vector;
    }

    public boolean usesImplementorDescriptor() {
        return this.implementorDescriptor != null;
    }
}

