/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Projet
#	Fichier  : CompteDialogue.java
#	Class    : CompteDialogue
*/

// Le fichier CompteDialogue.java se trouve dans le répertoire 
// Sources/Projet/Chapitre12/NetBeansProjects/ProjetChapitre12/src/Projet

package Projet;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class CompteDialogue extends javax.swing.JFrame {
  // Définition des propriétés
  String typeCompte="Courant";
  String numeroCompte = " " ;

    public CompteDialogue(String cpt) {
        initComponents();
        // Afficher le numéro de compte dans le cadre du composant
        Border cadre = BorderFactory.createTitledBorder("   Compte n° : " + cpt + "   " );
        boiteMenu.setBorder(cadre);
        setBounds(500, 130,470, 390);
        setVisible(true);
        // Afficher une image en fond de fenêtre
        ImageIcon iconPhoto = new ImageIcon("Ressources/FondCompte.png");
        photoFond.setIcon(iconPhoto);
        creerGroupeBox();
        numeroCompte = cpt;
    }
    
    private void creerGroupeBox() {   
       compteGrp.add(entreprise);
       compteGrp.add(courant);
       courant.setSelected(true);
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        compteGrp = new javax.swing.ButtonGroup();
        boiteMenu = new javax.swing.JPanel();
        courant = new javax.swing.JCheckBox();
        entreprise = new javax.swing.JCheckBox();
        valeurAsaisir = new javax.swing.JTextField();
        btnOK = new javax.swing.JButton();
        labelSolde = new javax.swing.JLabel();
        labelEuros = new javax.swing.JLabel();
        photoFond = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Créer un compte");
        setBackground(new java.awt.Color(190, 190, 190));
        setResizable(false);

        boiteMenu.setBorder(javax.swing.BorderFactory.createTitledBorder("   Comptes   "));

        courant.setText("Compte Courant");
        courant.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                courantActionPerformed(evt);
            }
        });

        entreprise.setText("Compte Entreprise");
        entreprise.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                entrepriseActionPerformed(evt);
            }
        });

        valeurAsaisir.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        valeurAsaisir.setText("0");

        btnOK.setText("OK");
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOKActionPerformed(evt);
            }
        });

        labelSolde.setText("Solde :");

        labelEuros.setText("Euros");

        org.jdesktop.layout.GroupLayout boiteMenuLayout = new org.jdesktop.layout.GroupLayout(boiteMenu);
        boiteMenu.setLayout(boiteMenuLayout);
        boiteMenuLayout.setHorizontalGroup(
            boiteMenuLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(boiteMenuLayout.createSequentialGroup()
                .addContainerGap()
                .add(boiteMenuLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(boiteMenuLayout.createSequentialGroup()
                        .add(labelSolde)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(valeurAsaisir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 77, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(labelEuros)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(btnOK))
                    .add(boiteMenuLayout.createSequentialGroup()
                        .add(courant)
                        .add(40, 40, 40)
                        .add(entreprise)))
                .addContainerGap(36, Short.MAX_VALUE))
        );
        boiteMenuLayout.setVerticalGroup(
            boiteMenuLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(boiteMenuLayout.createSequentialGroup()
                .addContainerGap()
                .add(boiteMenuLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(courant)
                    .add(entreprise))
                .add(37, 37, 37)
                .add(boiteMenuLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(labelSolde)
                    .add(labelEuros)
                    .add(valeurAsaisir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(btnOK))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        photoFond.setText("jLabel1");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(145, 145, 145)
                        .add(photoFond))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(boiteMenu, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(914, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(boiteMenu, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(photoFond)
                .addContainerGap(306, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void btnOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
    // Récupérer la valeur du montant déposé à l’ouverture du compte
    double valeurInitiale = Double.parseDouble(valeurAsaisir.getText()); 
    // Créer un objet de type Compte à l’aide de son constructeur.
    Compte unCompte = new Compte(numeroCompte, typeCompte, valeurInitiale) ;   
    // unCompte.afficher();
    // Enregistrer le compte dans un fichier objet dont le nom porte le numéro du compte suivi de l’extension .dat
    FichierCompte fc = new FichierCompte();
    fc.ouvrir("Comptes/"+numeroCompte+".dat","W");
    fc.ecrire(unCompte);
    fc.fermer();
    // Fermer la fenêtre en cours sans quitter l’application.
    this.dispose();
}//GEN-LAST:event_btnOKActionPerformed

private void entrepriseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_entrepriseActionPerformed
       // Initialiser le type du compte à "Entreprise"
       typeCompte="Entreprise";
}//GEN-LAST:event_entrepriseActionPerformed

private void courantActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_courantActionPerformed
     // Initialiser le type du compte à "Courant"
    typeCompte="Courant";
}//GEN-LAST:event_courantActionPerformed

    /**
    * @param args the command line arguments
    */
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel boiteMenu;
    private javax.swing.JButton btnOK;
    private javax.swing.ButtonGroup compteGrp;
    private javax.swing.JCheckBox courant;
    private javax.swing.JCheckBox entreprise;
    private javax.swing.JLabel labelEuros;
    private javax.swing.JLabel labelSolde;
    private javax.swing.JLabel photoFond;
    private javax.swing.JTextField valeurAsaisir;
    // End of variables declaration//GEN-END:variables

}
