/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Un éditeur pour dessiner
#	Fichier  : Main.java
#	Class    : Main
*/
// Le fichier Main.java se trouve dans le répertoire 
// Sources/Exemples/Chapitre12/NetBeansProjects/EditeurExemple/src/Introduction
package Introduction;

import javax.swing.ImageIcon;

public class Main extends javax.swing.JFrame {
   // Les fichiers d'icônes se trouvent dans le répertoire
  // Sources/Exemples/Chapitre12/NetBeansProjects/EditeurExemple/Ressources 
   private String url="Ressources/";
   // - la liste d’affichage liste
   private ListeDeFormes liste; 
   // - la feuille de dessins : page
   private FeuilleDeDessins page;
   // Le constructeur de la classe Main()
   public Main() {
      // définition de la taille de la fenêtre de l’éditeur
      setBounds(100, 100,600, 600);
      // Afficher les composants et leurs gestionnaires d’événements créés dans la fenêtre Design.
      initComponents(); 
      // Créer une liste d’affichage vide
      liste = new ListeDeFormes();
      // Créer une feuille de dessin 
      page = new FeuilleDeDessins(liste);
      //  Insérer la page dans le composant boiteDessin,créé dans la fenêtre Design
      boiteDessin.add(page);
      // Définitions de la boîte à outils
       creerThemeForme();
       creerThemeCouleur();
       creerThemeEffacer();         
    }
    
    private void creerThemeForme() {   
      // Ajouter le bouton cercle au groupe groupeForme
      groupeForme.add(cercle);
      // Ajouter le bouton rectangle au groupe groupeForme
      groupeForme.add(rectangle);
      // Le bouton cercle est affiché comme sélectionné
      cercle.setSelected(true);
      // Placer une image sous forme d'icône sur le bouton cercle 
      ImageIcon iconPhoto = new ImageIcon(url+"cercle.png");
      cercle.setIcon(iconPhoto);
      // Afficher une info bulle au survol du bouton
      cercle.setToolTipText("Dessiner des cercles");
      // Placer une image sous forme d'icône sur le bouton rectangle 
      iconPhoto = new ImageIcon(url+"rectangle.png");
      rectangle.setIcon(iconPhoto);
      // Afficher une info bulle au survol du bouton
      rectangle.setToolTipText("Dessiner des rectangles"); 
    }
    private void creerThemeEffacer() { 
        // Placer une image sous forme d'icône sur le bouton effacer          
       ImageIcon iconPhoto = new ImageIcon(url+"poubelle.png");
       effacer.setIcon(iconPhoto);
       // Afficher une info bulle au survol du bouton
       effacer.setToolTipText("Tout effacer");
        // Placer une image sous forme d'icône sur le bouton undo          
       iconPhoto = new ImageIcon(url+"undo.png");
       undo.setIcon(iconPhoto);
       // Afficher une info bulle au survol du bouton
       undo.setToolTipText("Effacer le dernier");      
    }
   private void creerThemeCouleur() {
     // Insérer les boutons rouge, vert, bleu, … dans le groupe de bouton groupeCouleur.
     groupeCouleur.add(rouge);
     groupeCouleur.add(vert);
     groupeCouleur.add(bleu);
     groupeCouleur.add(blanc);
     groupeCouleur.add(noir);
     // La couleur noire est sélectionnée par défaut
     noir.setSelected(true);
     // Placer l’image rouge.png sur le bouton rouge
     ImageIcon iconPhoto = new ImageIcon(url+"rouge.png");
     rouge.setIcon(iconPhoto);
     rouge.setToolTipText("Peindre en rouge");
     // Placer l’image vert.png sur le bouton vert
     iconPhoto = new ImageIcon(url+"vert.png");
     vert.setIcon(iconPhoto);
     vert.setToolTipText("Peindre en vert");
     // Placer l’image bleu.png sur le bouton bleu
     iconPhoto = new ImageIcon(url+"bleu.png");
     bleu.setToolTipText("Peindre en bleu");
     bleu.setIcon(iconPhoto);  
     // Placer l’image blanc.png sur le bouton blanc
     iconPhoto = new ImageIcon(url+"blanc.png");
     blanc.setToolTipText("Peindre en blanc");
     blanc.setIcon(iconPhoto);
     // Placer l’image noir.png sur le bouton noir
     iconPhoto = new ImageIcon(url+"noir.png");
     noir.setToolTipText("Peindre en noir");
     noir.setIcon(iconPhoto);
}  

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupeCouleur = new javax.swing.ButtonGroup();
        groupeForme = new javax.swing.ButtonGroup();
        boiteDessin = new javax.swing.JPanel();
        boiteOutils = new javax.swing.JToolBar();
        cercle = new javax.swing.JToggleButton();
        rectangle = new javax.swing.JToggleButton();
        separeUn = new javax.swing.JToolBar.Separator();
        undo = new javax.swing.JButton();
        effacer = new javax.swing.JButton();
        separeDeux = new javax.swing.JToolBar.Separator();
        rouge = new javax.swing.JToggleButton();
        vert = new javax.swing.JToggleButton();
        bleu = new javax.swing.JToggleButton();
        blanc = new javax.swing.JToggleButton();
        noir = new javax.swing.JToggleButton();
        barreMenu = new javax.swing.JMenuBar();
        menuFichier = new javax.swing.JMenu();
        itemNouveau = new javax.swing.JMenuItem();
        itemOuvrir = new javax.swing.JMenuItem();
        itemSauver = new javax.swing.JMenuItem();
        itemQuitter = new javax.swing.JMenuItem();
        menuAide = new javax.swing.JMenu();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Editeur graphique");

        org.jdesktop.layout.GroupLayout boiteDessinLayout = new org.jdesktop.layout.GroupLayout(boiteDessin);
        boiteDessin.setLayout(boiteDessinLayout);
        boiteDessinLayout.setHorizontalGroup(
            boiteDessinLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 457, Short.MAX_VALUE)
        );
        boiteDessinLayout.setVerticalGroup(
            boiteDessinLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 377, Short.MAX_VALUE)
        );

        boiteOutils.setRollover(true);

        cercle.setSelected(true);
        cercle.setContentAreaFilled(false);
        cercle.setFocusable(false);
        cercle.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        cercle.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        cercle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cercleActionPerformed(evt);
            }
        });
        boiteOutils.add(cercle);

        rectangle.setFocusable(false);
        rectangle.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        rectangle.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        rectangle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rectangleActionPerformed(evt);
            }
        });
        boiteOutils.add(rectangle);
        boiteOutils.add(separeUn);

        undo.setBorderPainted(false);
        undo.setContentAreaFilled(false);
        undo.setFocusable(false);
        undo.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        undo.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        boiteOutils.add(undo);

        effacer.setBorderPainted(false);
        effacer.setContentAreaFilled(false);
        effacer.setFocusable(false);
        effacer.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        effacer.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        effacer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                effacerActionPerformed(evt);
            }
        });
        boiteOutils.add(effacer);
        boiteOutils.add(separeDeux);

        rouge.setFocusable(false);
        rouge.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        rouge.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        rouge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rougeActionPerformed(evt);
            }
        });
        boiteOutils.add(rouge);

        vert.setFocusable(false);
        vert.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        vert.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        vert.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vertActionPerformed(evt);
            }
        });
        boiteOutils.add(vert);

        bleu.setFocusable(false);
        bleu.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        bleu.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        bleu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bleuActionPerformed(evt);
            }
        });
        boiteOutils.add(bleu);

        blanc.setFocusable(false);
        blanc.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        blanc.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        blanc.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                blancActionPerformed(evt);
            }
        });
        boiteOutils.add(blanc);

        noir.setSelected(true);
        noir.setFocusable(false);
        noir.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        noir.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        noir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                noirActionPerformed(evt);
            }
        });
        boiteOutils.add(noir);

        menuFichier.setText("Fichier");

        itemNouveau.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
        itemNouveau.setText("Nouveau");
        itemNouveau.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itemNouveauActionPerformed(evt);
            }
        });
        menuFichier.add(itemNouveau);

        itemOuvrir.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
        itemOuvrir.setText("Ouvrir");
        itemOuvrir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itemOuvrirActionPerformed(evt);
            }
        });
        menuFichier.add(itemOuvrir);

        itemSauver.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        itemSauver.setText("Enregistrer");
        itemSauver.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itemSauverActionPerformed(evt);
            }
        });
        menuFichier.add(itemSauver);

        itemQuitter.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, java.awt.event.InputEvent.CTRL_MASK));
        itemQuitter.setText("Quitter");
        itemQuitter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itemQuitterActionPerformed(evt);
            }
        });
        menuFichier.add(itemQuitter);

        barreMenu.add(menuFichier);

        menuAide.setText("Aide");
        barreMenu.add(menuAide);

        setJMenuBar(barreMenu);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(boiteOutils, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 490, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(boiteDessin, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(20, 20, 20)
                .add(boiteOutils, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 41, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(boiteDessin, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void noirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_noirActionPerformed
  // Initialiser la propriété couleur de la classe FeuilleDeDessins à Forme.NOIR
  page.setCouleur(Forme.NOIR);
}//GEN-LAST:event_noirActionPerformed

private void blancActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_blancActionPerformed
  // Initialiser la propriété couleur de la classe FeuilleDeDessins à Forme.BLANC
  page.setCouleur(Forme.BLANC);
}//GEN-LAST:event_blancActionPerformed

private void bleuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bleuActionPerformed
  // Initialiser la propriété couleur de la classe FeuilleDeDessins à Forme.BLEU
  page.setCouleur(Forme.BLEU);
}//GEN-LAST:event_bleuActionPerformed

private void vertActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vertActionPerformed
  // Initialiser la propriété couleur de la classe FeuilleDeDessins à Forme.VERT
  page.setCouleur(Forme.VERT);
}//GEN-LAST:event_vertActionPerformed

private void rougeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rougeActionPerformed
  // Initialiser la propriété couleur de la classe FeuilleDeDessins à Forme.ROUGE
  page.setCouleur(Forme.ROUGE);

}//GEN-LAST:event_rougeActionPerformed

private void effacerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_effacerActionPerformed
    // Vider la liste des formes
    liste.supprimerLesFormes();
    // Dessiner la page vide de formes
    page.dessinerLesFormes(liste);
}//GEN-LAST:event_effacerActionPerformed

private void rectangleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rectangleActionPerformed
  // Initialiser la propriété forme de la classe FeuilleDeDessins à "rectangle" 
  page.setForme("rectangle");
}//GEN-LAST:event_rectangleActionPerformed

private void cercleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cercleActionPerformed
  // Initialiser la propriété forme de la classe FeuilleDeDessins à "cercle"
  page.setForme("cercle");
}//GEN-LAST:event_cercleActionPerformed

private void itemSauverActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itemSauverActionPerformed
    // Ouvrir le fichier Formes.txt en écriture
    Fichier f = new Fichier();
    f.ouvrir("Formes.txt", "W");
    // Enregistrer la liste dans le fichier ouvert
    if (liste != null)  liste.enregistrerLesFormes(f);
    // Fermer le fichier
    f.fermer();
}//GEN-LAST:event_itemSauverActionPerformed

private void itemOuvrirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itemOuvrirActionPerformed
     // Supprimer les formes de la liste
     if (liste != null) liste.supprimerLesFormes();
      // Ouvrir le fichier Formes.txt en lecture
     Fichier f = new Fichier();
     if (f.ouvrir("Formes.txt", "R")) {
        // Si le fichier existe, stocker les formes dans la liste
        liste.lireLesFormes(f);
        // Fermer le fichier
        f.fermer();
        // Dessiner la page avec la nouvelle liste
        page.dessinerLesFormes(liste);
     }
}//GEN-LAST:event_itemOuvrirActionPerformed

private void itemQuitterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itemQuitterActionPerformed
    // Quitter l'application
    System.exit(0);
}//GEN-LAST:event_itemQuitterActionPerformed

private void itemNouveauActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itemNouveauActionPerformed
     // Si la liste des forme n'est pas vide,, la vider
     if (liste != null)  liste.supprimerLesFormes();
     // Afficher la page vide de formes
      page.dessinerLesFormes(liste);   
}//GEN-LAST:event_itemNouveauActionPerformed
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar barreMenu;
    private javax.swing.JToggleButton blanc;
    private javax.swing.JToggleButton bleu;
    private javax.swing.JPanel boiteDessin;
    private javax.swing.JToolBar boiteOutils;
    private javax.swing.JToggleButton cercle;
    private javax.swing.JButton effacer;
    private javax.swing.ButtonGroup groupeCouleur;
    private javax.swing.ButtonGroup groupeForme;
    private javax.swing.JMenuItem itemNouveau;
    private javax.swing.JMenuItem itemOuvrir;
    private javax.swing.JMenuItem itemQuitter;
    private javax.swing.JMenuItem itemSauver;
    private javax.swing.JMenu menuAide;
    private javax.swing.JMenu menuFichier;
    private javax.swing.JToggleButton noir;
    private javax.swing.JToggleButton rectangle;
    private javax.swing.JToggleButton rouge;
    private javax.swing.JToolBar.Separator separeDeux;
    private javax.swing.JToolBar.Separator separeUn;
    private javax.swing.JButton undo;
    private javax.swing.JToggleButton vert;
    // End of variables declaration//GEN-END:variables

}
